/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import java.io.UnsupportedEncodingException;

public class MarshallStringUtils {
    private static final String copyright = "Copyright IBM Corporation 2001, 2017.";
    public static final int STRING_JUSTIFICATION_LEFT = 0;
    public static final int STRING_JUSTIFICATION_RIGHT = 1;
    public static final int STRING_JUSTIFICATION_CENTER = 2;
    private static final char DBCS_SPACE_CHAR = '\u3000';
    private static final String DBCS_SPACE_STRING = "\u3000";

    public static void marshallCharInfoBuffer(char value, byte[] buffer, int startingOffset, int size, String codePage) throws IllegalArgumentException {
        String valueStr = new Character(value).toString();
        byte[] tb = null;
        try {
            tb = valueStr.getBytes(codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        if (tb.length > size) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", valueStr, Integer.toString(size)));
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
        int i = tb.length;
        while (i < size) {
            buffer[startingOffset + i] = 0;
            ++i;
        }
    }

    public static int marshallFixedLengthDBCSStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size, int justification, String padCharStr, boolean DBCSOnly) throws IllegalArgumentException {
        int padLength;
        if (DBCSOnly) {
            value = value.replace(' ', '\u3000');
        }
        byte[] tb = null;
        try {
            tb = value.getBytes(codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        int bytesMarshalled = tb.length;
        int start = 0;
        if (DBCSOnly && tb.length != 0) {
            if (tb[0] == 14) {
                if (bytesMarshalled - 2 > size) {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
                }
                start = 1;
                bytesMarshalled -= 2;
            } else if (bytesMarshalled > size) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
            }
        } else if (bytesMarshalled > size) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
        }
        int bytesToCopy = bytesMarshalled;
        switch (justification) {
            case 0: {
                System.arraycopy(tb, start, buffer, startingOffset, bytesToCopy);
                break;
            }
            case 1: {
                int offset = size - bytesToCopy;
                System.arraycopy(tb, start, buffer, startingOffset + offset, bytesToCopy);
                bytesMarshalled = size;
                break;
            }
            case 2: {
                int offset = (size - bytesToCopy) / 2;
                System.arraycopy(tb, start, buffer, startingOffset + offset, bytesToCopy);
                bytesMarshalled = size;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(justification)));
            }
        }
        if (padCharStr != null && (padLength = size - bytesToCopy) > 0) {
            bytesMarshalled = size;
            byte[] padArray = null;
            if (DBCSOnly && " ".equals(padCharStr)) {
                padCharStr = DBCS_SPACE_STRING;
            }
            try {
                padArray = padCharStr.getBytes(codePage);
                if (padArray.length > 0 && padArray[0] == 14) {
                    int startIndex = 1;
                    int length = padArray.length - 1;
                    if (padArray[length] == 15) {
                        --length;
                    }
                    byte[] newPadArray = new byte[length];
                    System.arraycopy(padArray, startIndex, newPadArray, 0, length);
                    padArray = newPadArray;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            switch (justification) {
                case 0: {
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset + bytesToCopy, padLength);
                    break;
                }
                case 1: {
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset, padLength);
                    break;
                }
                case 2: {
                    int startBytes = padLength / 2;
                    int endBytes = padLength - startBytes;
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset, startBytes);
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset + bytesToCopy, endBytes);
                }
            }
        }
        return bytesMarshalled;
    }

    public static int marshallFixedLengthStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int size, int justification, String padCharStr) throws IllegalArgumentException {
        int padLength;
        byte[] tb = null;
        try {
            tb = value.getBytes(codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        int bytesMarshalled = tb.length;
        if (bytesMarshalled > size) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
        }
        switch (justification) {
            case 0: {
                System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
                break;
            }
            case 1: {
                int offset = size - tb.length;
                System.arraycopy(tb, 0, buffer, startingOffset + offset, tb.length);
                bytesMarshalled = size;
                break;
            }
            case 2: {
                bytesMarshalled = size;
                int offset = (size - tb.length) / 2;
                System.arraycopy(tb, 0, buffer, startingOffset + offset, tb.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(justification)));
            }
        }
        if (padCharStr != null && (padLength = size - tb.length) > 0) {
            bytesMarshalled = size;
            byte[] padArray = null;
            try {
                padArray = padCharStr.getBytes(codePage);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            switch (justification) {
                case 0: {
                    ConversionUtils.fillBytes(padArray[0], buffer, startingOffset + tb.length, padLength);
                    break;
                }
                case 1: {
                    ConversionUtils.fillBytes(padArray[0], buffer, startingOffset, padLength);
                    break;
                }
                case 2: {
                    int startBytes = padLength / 2;
                    int endBytes = padLength - startBytes;
                    ConversionUtils.fillBytes(padArray[0], buffer, startingOffset, startBytes);
                    ConversionUtils.fillBytes(padArray[0], buffer, startingOffset + tb.length, endBytes);
                }
            }
        }
        return bytesMarshalled;
    }

    public static void marshallLengthPrefixedDBCSStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size, int justification, String padCharStr, boolean bigEndian, int prefixLength, boolean DBCSOnly) throws IllegalArgumentException {
        int numBytes = MarshallStringUtils.marshallFixedLengthDBCSStringIntoBuffer(value, buffer, startingOffset + prefixLength, codePage, charSize, size - prefixLength, justification, padCharStr, DBCSOnly);
        byte[] tb = null;
        switch (prefixLength) {
            case 4: {
                tb = ConversionUtils.convertToByte(numBytes / charSize);
                break;
            }
            case 2: {
                tb = ConversionUtils.convertToByte((short)numBytes / charSize);
                break;
            }
            case 8: {
                tb = ConversionUtils.convertToByte((long)numBytes / (long)charSize);
                break;
            }
            case 1: {
                tb = new byte[]{(byte)(numBytes / charSize)};
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(prefixLength)));
            }
        }
        if (!bigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallLengthPrefixedStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int size, int justification, String padCharStr, boolean bigEndian, int prefixLength) throws IllegalArgumentException {
        int numBytes = MarshallStringUtils.marshallFixedLengthStringIntoBuffer(value, buffer, startingOffset + prefixLength, codePage, size - prefixLength, justification, padCharStr);
        byte[] tb = null;
        switch (prefixLength) {
            case 4: {
                tb = ConversionUtils.convertToByte(numBytes);
                break;
            }
            case 2: {
                tb = ConversionUtils.convertToByte((short)numBytes);
                break;
            }
            case 8: {
                tb = ConversionUtils.convertToByte((long)numBytes);
                break;
            }
            case 1: {
                tb = new byte[]{(byte)numBytes};
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(prefixLength)));
            }
        }
        if (!bigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallNullTerminatedDBCSStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size, boolean DBCSOnly) throws IllegalArgumentException {
        if (!DBCSOnly) {
            MarshallStringUtils.marshallNullTerminatedDBCSStringCharByChar(value, buffer, startingOffset, codePage, charSize, size);
            return;
        }
        int numBytes = MarshallStringUtils.marshallFixedLengthDBCSStringIntoBuffer(value, buffer, startingOffset, codePage, charSize, size, 0, null, DBCSOnly);
        int i = 0;
        while (i < charSize) {
            if (numBytes + i >= size) break;
            buffer[startingOffset + numBytes + i] = 0;
            ++i;
        }
    }

    private static void marshallNullTerminatedDBCSStringCharByChar(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size) throws IllegalArgumentException {
        int maxChars;
        char[] characters = value.toCharArray();
        if (characters.length > (maxChars = size / charSize)) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
        }
        byte[] tb = new byte[size];
        int i = 0;
        while (i < characters.length) {
            Character currChar = new Character(characters[i]);
            try {
                byte[] currBytes = currChar.toString().getBytes(codePage);
                int currOffset = i * charSize;
                System.arraycopy(currBytes, 0, tb, currOffset, currBytes.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
            }
            ++i;
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallNullTerminatedStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int size) throws IllegalArgumentException {
        byte[] tb = null;
        try {
            tb = value.getBytes(codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        if (tb.length >= size) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
        buffer[startingOffset + tb.length] = 0;
    }

    public static char unmarshallCharFromBuffer(byte[] buffer, int startingOffset, int size, String codePage) throws IllegalArgumentException {
        String bufString = null;
        try {
            bufString = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        char[] charArray = bufString.toCharArray();
        return charArray[0];
    }

    private static byte[] fixInboundDBCSBuffer(byte[] buffer, int startingOffset, String codePage, int size) throws IllegalArgumentException {
        byte[] tb = null;
        byte spaceChar = 0;
        try {
            String tmp = " ";
            spaceChar = tmp.getBytes(codePage)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        if (spaceChar == 64) {
            tb = new byte[size + 2];
            System.arraycopy(buffer, startingOffset, tb, 1, size);
            tb[0] = 14;
            tb[tb.length - 1] = 15;
        } else {
            tb = new byte[size];
            System.arraycopy(buffer, startingOffset, tb, 0, size);
        }
        return tb;
    }

    public static String unmarshallFixedLengthDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean DBCSOnly) throws IllegalArgumentException {
        if (buffer.length == 0 || buffer[startingOffset] == 0) {
            return "";
        }
        byte[] tb = null;
        if (DBCSOnly) {
            tb = MarshallStringUtils.fixInboundDBCSBuffer(buffer, startingOffset, codePage, size);
            size = tb.length;
            startingOffset = 0;
        } else {
            tb = buffer;
        }
        String result = null;
        try {
            result = new String(tb, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public static String unmarshallFixedLengthStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size) throws IllegalArgumentException {
        if (buffer.length == 0 || buffer[startingOffset] == 0) {
            return "";
        }
        String result = null;
        try {
            result = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public static String unmarshallLengthPrefixedDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean bigEndian, int prefixLength, boolean DBCSOnly) throws IllegalArgumentException {
        byte[] intBytes = new byte[prefixLength];
        System.arraycopy(buffer, startingOffset, intBytes, 0, prefixLength);
        if (!bigEndian) {
            ConversionUtils.endianSwap(intBytes);
        }
        int length = 0;
        switch (prefixLength) {
            case 4: {
                length = ConversionUtils.convertFromByteToInt(intBytes);
                break;
            }
            case 2: {
                length = ConversionUtils.convertFromByteToShort(intBytes);
                break;
            }
            case 8: {
                length = (int)ConversionUtils.convertFromByteToLong(intBytes);
                break;
            }
            case 1: {
                length = intBytes[0];
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(prefixLength)));
            }
        }
        if (DBCSOnly) {
            length *= 2;
        }
        if (length > size - prefixLength) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(length)));
        }
        byte[] tb = null;
        int offset = 0;
        if (DBCSOnly) {
            tb = MarshallStringUtils.fixInboundDBCSBuffer(buffer, startingOffset + prefixLength, codePage, length);
            length = tb.length;
        } else {
            tb = buffer;
            offset = startingOffset + prefixLength;
        }
        String result = null;
        try {
            result = new String(tb, offset, length, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public static String unmarshallLengthPrefixedStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean bigEndian, int prefixLength) throws IllegalArgumentException {
        byte[] intBytes = new byte[prefixLength];
        System.arraycopy(buffer, startingOffset, intBytes, 0, prefixLength);
        if (!bigEndian) {
            ConversionUtils.endianSwap(intBytes);
        }
        int length = 0;
        switch (prefixLength) {
            case 4: {
                length = ConversionUtils.convertFromByteToInt(intBytes);
                break;
            }
            case 2: {
                length = ConversionUtils.convertFromByteToShort(intBytes);
                break;
            }
            case 8: {
                length = (int)ConversionUtils.convertFromByteToLong(intBytes);
                break;
            }
            case 1: {
                length = intBytes[0];
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(prefixLength)));
            }
        }
        if (length > size - prefixLength) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(length)));
        }
        String result = null;
        try {
            result = new String(buffer, startingOffset + prefixLength, length, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public static String unmarshallNullTerminatedDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean DBCSOnly, int charSize) throws IllegalArgumentException {
        byte[] tb = null;
        if (DBCSOnly) {
            if (buffer[startingOffset] == 0) {
                return "";
            }
            int i = startingOffset;
            while (i < startingOffset + size) {
                if (buffer[i] == 0) {
                    size = i - startingOffset;
                    break;
                }
                ++i;
            }
        } else {
            return MarshallStringUtils.unmarshallNullTerminatedDBCSStringCharByChar(buffer, startingOffset, codePage, size, charSize);
        }
        tb = MarshallStringUtils.fixInboundDBCSBuffer(buffer, startingOffset, codePage, size);
        size = tb.length;
        startingOffset = 0;
        String result = null;
        try {
            result = new String(tb, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        int index = result.indexOf(0);
        if (index != -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    public static String unmarshallNullTerminatedDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean DBCSOnly) throws IllegalArgumentException {
        return MarshallStringUtils.unmarshallNullTerminatedDBCSStringFromBuffer(buffer, startingOffset, codePage, size, DBCSOnly, 2);
    }

    private static String unmarshallNullTerminatedDBCSStringCharByChar(byte[] buffer, int startingOffset, String codePage, int size, int charSize) throws IllegalArgumentException {
        int maxChars = size / charSize;
        StringBuffer sb = new StringBuffer(maxChars);
        int i = 0;
        while (i < maxChars) {
            try {
                int currOffset = startingOffset + i * charSize;
                String currChar = new String(buffer, currOffset, charSize, codePage);
                int index = currChar.indexOf(0);
                if (index != -1) {
                    currChar = currChar.substring(0, index);
                }
                sb.append(currChar);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
            }
            ++i;
        }
        String result = sb.toString();
        int index = result.indexOf(0);
        if (index != -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    public static String unmarshallNullTerminatedStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size) throws IllegalArgumentException {
        String result = null;
        try {
            result = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        int index = result.indexOf(0);
        if (index != -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    public static int marshallFixedLengthUnicodeDBCSStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size, int justification, String padCharStr, boolean DBCSOnly) throws IllegalArgumentException {
        int padLength;
        byte[] tb = null;
        try {
            tb = value.getBytes(codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        int bytesMarshalled = tb.length;
        int start = 0;
        if (bytesMarshalled > size) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", value, Integer.toString(size)));
        }
        int bytesToCopy = bytesMarshalled;
        switch (justification) {
            case 0: {
                System.arraycopy(tb, start, buffer, startingOffset, bytesToCopy);
                break;
            }
            case 1: {
                int offset = size - bytesToCopy;
                System.arraycopy(tb, start, buffer, startingOffset + offset, bytesToCopy);
                bytesMarshalled = size;
                break;
            }
            case 2: {
                int offset = (size - bytesToCopy) / 2;
                System.arraycopy(tb, start, buffer, startingOffset + offset, bytesToCopy);
                bytesMarshalled = size;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(justification)));
            }
        }
        if (padCharStr != null && (padLength = size - bytesToCopy) > 0) {
            bytesMarshalled = size;
            byte[] padArray = null;
            try {
                padArray = padCharStr.getBytes(codePage);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            switch (justification) {
                case 0: {
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset + bytesToCopy, padLength);
                    break;
                }
                case 1: {
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset, padLength);
                    break;
                }
                case 2: {
                    int startBytes = padLength / 2;
                    int endBytes = padLength - startBytes;
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset, startBytes);
                    ConversionUtils.fillBytes(padArray, buffer, startingOffset + bytesToCopy, endBytes);
                }
            }
        }
        return bytesMarshalled;
    }

    public static void marshallLengthPrefixedUnicodeDBCSStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size, int justification, String padCharStr, boolean bigEndian, int prefixLength, boolean DBCSOnly) throws IllegalArgumentException {
        int numBytes = MarshallStringUtils.marshallFixedLengthUnicodeDBCSStringIntoBuffer(value, buffer, startingOffset + prefixLength, codePage, charSize, size - prefixLength, justification, padCharStr, DBCSOnly);
        byte[] tb = null;
        switch (prefixLength) {
            case 4: {
                tb = ConversionUtils.convertToByte(numBytes / charSize);
                break;
            }
            case 2: {
                tb = ConversionUtils.convertToByte((short)numBytes / charSize);
                break;
            }
            case 8: {
                tb = ConversionUtils.convertToByte((long)numBytes / (long)charSize);
                break;
            }
            case 1: {
                tb = new byte[]{(byte)(numBytes / charSize)};
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(prefixLength)));
            }
        }
        if (!bigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallNullTerminatedUnicodeDBCSStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int charSize, int size, boolean DBCSOnly) throws IllegalArgumentException {
        int numBytes = MarshallStringUtils.marshallFixedLengthUnicodeDBCSStringIntoBuffer(value, buffer, startingOffset, codePage, charSize, size, 0, null, DBCSOnly);
        int i = 0;
        while (i < charSize) {
            if (numBytes + i >= size) break;
            buffer[startingOffset + numBytes + i] = 0;
            ++i;
        }
    }

    public static String unmarshallFixedLengthUnicodeDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean DBCSOnly) throws IllegalArgumentException {
        String result = null;
        try {
            result = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public static String unmarshallLengthPrefixedUnicodeDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean bigEndian, int prefixLength, boolean DBCSOnly) throws IllegalArgumentException {
        byte[] intBytes = new byte[prefixLength];
        System.arraycopy(buffer, startingOffset, intBytes, 0, prefixLength);
        if (!bigEndian) {
            ConversionUtils.endianSwap(intBytes);
        }
        int length = 0;
        switch (prefixLength) {
            case 4: {
                length = ConversionUtils.convertFromByteToInt(intBytes);
                break;
            }
            case 2: {
                length = ConversionUtils.convertFromByteToShort(intBytes);
                break;
            }
            case 8: {
                length = (int)ConversionUtils.convertFromByteToLong(intBytes);
                break;
            }
            case 1: {
                length = intBytes[0];
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(prefixLength)));
            }
        }
        if (DBCSOnly) {
            length *= 2;
        }
        if (length > size - prefixLength) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(length)));
        }
        int offset = startingOffset + prefixLength;
        String result = null;
        try {
            result = new String(buffer, offset, length, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public static String unmarshallNullTerminatedUnicodeDBCSStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size, boolean DBCSOnly, int charSize) throws IllegalArgumentException {
        String result = null;
        try {
            result = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        int index = result.indexOf(0);
        if (index != -1) {
            result = result.substring(0, index);
        }
        return result;
    }
}

