/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.dataaccess.DecimalData;
import com.ibm.etools.marshall.util.ConversionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallPackedDecimalUtils {
    private static final String copyright = "Copyright IBM Corporation 2001, 2013.";
    private static final byte PACKED_DEC_NOSIGN = 15;

    public static void marshallPackedDecimalIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint) throws IllegalArgumentException {
        value = value.movePointRight(virtualDecimalPoint);
        if (size < 10) {
            MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(value.longValue(), buffer, startingOffset, size, signed);
        } else if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)value, (byte[])buffer, (int)startingOffset, (int)(size * 2 - 1), (boolean)false);
            if (!signed) {
                buffer[startingOffset + size - 1] = (byte)(buffer[startingOffset + size - 1] | 0xF);
            }
        } else {
            char[] bdChars = value.toString().toCharArray();
            byte[] pdBytes = ConversionUtils.convertToPackedDecimal(bdChars, size, signed);
            System.arraycopy(pdBytes, 0, buffer, startingOffset, pdBytes.length);
        }
    }

    public static void marshallPackedDecimalIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, int size, boolean signed) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(value);
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bd, buffer, startingOffset, size, signed, 0);
    }

    public static void marshallPackedDecimalIntoBuffer(double value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bd, buffer, startingOffset, size, signed, virtualDecimalPoint);
    }

    public static void marshallPackedDecimalIntoBuffer(float value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Float.toString(value));
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bd, buffer, startingOffset, size, signed, virtualDecimalPoint);
    }

    public static void marshallPackedDecimalIntoBuffer(long value, byte[] buffer, int startingOffset, int size, boolean signed) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)startingOffset, (int)(size * 2 - 1), (boolean)false);
            if (!signed) {
                buffer[startingOffset + size - 1] = (byte)(buffer[startingOffset + size - 1] | 0xF);
            }
        } else {
            byte[] pdBytes = ConversionUtils.convertToPackedDecimal(value, size, signed);
            System.arraycopy(pdBytes, 0, buffer, startingOffset, pdBytes.length);
        }
    }

    public static byte unmarshallByteFromBuffer(byte[] buffer, int startingOffset, int size) throws IllegalArgumentException {
        byte result = (byte)MarshallPackedDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size);
        return result;
    }

    public static short unmarshallShortFromBuffer(byte[] buffer, int startingOffset, int size) throws IllegalArgumentException {
        short result = (short)MarshallPackedDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size);
        return result;
    }

    public static int unmarshallIntFromBuffer(byte[] buffer, int startingOffset, int size) throws IllegalArgumentException {
        int result = ConversionUtils.IBMDataAccessUtility.useDataAccess ? DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)startingOffset, (int)(size * 2 - 1), (boolean)false) : (int)MarshallPackedDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size);
        return result;
    }

    public static long unmarshallLongFromBuffer(byte[] buffer, int startingOffset, int size) throws IllegalArgumentException {
        long result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)startingOffset, (int)(size * 2 - 1), (boolean)false);
        } else {
            byte[] pdBytes = new byte[size];
            System.arraycopy(buffer, startingOffset, pdBytes, 0, pdBytes.length);
            result = ConversionUtils.convertPackedDecimalToBinary(pdBytes);
        }
        return result;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, int size, int virtualDecimalPoint) throws IllegalArgumentException {
        BigDecimal bdRes = null;
        if (size < 10) {
            long result = MarshallPackedDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size);
            bdRes = new BigDecimal(result);
        } else {
            if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
                return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)startingOffset, (int)(size * 2 - 1), (int)virtualDecimalPoint, (boolean)false);
            }
            byte[] pdBytes = new byte[size];
            System.arraycopy(buffer, startingOffset, pdBytes, 0, pdBytes.length);
            bdRes = ConversionUtils.convertPackedDecimalToBigDecimal(pdBytes);
        }
        bdRes = bdRes.movePointLeft(virtualDecimalPoint);
        return bdRes;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] buffer, int startingOffset, int size) throws IllegalArgumentException {
        BigInteger result = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, 0).toBigInteger();
        return result;
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, int size, int virtualDecimalPoint) throws IllegalArgumentException {
        double result = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, virtualDecimalPoint).doubleValue();
        return result;
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, int size, int virtualDecimalPoint) throws IllegalArgumentException {
        float result = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, virtualDecimalPoint).floatValue();
        return result;
    }
}

