/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.dataaccess.ByteArrayMarshaller;
import com.ibm.dataaccess.ByteArrayUnmarshaller;
import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallIntegerUtils {
    private static final String copyright = "Copyright IBM Corporation 2001, 2013.";
    public static final int SIGN_CODING_TWOS_COMPLEMENT = 0;
    public static final int SIGN_CODING_ONES_COMPLEMENT = 1;
    public static final int SIGN_CODING_SIGN_MAGNITUDE = 2;
    public static final int SIGN_CODING_UNSIGNED_BINARY = 3;
    public static final int SIGN_CODING_UNSIGNED_DECIMAL = 4;

    public static void marshallOneByteIntegerIntoBuffer(byte value, byte[] buffer, int startingOffset, int signCoding) throws IllegalArgumentException {
        buffer[startingOffset] = value;
    }

    public static void marshallOneByteUnsignedIntegerIntoBuffer(short value, byte[] buffer, int startingOffset, int signCoding) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            ByteArrayMarshaller.writeShort((short)value, (byte[])buffer, (int)startingOffset, (boolean)true, (int)1);
        } else {
            byte[] tb = ConversionUtils.convertToByte(value);
            buffer[startingOffset] = tb[1];
        }
    }

    public static void marshallTwoByteIntegerIntoBuffer(short value, byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            ByteArrayMarshaller.writeShort((short)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian);
        } else {
            byte[] tb = ConversionUtils.convertToByte(value);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(tb);
            }
            System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
        }
    }

    public static void marshallTwoByteUnsignedIntegerIntoBuffer(int value, byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            ByteArrayMarshaller.writeInt((int)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)2);
        } else {
            byte[] tb = ConversionUtils.convertToByte(value);
            byte[] newBytes = new byte[]{tb[2], tb[3]};
            tb = newBytes;
            if (!isBigEndian) {
                ConversionUtils.endianSwap(tb);
            }
            System.arraycopy(tb, 0, buffer, startingOffset, 2);
        }
    }

    public static void marshallFourByteIntegerIntoBuffer(int value, byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            ByteArrayMarshaller.writeInt((int)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian);
        } else {
            byte[] tb = ConversionUtils.convertToByte(value);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(tb);
            }
            System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
        }
    }

    public static void marshallFourByteUnsignedIntegerIntoBuffer(long value, byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            ByteArrayMarshaller.writeLong((long)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)4);
        } else {
            byte[] tb = ConversionUtils.convertToByte(value);
            byte[] newBytes = new byte[4];
            System.arraycopy(tb, 4, newBytes, 0, newBytes.length);
            tb = newBytes;
            if (!isBigEndian) {
                ConversionUtils.endianSwap(tb);
            }
            System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
        }
    }

    public static void marshallEightByteIntegerIntoBuffer(long value, byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            ByteArrayMarshaller.writeLong((long)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian);
        } else {
            byte[] tb = ConversionUtils.convertToByte(value);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(tb);
            }
            System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
        }
    }

    public static void marshallEightByteUnsignedIntegerIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        byte[] valBytes = value.toByteArray();
        int valSize = valBytes.length;
        byte[] tb = null;
        if (valSize == 8) {
            tb = valBytes;
        } else {
            tb = new byte[8];
            int destStart = 8 - valSize;
            int srcStart = 0;
            if (valSize > 8) {
                destStart = 0;
                srcStart = valSize - 8;
                valSize = 8;
            }
            System.arraycopy(valBytes, srcStart, tb, destStart, valSize);
        }
        if (!isBigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallSixteenByteIntegerIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, boolean signed, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        byte[] valBytes = value.toByteArray();
        int valSize = valBytes.length;
        if (valSize > 16) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT16NUM_OUTOF_RANGE", value.toString()));
        }
        byte[] tb = null;
        if (valSize == 16) {
            tb = valBytes;
        } else {
            tb = new byte[16];
            System.arraycopy(valBytes, 0, tb, 16 - valSize, valSize);
            if (signed && value.signum() == -1) {
                int i = 0;
                while (i < 16 - valSize) {
                    tb[i] = -1;
                    ++i;
                }
            }
        }
        if (!isBigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallOneByteIntegerIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, boolean signed, int signCoding, int virtualDecimalPt) throws IllegalArgumentException {
        value = value.movePointRight(virtualDecimalPt);
        if (signed) {
            MarshallIntegerUtils.marshallOneByteIntegerIntoBuffer(value.byteValue(), buffer, startingOffset, signCoding);
        } else {
            MarshallIntegerUtils.marshallOneByteUnsignedIntegerIntoBuffer(value.shortValue(), buffer, startingOffset, signCoding);
        }
    }

    public static void marshallTwoByteIntegerIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, boolean signed, boolean isBigEndian, int signCoding, int virtualDecimalPt) throws IllegalArgumentException {
        value = value.movePointRight(virtualDecimalPt);
        if (signed) {
            MarshallIntegerUtils.marshallTwoByteIntegerIntoBuffer(value.shortValue(), buffer, startingOffset, isBigEndian, signCoding);
        } else {
            MarshallIntegerUtils.marshallTwoByteUnsignedIntegerIntoBuffer(value.intValue(), buffer, startingOffset, isBigEndian, signCoding);
        }
    }

    public static void marshallFourByteIntegerIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, boolean signed, boolean isBigEndian, int signCoding, int virtualDecimalPt) throws IllegalArgumentException {
        value = value.movePointRight(virtualDecimalPt);
        if (signed) {
            MarshallIntegerUtils.marshallFourByteIntegerIntoBuffer(value.intValue(), buffer, startingOffset, isBigEndian, signCoding);
        } else {
            MarshallIntegerUtils.marshallFourByteUnsignedIntegerIntoBuffer(value.longValue(), buffer, startingOffset, isBigEndian, signCoding);
        }
    }

    public static void marshallEightByteIntegerIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, boolean signed, boolean isBigEndian, int signCoding, int virtualDecimalPt) throws IllegalArgumentException {
        value = value.movePointRight(virtualDecimalPt);
        if (signed) {
            MarshallIntegerUtils.marshallEightByteIntegerIntoBuffer(value.longValue(), buffer, startingOffset, isBigEndian, signCoding);
        } else {
            MarshallIntegerUtils.marshallEightByteUnsignedIntegerIntoBuffer(value.toBigInteger(), buffer, startingOffset, isBigEndian, signCoding);
        }
    }

    public static void marshallSixteenByteIntegerIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, boolean signed, boolean isBigEndian, int signCoding, int virtualDecimalPt) throws IllegalArgumentException {
        value = value.movePointRight(virtualDecimalPt);
        MarshallIntegerUtils.marshallSixteenByteIntegerIntoBuffer(value.toBigInteger(), buffer, startingOffset, signed, isBigEndian, signCoding);
    }

    public static byte unmarshallOneByteIntegerFromBuffer(byte[] buffer, int startingOffset, int signCoding) throws IllegalArgumentException {
        byte result = buffer[startingOffset];
        return result;
    }

    public static short unmarshallOneByteUnsignedIntegerFromBuffer(byte[] buffer, int startingOffset, int signCoding) throws IllegalArgumentException {
        short result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = ByteArrayUnmarshaller.readShort((byte[])buffer, (int)startingOffset, (boolean)true, (int)1, (boolean)false);
        } else {
            result = buffer[startingOffset];
            result = (short)(result & 0xFF);
        }
        return result;
    }

    public static short unmarshallTwoByteIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        short result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = ByteArrayUnmarshaller.readShort((byte[])buffer, (int)startingOffset, (boolean)isBigEndian);
        } else {
            byte[] sb = new byte[2];
            System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(sb);
            }
            result = ConversionUtils.convertFromByteToShort(sb);
        }
        return result;
    }

    public static int unmarshallTwoByteUnsignedIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        int result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = ByteArrayUnmarshaller.readInt((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)2, (boolean)false);
        } else {
            byte[] sb = new byte[2];
            System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(sb);
            }
            result = ConversionUtils.convertFromByteToShort(sb);
            result &= 0xFFFF;
        }
        return result;
    }

    public static int unmarshallFourByteIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        int result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = ByteArrayUnmarshaller.readInt((byte[])buffer, (int)startingOffset, (boolean)isBigEndian);
        } else {
            byte[] sb = new byte[4];
            System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(sb);
            }
            result = ConversionUtils.convertFromByteToInt(sb);
        }
        return result;
    }

    public static long unmarshallFourByteUnsignedIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        long result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = ByteArrayUnmarshaller.readLong((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)4, (boolean)false);
        } else {
            byte[] sb = new byte[4];
            System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(sb);
            }
            result = ConversionUtils.convertFromByteToInt(sb);
            result &= 0xFFFFFFFFL;
        }
        return result;
    }

    public static long unmarshallEightByteIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        long result;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess) {
            result = ByteArrayUnmarshaller.readLong((byte[])buffer, (int)startingOffset, (boolean)isBigEndian);
        } else {
            byte[] sb = new byte[8];
            System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
            if (!isBigEndian) {
                ConversionUtils.endianSwap(sb);
            }
            result = ConversionUtils.convertFromByteToLong(sb);
        }
        return result;
    }

    public static BigInteger unmarshallEightByteUnsignedIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        byte[] sb = new byte[8];
        System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
        if (!isBigEndian) {
            ConversionUtils.endianSwap(sb);
        }
        byte[] resultBytes = new byte[16];
        System.arraycopy(sb, 0, resultBytes, 8, sb.length);
        BigInteger result = new BigInteger(resultBytes);
        return result;
    }

    public static BigInteger unmarshallSixteenByteIntegerFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int signCoding) throws IllegalArgumentException {
        byte[] sb = new byte[16];
        System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
        if (!isBigEndian) {
            ConversionUtils.endianSwap(sb);
        }
        BigInteger result = new BigInteger(sb);
        return result;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, boolean isBigEndian, int signCoding, int virtualDecimalPoint) throws IllegalArgumentException {
        BigDecimal result = null;
        switch (size) {
            case 1: {
                if (signed) {
                    byte byteResult = MarshallIntegerUtils.unmarshallOneByteIntegerFromBuffer(buffer, startingOffset, signCoding);
                    result = new BigDecimal(byteResult);
                    break;
                }
                short shortResult = MarshallIntegerUtils.unmarshallOneByteUnsignedIntegerFromBuffer(buffer, startingOffset, signCoding);
                result = new BigDecimal(shortResult);
                break;
            }
            case 2: {
                if (signed) {
                    short shortResult = MarshallIntegerUtils.unmarshallTwoByteIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                    result = new BigDecimal(shortResult);
                    break;
                }
                int intResult = MarshallIntegerUtils.unmarshallTwoByteUnsignedIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                result = new BigDecimal(intResult);
                break;
            }
            case 4: {
                if (signed) {
                    int intResult = MarshallIntegerUtils.unmarshallFourByteIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                    result = new BigDecimal(intResult);
                    break;
                }
                long longResult = MarshallIntegerUtils.unmarshallFourByteUnsignedIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                result = new BigDecimal(longResult);
                break;
            }
            case 8: {
                if (signed) {
                    long longResult = MarshallIntegerUtils.unmarshallEightByteIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                    result = new BigDecimal(longResult);
                    break;
                }
                BigInteger biResult = MarshallIntegerUtils.unmarshallEightByteUnsignedIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                result = new BigDecimal(biResult);
                break;
            }
            case 16: {
                BigInteger biResult = MarshallIntegerUtils.unmarshallSixteenByteIntegerFromBuffer(buffer, startingOffset, isBigEndian, signCoding);
                result = new BigDecimal(biResult);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
        result = result.movePointLeft(virtualDecimalPoint);
        return result;
    }
}

