/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.dataaccess.DecimalData;
import com.ibm.etools.marshall.util.ConversionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallExternalDecimalUtils {
    private static final String copyright = "Copyright IBM Corporation 2001, 2016.";
    public static final int EXTERNAL_DECIMAL_SIGN_EBCDIC = 0;
    public static final int EXTERNAL_DECIMAL_SIGN_EBCDIC_CUSTOM = 1;
    public static final int EXTERNAL_DECIMAL_SIGN_ASCII = 2;
    public static final int EXTERNAL_DECIMAL_SIGN_UNICODE = 3;
    public static final int SIGN_FORMAT_LEADING = 0;
    public static final int SIGN_FORMAT_TRAILING = 1;
    public static final int SIGN_FORMAT_LEADING_SEPARATE = 2;
    public static final int SIGN_FORMAT_TRAILING_SEPARATE = 3;

    public static int getDAODecimalType(int signFormat, int externalDecimalSign) {
        switch (externalDecimalSign) {
            case 0: {
                switch (signFormat) {
                    case 0: {
                        return 2;
                    }
                    case 2: {
                        return 4;
                    }
                    case 1: {
                        return 1;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return 1;
            }
            case 3: {
                switch (signFormat) {
                    case 2: {
                        return 6;
                    }
                    case 3: {
                        return 7;
                    }
                }
                return 5;
            }
        }
        return -1;
    }

    public static int getDAOPrecision(int valueSize, int signFormat) {
        switch (signFormat) {
            case 2: 
            case 3: {
                return valueSize - 1;
            }
        }
        return valueSize;
    }

    public static void marshallExternalDecimalIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(value, buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, null);
    }

    public static void marshallExternalDecimalIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        int valueSize;
        value = value.movePointRight(virtualDecimalPoint);
        int n = valueSize = externalDecimalSign == 3 ? size / 2 : size;
        if (valueSize < 19) {
            MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(value.longValue(), buffer, startingOffset, size, signed, signFormat, externalDecimalSign, codePage);
        } else if (ConversionUtils.IBMDataAccessUtility.useDataAccess && externalDecimalSign == 0) {
            int decimalType = MarshallExternalDecimalUtils.getDAODecimalType(signFormat, externalDecimalSign);
            DecimalData.convertBigDecimalToExternalDecimal((BigDecimal)value, (byte[])buffer, (int)startingOffset, (int)MarshallExternalDecimalUtils.getDAOPrecision(valueSize, signFormat), (boolean)false, (int)decimalType);
            if (!signed) {
                buffer[startingOffset + size - 1] = (byte)(buffer[startingOffset + size - 1] | 0xF0);
            }
        } else {
            value = new BigDecimal(value.toBigInteger());
            char[] extdChars = value.toString().toCharArray();
            byte[] extdBytes = ConversionUtils.convertToExternalDecimal(extdChars, size, signed, signFormat, externalDecimalSign, codePage);
            System.arraycopy(extdBytes, 0, buffer, startingOffset, extdBytes.length);
        }
    }

    public static void marshallExternalDecimalIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(value, buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static void marshallExternalDecimalIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(value);
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bd, buffer, startingOffset, size, signed, 0, signFormat, externalDecimalSign, codePage);
    }

    public static void marshallExternalDecimalIntoBuffer(double value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(value, buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, null);
    }

    public static void marshallExternalDecimalIntoBuffer(double value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bd, buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, codePage);
    }

    public static void marshallExternalDecimalIntoBuffer(float value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(value, buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, null);
    }

    public static void marshallExternalDecimalIntoBuffer(float value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Float.toString(value));
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bd, buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, codePage);
    }

    public static void marshallExternalDecimalIntoBuffer(long value, byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(value, buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static void marshallExternalDecimalIntoBuffer(long value, byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess && externalDecimalSign == 0) {
            int decimalType = MarshallExternalDecimalUtils.getDAODecimalType(signFormat, externalDecimalSign);
            DecimalData.convertLongToExternalDecimal((long)value, (byte[])buffer, (int)startingOffset, (int)MarshallExternalDecimalUtils.getDAOPrecision(size, signFormat), (boolean)false, (int)decimalType);
            if (!signed) {
                buffer[startingOffset + size - 1] = (byte)(buffer[startingOffset + size - 1] | 0xF0);
            }
        } else {
            byte[] pdBytes = ConversionUtils.convertToExternalDecimal(value, size, signed, signFormat, externalDecimalSign, codePage);
            System.arraycopy(pdBytes, 0, buffer, startingOffset, pdBytes.length);
        }
    }

    public static byte unmarshallByteFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallByteFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static byte unmarshallByteFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        byte result = (byte)MarshallExternalDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, codePage);
        return result;
    }

    public static short unmarshallShortFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallShortFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static short unmarshallShortFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        short result = (short)MarshallExternalDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, codePage);
        return result;
    }

    public static int unmarshallIntFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallIntFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static int unmarshallIntFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        int result = (int)MarshallExternalDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, codePage);
        return result;
    }

    public static long unmarshallLongFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static long unmarshallLongFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        long result = 0L;
        if (ConversionUtils.IBMDataAccessUtility.useDataAccess && externalDecimalSign == 0) {
            int decimalType = MarshallExternalDecimalUtils.getDAODecimalType(signFormat, externalDecimalSign);
            result = DecimalData.convertExternalDecimalToLong((byte[])buffer, (int)startingOffset, (int)MarshallExternalDecimalUtils.getDAOPrecision(size, signFormat), (boolean)false, (int)decimalType);
        } else {
            byte[] pdBytes = new byte[size];
            System.arraycopy(buffer, startingOffset, pdBytes, 0, pdBytes.length);
            result = ConversionUtils.convertExternalDecimalToBinary(pdBytes, signed, signFormat, externalDecimalSign, codePage);
        }
        return result;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, null);
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        int valueSize;
        BigDecimal bdRes = null;
        int n = valueSize = externalDecimalSign == 3 ? size / 2 : size;
        if (valueSize < 19) {
            long result = MarshallExternalDecimalUtils.unmarshallLongFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, codePage);
            bdRes = new BigDecimal(result);
        } else {
            if (ConversionUtils.IBMDataAccessUtility.useDataAccess && externalDecimalSign == 0) {
                int decimalType = MarshallExternalDecimalUtils.getDAODecimalType(signFormat, externalDecimalSign);
                return DecimalData.convertExternalDecimalToBigDecimal((byte[])buffer, (int)startingOffset, (int)MarshallExternalDecimalUtils.getDAOPrecision(size, signFormat), (int)virtualDecimalPoint, (boolean)false, (int)decimalType);
            }
            byte[] extdBytes = new byte[size];
            System.arraycopy(buffer, startingOffset, extdBytes, 0, extdBytes.length);
            bdRes = ConversionUtils.convertExternalDecimalToBigDecimal(extdBytes, signed, signFormat, externalDecimalSign, codePage);
        }
        bdRes = bdRes.movePointLeft(virtualDecimalPoint);
        return bdRes;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallBigIntegerFromBuffer(buffer, startingOffset, size, signed, signFormat, externalDecimalSign, null);
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        BigInteger result = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, signed, 0, signFormat, externalDecimalSign, codePage).toBigInteger();
        return result;
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallDoubleFromBuffer(buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, null);
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        double result = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, codePage).doubleValue();
        return result;
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallFloatFromBuffer(buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, null);
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, int externalDecimalSign, String codePage) throws IllegalArgumentException {
        float result = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(buffer, startingOffset, size, signed, virtualDecimalPoint, signFormat, externalDecimalSign, codePage).floatValue();
        return result;
    }
}

