/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class LongRange
implements IRangeObject {
    private static String copyright = "Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = -4163203380347322298L;
    protected long lowerRange_;
    protected long upperRange_;

    public LongRange() {
        this.lowerRange_ = 0L;
        this.upperRange_ = 0L;
    }

    public LongRange(long lowerRange, long upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Long.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    @Override
    public Object clone() {
        try {
            LongRange newType = (LongRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongRange)) {
            return false;
        }
        LongRange tmpRange = (LongRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    @Override
    public Object getLowerRange() {
        return new Long(this.lowerRange_);
    }

    @Override
    public Object getUpperRange() {
        return new Long(this.upperRange_);
    }

    public static boolean isInRange(long lowerRange, long upperRange, long value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Long.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    @Override
    public boolean isInRange(Object value) {
        if (!(value instanceof Long)) {
            return false;
        }
        long longVal = (Long)value;
        return LongRange.isInRange(this.lowerRange_, this.upperRange_, longVal);
    }

    @Override
    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Long)value;
    }

    @Override
    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Long)value;
    }
}

