/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class IntegerRange
implements IRangeObject {
    private static String copyright = "Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = -7839365150075934254L;
    protected int lowerRange_;
    protected int upperRange_;

    public IntegerRange() {
        this.lowerRange_ = 0;
        this.upperRange_ = 0;
    }

    public IntegerRange(int lowerRange, int upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Integer.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    @Override
    public Object clone() {
        try {
            IntegerRange newType = (IntegerRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntegerRange)) {
            return false;
        }
        IntegerRange tmpRange = (IntegerRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    @Override
    public Object getLowerRange() {
        return new Integer(this.lowerRange_);
    }

    @Override
    public Object getUpperRange() {
        return new Integer(this.upperRange_);
    }

    public static boolean isInRange(int lowerRange, int upperRange, int value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Integer.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    @Override
    public boolean isInRange(Object value) {
        if (!(value instanceof Integer)) {
            return false;
        }
        int intVal = (Integer)value;
        return IntegerRange.isInRange(this.lowerRange_, this.upperRange_, intVal);
    }

    @Override
    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Integer)value;
    }

    @Override
    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Integer)value;
    }
}

