/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class DoubleRange
implements IRangeObject {
    private static String copyright = "Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = 3380398617924967024L;
    protected double lowerRange_;
    protected double upperRange_;

    public DoubleRange() {
        this.lowerRange_ = 0.0;
        this.upperRange_ = 0.0;
    }

    public DoubleRange(double lowerRange, double upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Double.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    @Override
    public Object clone() {
        try {
            DoubleRange newType = (DoubleRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleRange)) {
            return false;
        }
        DoubleRange tmpRange = (DoubleRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    @Override
    public Object getLowerRange() {
        return new Double(this.lowerRange_);
    }

    @Override
    public Object getUpperRange() {
        return new Double(this.upperRange_);
    }

    public static boolean isInRange(double lowerRange, double upperRange, double value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Double.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    @Override
    public boolean isInRange(Object value) {
        if (!(value instanceof Double)) {
            return false;
        }
        double doubleVal = (Double)value;
        return DoubleRange.isInRange(this.lowerRange_, this.upperRange_, doubleVal);
    }

    @Override
    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Double)value;
    }

    @Override
    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Double)value;
    }
}

