/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class CharacterRange
implements IRangeObject {
    private static String copyright = "Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = -4062258957317422887L;
    protected char lowerRange_;
    protected char upperRange_;

    public CharacterRange() {
        this.lowerRange_ = (char)65;
        this.upperRange_ = (char)65;
    }

    public CharacterRange(char lowerRange, char upperRange) throws IllegalArgumentException {
        if (!Character.isLetter(lowerRange)) {
            throw new IllegalArgumentException(new Character(lowerRange).toString());
        }
        if (!Character.isLetter(upperRange)) {
            throw new IllegalArgumentException(new Character(upperRange).toString());
        }
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(new Character(upperRange).toString());
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    @Override
    public Object clone() {
        try {
            CharacterRange newType = (CharacterRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharacterRange)) {
            return false;
        }
        CharacterRange tmpRange = (CharacterRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    @Override
    public Object getLowerRange() {
        return new Character(this.lowerRange_);
    }

    public Object[] getRangeValues() {
        int arrayLength = 0;
        int i = this.lowerRange_;
        while (i <= this.upperRange_) {
            if (Character.isLetter((char)i)) {
                ++arrayLength;
            }
            ++i;
        }
        Object[] values = new Character[arrayLength];
        int i2 = this.lowerRange_;
        int j = 0;
        while (i2 <= this.upperRange_) {
            if (Character.isLetter((char)i2)) {
                values[j] = new Character((char)i2);
                ++j;
            }
            ++i2;
        }
        return values;
    }

    @Override
    public Object getUpperRange() {
        return new Character(this.upperRange_);
    }

    public static boolean isInRange(char lowerRange, char upperRange, char value) throws IllegalArgumentException {
        if (!Character.isLetter(lowerRange)) {
            throw new IllegalArgumentException(new Character(lowerRange).toString());
        }
        if (!Character.isLetter(upperRange)) {
            throw new IllegalArgumentException(new Character(upperRange).toString());
        }
        if (!Character.isLetter(value)) {
            throw new IllegalArgumentException(new Character(value).toString());
        }
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(new Character(upperRange).toString());
        }
        return value >= lowerRange && value <= upperRange;
    }

    @Override
    public boolean isInRange(Object value) {
        if (!(value instanceof Character)) {
            return false;
        }
        char charVal = ((Character)value).charValue();
        return CharacterRange.isInRange(this.lowerRange_, this.upperRange_, charVal);
    }

    @Override
    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Character)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = ((Character)value).charValue();
    }

    @Override
    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Character)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = ((Character)value).charValue();
    }
}

