/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;
import java.math.BigDecimal;

public class BigDecimalRange
implements IRangeObject {
    private static String copyright = "Copyright IBM Corporation 2000, 2004.";
    static final long serialVersionUID = 8509310780064457891L;
    protected BigDecimal lowerRange_;
    protected BigDecimal upperRange_;

    public BigDecimalRange() {
        this.lowerRange_ = BigDecimal.ZERO;
        this.upperRange_ = BigDecimal.ZERO;
    }

    public BigDecimalRange(BigDecimal lowerRange, BigDecimal upperRange) throws IllegalArgumentException {
        if (lowerRange.compareTo(upperRange) == 1) {
            throw new IllegalArgumentException(upperRange.toString());
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    @Override
    public Object clone() {
        try {
            BigDecimalRange newType = (BigDecimalRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BigDecimalRange)) {
            return false;
        }
        BigDecimalRange tmpRange = (BigDecimalRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    @Override
    public Object getLowerRange() {
        return this.lowerRange_;
    }

    @Override
    public Object getUpperRange() {
        return this.upperRange_;
    }

    @Override
    public boolean isInRange(Object value) {
        if (!(value instanceof BigDecimal)) {
            return false;
        }
        return BigDecimalRange.isInRange(this.lowerRange_, this.upperRange_, (BigDecimal)value);
    }

    public static boolean isInRange(BigDecimal lowerRange, BigDecimal upperRange, BigDecimal value) throws IllegalArgumentException {
        if (lowerRange.compareTo(upperRange) == 1) {
            throw new IllegalArgumentException(upperRange.toString());
        }
        return value.compareTo(lowerRange) != -1 && value.compareTo(upperRange) != 1;
    }

    @Override
    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof BigDecimal)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (BigDecimal)value;
    }

    @Override
    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof BigDecimal)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (BigDecimal)value;
    }
}

