/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.utils;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.sqltools.result.OperationCommand;
import com.ibm.ims.datatools.sqltools.result.internal.utils.Messages;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.model.ResultItem;
import org.eclipse.osgi.util.NLS;

public class StatusTextProvider {
    static String _LINESEPARATOR = System.getProperty("line.separator");

    public static String getUpdateCountText(int updateCount) {
        if (updateCount == 1) {
            return NLS.bind((String)Messages.StatusTextProvider_update_count_single, (Object[])new Object[]{String.valueOf(updateCount)}) + _LINESEPARATOR;
        }
        return NLS.bind((String)Messages.StatusTextProvider_update_count_complex, (Object[])new Object[]{String.valueOf(updateCount)}) + _LINESEPARATOR;
    }

    public static String getStatusText(IResultInstance instance) {
        StringBuffer buff = new StringBuffer("");
        buff.append(instance.getOperationCommand().getDisplayString()).append(_LINESEPARATOR).append(_LINESEPARATOR);
        int count = instance.getItemCount();
        int i = 0;
        while (i < count) {
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 4) {
                buff.append((String)item.getResultObject());
            }
            if (item.getResultType() == 1) {
                buff.append(StatusTextProvider.getUpdateCountText((Integer)item.getResultObject()));
            }
            ++i;
        }
        return buff.toString();
    }

    public static String getHistoryHeader(IResultInstance instance) {
        String profileId;
        StringBuffer buff = new StringBuffer("");
        buff.append(instance.getOperationCommand().getDisplayString()).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_action_type).append(OperationCommand.getActionString(instance.getOperationCommand().getActionType())).append(_LINESEPARATOR);
        String profileName = profileId = instance.getOperationCommand().getProfileId();
        ConnectionProfile profile = ImsDbUtils.getConnectionProfileById((String)profileId);
        if (profile != null) {
            profileName = profile.getName();
        }
        buff.append(Messages.StatusTextProvider_profile_name).append(profileName).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_database).append(instance.getOperationCommand().getDatabaseName()).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_time).append(instance.getExecuteTime()).append(_LINESEPARATOR);
        buff.append(_LINESEPARATOR);
        int count = instance.getItemCount();
        int i = 0;
        while (i < count) {
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 4) {
                buff.append((String)item.getResultObject());
            }
            ++i;
        }
        return buff.toString();
    }

    public static String getSimpleHeader(IResultInstance instance) {
        StringBuffer buff = new StringBuffer("");
        buff.append(instance.getOperationCommand().getDisplayString()).append(_LINESEPARATOR);
        buff.append(_LINESEPARATOR);
        int count = instance.getItemCount();
        int i = 0;
        while (i < count) {
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 4) {
                buff.append((String)item.getResultObject());
            }
            ++i;
        }
        return buff.toString();
    }
}

