/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.common.util;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PosixPortablePathValidator {
    private static final Pattern PosixPortableChars = Pattern.compile("^[A-Za-z0-9._@#$-]+$");

    public static boolean isPortablePath(Path path) {
        boolean valid = true;
        Iterator<Path> partIt = path.iterator();
        while (partIt.hasNext() && valid) {
            Path nPath = partIt.next();
            String nPathStr = nPath.toString();
            if (!StringUtils.isBlank((CharSequence)nPathStr) && PosixPortableChars.matcher(nPathStr).matches() && !nPathStr.equals(".") && !nPathStr.equals("..")) continue;
            valid = false;
        }
        return valid;
    }

    public static boolean isPortableName(String name) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)name) || !PosixPortableChars.matcher(name).matches() || name.equals(".") || name.equals("..")) {
            valid = false;
        }
        return valid;
    }

    public static boolean isPortableFile(File file) {
        boolean valid = true;
        Iterator<Path> partIt = file.toPath().iterator();
        while (partIt.hasNext() && valid) {
            Path nPath = partIt.next();
            String nPathStr = nPath.toString();
            if (!StringUtils.isBlank((CharSequence)nPathStr) && PosixPortableChars.matcher(nPathStr).matches() && !nPathStr.equals(".") && !nPathStr.equals("..")) continue;
            valid = false;
        }
        return valid;
    }
}

