/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.common;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ExplorerCommonPlugin
extends AbstractUIPlugin {
    public static final String TAG = ExplorerCommonPlugin.class.getName();
    public static final String PLUGIN_ID = "com.ibm.ims.explorer.common";
    private static ExplorerCommonPlugin plugin;

    public ExplorerCommonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ExplorerCommonPlugin getDefault() {
        return plugin;
    }

    public static String getLibJarPath(String libJarName, IExplorerLogger log) throws IOException {
        String libJarPath = libJarName;
        Bundle libBundle = Platform.getBundle((String)PLUGIN_ID);
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libBundle=%s", libBundle));
        }
        libJarPath = StringUtils.replace((String)libJarPath, (String)"\\", (String)"/");
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libJarPath=%s", libJarPath));
        }
        Path libJarFilePath = new Path("lib_jar/" + libJarPath);
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libJarFilePath=%s", libJarFilePath));
        }
        URL libJarFileUrl = FileLocator.find((Bundle)libBundle, (IPath)libJarFilePath, null);
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libJarFileUrl=%s", libJarFileUrl));
        }
        libJarFileUrl = FileLocator.toFileURL((URL)libJarFileUrl);
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libJarFileUrl=%s", libJarFileUrl));
        }
        File libJarFile = new File(libJarFileUrl.getFile());
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libJarFile=%s", libJarFile));
        }
        libJarPath = libJarFile.getAbsolutePath();
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("libJarPath=%s", libJarPath));
        }
        return libJarPath;
    }
}

