/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.product;

import com.ibm.im.ims.workbench.product.Activator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.osgi.framework.Version;

public class CustomSplashHandler
extends BasicSplashHandler {
    private static final Logger LOGGER = Logger.getLogger(CustomSplashHandler.class.getPackage().getName());
    private static final String PRODUCT_ID = "com.ibm.im.ims.workbench.product.ide";

    public void init(Shell splash) {
        super.init(splash);
        IProduct product = Platform.getProduct();
        if (product == null) {
            LOGGER.logp(Level.SEVERE, CustomSplashHandler.class.getName(), "init", "No product found");
            return;
        }
        String messageRectangleString = product.getProperty("startupMessageRect");
        this.setProgressRect(new Rectangle(20, 450, 400, 15));
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectangleString, (Rectangle)new Rectangle(45, 35, 300, 20));
        this.setMessageRect(messageRect);
        int foregroundColorInteger = 13817855;
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        final String vrmfValue = this.buildVRMF();
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(Display.getCurrent().getSystemColor(1));
                e.gc.setFont(new Font((Device)e.display, "Verdana", 12, 1));
                e.gc.drawText(vrmfValue, 45, 280, true);
            }
        });
    }

    private String buildVRMF() {
        Version brandingVersion;
        org.eclipse.equinox.p2.metadata.Version productVersion = this.getProductVersion();
        if (productVersion != null && productVersion.getSegmentCount() >= 3) {
            Comparable major = productVersion.getSegment(0);
            Comparable minor = productVersion.getSegment(1);
            Comparable micro = productVersion.getSegment(2);
            if (major instanceof Integer && minor instanceof Integer && micro instanceof Integer) {
                return CustomSplashHandler.buildVRMF((Integer)major, (Integer)minor, (Integer)micro);
            }
        }
        if ((brandingVersion = Activator.getDefault().getBundle().getVersion()) != null) {
            return CustomSplashHandler.buildVRMF(brandingVersion.getMajor(), brandingVersion.getMinor(), brandingVersion.getMicro());
        }
        return "";
    }

    private static String buildVRMF(int major, int minor, int micro) {
        return major + "." + minor + "." + micro / 100 + "." + micro % 100;
    }

    private org.eclipse.equinox.p2.metadata.Version getProductVersion() {
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        if (provisioningUI == null) {
            return null;
        }
        String profileId = provisioningUI.getProfileId();
        ProvisioningSession session = provisioningUI.getSession();
        if (profileId == null || session == null) {
            return null;
        }
        IProvisioningAgent provisioningAgent = session.getProvisioningAgent();
        if (provisioningAgent == null) {
            return null;
        }
        IProfileRegistry registry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            return null;
        }
        IProfile profile = registry.getProfile(profileId);
        if (profile == null) {
            return null;
        }
        IQuery iuProductQuery = QueryUtil.createIUProductQuery();
        IQueryResult result = profile.query(iuProductQuery, null);
        if (result == null) {
            return null;
        }
        for (IInstallableUnit productIU : result) {
            if (!PRODUCT_ID.equals(productIU.getId())) continue;
            return productIU.getVersion();
        }
        return null;
    }
}

