/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.utils;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.im.ims.workbench.transaction.connections.types.IImsTmConnection;
import com.ibm.im.ims.workbench.transaction.connections.types.ImsTmConnectionForJunit;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Display;

public class ImsTmConnectionUtil {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private static IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
    private static ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
    public static ImsTmConnectionForJunit junitConn = null;

    public static void doConnect(ConnectionProfile profile, boolean async) {
        if (profile != null) {
            if (async) {
                connectionService.connectAsync(profile.getId());
            } else {
                connectionService.connect(profile.getId());
            }
        }
    }

    public static void disconnectAllWithSameCredential(final ConnectionProfile profile) {
        if (profile != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImsTmConnectionUtil.disconnectAllWithSameCred(profile);
                }
            });
        }
    }

    private static void disconnectAllWithSameCred(ConnectionProfile profile) {
        ImsTmConnectionUtil.doDisconnect(profile);
        CredentialsConfiguration credsConfig = profile.getCredentials();
        if (credsConfig == null) {
            return;
        }
        for (ConnectionProfile nextProfile : connectionManager.getConnectionProfiles("com.ibm.im.ims.workbench.transaction.connections.type")) {
            CredentialsConfiguration nextCredsConfig;
            if (StringUtils.equals((CharSequence)nextProfile.getId(), (CharSequence)profile.getId()) || (nextCredsConfig = nextProfile.getCredentials()) == null || !StringUtils.equals((CharSequence)nextCredsConfig.getID(), (CharSequence)credsConfig.getID())) continue;
            ImsTmConnectionUtil.doDisconnect(nextProfile);
        }
    }

    public static void doDisconnect(ConnectionProfile profile) {
        if (profile != null) {
            try {
                if (ConnectionUtils.supportsMultipleConnections((IConnectionDescriptor)profile.getConnectionDescriptor())) {
                    ImsTmConnectionUtil.multiConnectionPreDisconnect(profile);
                }
                connectionService.disconnect(profile.getConnectionDescriptor().getCategory().getId());
            }
            catch (ConnectionException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static void multiConnectionPreDisconnect(ConnectionProfile connectionProfile) {
        IConnectionState desirableState;
        String connectionCategoryId = connectionProfile.getConnectionDescriptor().getCategory().getId();
        IConnectionState state = connectionService.getConnectionState(connectionCategoryId);
        String ID = state.getID();
        if ((ID == null || !ID.equals(connectionProfile.getId())) && (desirableState = connectionService.getConnectionState(connectionProfile)) instanceof ConnectedState) {
            IConnection connection = ((ConnectedState)desirableState).getConnection();
            ((ConnectionService)connectionService).switchToAlreadyConnected(connection, connectionProfile);
        }
    }

    public static List<IImsTmConnection> getConnections(boolean connect) {
        ArrayList<IImsTmConnection> retVal = new ArrayList<IImsTmConnection>();
        List connectionProfiles = connectionManager.getConnectionProfiles("com.ibm.im.ims.workbench.transaction.connections.type");
        for (ConnectionProfile profile : connectionProfiles) {
            IImsTmConnection connection = ImsTmConnectionUtil.getConnection(profile, connect);
            if (connection == null) continue;
            retVal.add(connection);
        }
        return retVal;
    }

    public static List<IImsTmConnection> getConnections() {
        return ImsTmConnectionUtil.getConnections(false);
    }

    public static IImsTmConnection getConnection(ConnectionProfile profile, boolean connect) {
        IImsTmConnection retVal = null;
        if (junitConn == null) {
            IConnection connection;
            IConnectionState connectionState = connectionService.getConnectionState(profile);
            if (connectionState instanceof DisconnectedState && connect) {
                connectionService.connect(profile.getId());
                connectionState = connectionService.getConnectionState(profile);
            }
            if (connectionState instanceof ConnectedState && (connection = ((ConnectedState)connectionState).getConnection()) instanceof IImsTmConnection) {
                retVal = (IImsTmConnection)connection;
            }
        } else {
            retVal = junitConn;
        }
        return retVal;
    }

    public static List<ConnectionProfile> getConnectionProfiles() {
        return connectionManager.getConnectionProfiles("com.ibm.im.ims.workbench.transaction.connections.type");
    }

    public static String getServerNameWithHostAndPort(ConnectionProfile profile) {
        if (profile == null || profile.getConnectionConfiguration() == null) {
            return "";
        }
        ConnectionConfiguration config = profile.getConnectionConfiguration();
        return ImsTmConnectionUtil.getServerNameWithHostAndPort(config);
    }

    public static String getServerNameWithHostAndPort(ConnectionConfiguration config) {
        if (config == null) {
            return "";
        }
        StringBuilder serverName = new StringBuilder();
        serverName.append("\"");
        serverName.append(config.getName());
        serverName.append("\" (");
        serverName.append(config.getHost());
        serverName.append(config.getPort());
        serverName.append(")");
        return serverName.toString();
    }

    public static CredentialsConfiguration getCredentialsConfiguration(ConnectionConfiguration configuration) {
        return credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
    }
}

