/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.types;

import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.im.ims.workbench.transaction.connections.exceptions.ImsTmConnectionException;
import com.ibm.im.ims.workbench.transaction.connections.types.IImsTmConnection;
import com.ibm.im.ims.workbench.transaction.connections.utils.ImsTmConnectionUtil;
import com.ibm.ims.connect.Connection;
import com.ibm.ims.connect.ConnectionFactory;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectExecutionException;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.connect.TmInteractionAttributes;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;

public class ImsTmConnectionForJunit
extends AbstractConnection
implements IImsTmConnection {
    public static final String TAG = ImsTmConnectionForJunit.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private Connection connection;
    public String host;
    public int port;
    public ConnectionFactory imsConnFactory = null;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;

    public ImsTmConnectionForJunit(String host, int port) throws ImsConnectApiException, ConnectionException {
        this.host = host;
        this.port = port;
        this.imsConnFactory = new ConnectionFactory();
        this.imsConnFactory.setHostName(host);
        this.imsConnFactory.setPortNumber(port);
        this.imsConnFactory.setSocketConnectTimeout(-1);
        this.connect();
    }

    @Override
    public TmInteraction createTmInteraction(TmInteractionAttributes attributes) throws ImsTmConnectionException {
        logger.entering(TAG, "createTmInteraction(TmInteractionAttributes)", new Object[0]);
        TmInteraction interaction = null;
        try {
            interaction = this.connection.createInteraction(attributes);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new ImsTmConnectionException(e);
        }
        logger.exiting(TAG, "createTmInteraction():{0}", new Object[]{interaction});
        return interaction;
    }

    @Override
    public TmInteraction createTmInteraction() throws ImsTmConnectionException {
        logger.entering(TAG, "createTmInteraction()", new Object[0]);
        TmInteraction interaction = null;
        try {
            interaction = this.connection.createInteraction();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new ImsTmConnectionException(e);
        }
        logger.exiting(TAG, "createTmInteraction():{0}", new Object[]{interaction});
        return interaction;
    }

    @Override
    public void executeTmInteraction(TmInteraction interaction) throws ImsTmConnectionException {
        logger.entering(TAG, "executeTmInteraction(TmInteraction)", new Object[0]);
        ConnectionConfiguration configuration = null;
        ConnectionProfile profile = null;
        CredentialsConfiguration credential = null;
        try {
            configuration = this.getConfiguration();
            profile = connectionManager.getConnectionProfile(configuration.getID());
            credential = credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
            interaction.execute();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            if (e instanceof ImsConnectExecutionException) {
                ImsConnectExecutionException execException = (ImsConnectExecutionException)e;
                if (credential != null && (execException.getracfReturnCode() > 0 || StringUtils.startsWith((CharSequence)execException.getErrorMessage(), (CharSequence)"HWS0043E"))) {
                    logger.info("Authentication failed so invalidating credential: {0}", new Object[]{credential.getName()});
                    credentialsManager.invalidate(credential.getID());
                    logger.info("Disconnecting all connections that use credential: {0}", new Object[]{credential.getName()});
                    ImsTmConnectionUtil.disconnectAllWithSameCredential(profile);
                }
            }
            throw new ImsTmConnectionException(e);
        }
        logger.exiting(TAG, "executeTmInteraction(TmInteraction)", new Object[0]);
    }

    public void connect() throws ConnectionException {
        logger.entering(TAG, "connect()", new Object[0]);
        try {
            this.connection = this.imsConnFactory.getConnection();
            this.connection.connect();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new ConnectionException(e);
        }
        logger.exiting(TAG, "connect()", new Object[0]);
    }

    public void disconnect() throws ConnectionException {
        block6: {
            logger.error("disconnect()", new Object[0]);
            try {
                try {
                    if (this.connection != null) {
                        this.connection.disconnect();
                    }
                }
                catch (ImsConnectApiException e) {
                    logger.error((Throwable)e);
                    this.connection = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.connection = null;
                throw throwable;
            }
            this.connection = null;
        }
        logger.exiting(TAG, "disconnect()", new Object[0]);
    }

    public boolean isConnected() {
        logger.entering(TAG, "isConnected()", new Object[0]);
        boolean connected = false;
        if (this.connection != null && this.connection.isConnected()) {
            connected = true;
        }
        logger.exiting(TAG, "isConnected():{0}", new Object[]{connected});
        return connected;
    }

    public void initSSLConfiguration() throws IOException {
        logger.entering(TAG, "initSSLConfiguration()", new Object[0]);
        boolean enableExtraTLSProtocols = false;
        if (this.isClientCert()) {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
        } else {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        logger.info("protocol={0},enableExtraTLSProtocols={1}", new Object[]{this.sslContext.getProtocol(), enableExtraTLSProtocols});
        logger.exiting(TAG, "initSSLConfiguration()", new Object[0]);
    }

    public boolean isClientCert() {
        return this.getConfiguration().getCertificateDetails() != null;
    }

    public boolean isSecure() {
        return this.getConfiguration().getSecureHint();
    }

    @Override
    public String getId() {
        return this.getConfiguration().getID();
    }

    @Override
    public String getName() {
        return this.getConfiguration().getName();
    }

    @Override
    public void triggerDisconnect() {
    }
}

