/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.types;

import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.im.ims.workbench.transaction.connections.customizers.ImsTmConnectionPreferences;
import com.ibm.im.ims.workbench.transaction.connections.exceptions.ImsTmConnectionException;
import com.ibm.im.ims.workbench.transaction.connections.types.IImsTmConnection;
import com.ibm.im.ims.workbench.transaction.connections.utils.ImsTmConnectionUtil;
import com.ibm.im.ims.workbench.transaction.connections.utils.Xlat;
import com.ibm.ims.connect.Connection;
import com.ibm.ims.connect.ConnectionFactory;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectExecutionException;
import com.ibm.ims.connect.InputMessage;
import com.ibm.ims.connect.OutputMessage;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.connect.TmInteractionAttributes;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import com.ibm.ims.transaction.util.TraceWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImsTmConnection
extends AbstractConnection
implements IImsTmConnection {
    public static final String TAG = ImsTmConnection.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private ConnectionProfile connProfile;
    private Connection connection;
    private IconapiHeartbeat heartbeat = null;
    private final Lock connLock = new ReentrantLock();
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;

    @Override
    public TmInteraction createTmInteraction(TmInteractionAttributes attributes) throws ImsTmConnectionException {
        logger.entering(TAG, "createTmInteraction(TmInteractionAttributes)", new Object[0]);
        TmInteraction interaction = null;
        try {
            if (this.ensureConnected()) {
                interaction = this.connection.createInteraction(attributes);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new ImsTmConnectionException(e);
        }
        logger.exiting(TAG, "createTmInteraction():{0}", new Object[]{interaction});
        return interaction;
    }

    @Override
    public TmInteraction createTmInteraction() throws ImsTmConnectionException {
        logger.entering(TAG, "createTmInteraction()", new Object[0]);
        TmInteraction interaction = null;
        try {
            if (this.ensureConnected()) {
                interaction = this.connection.createInteraction();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new ImsTmConnectionException(e);
        }
        logger.exiting(TAG, "createTmInteraction():{0}", new Object[]{interaction});
        return interaction;
    }

    @Override
    public void executeTmInteraction(TmInteraction interaction) throws ImsTmConnectionException {
        logger.entering(TAG, "executeTmInteraction(TmInteraction)", new Object[0]);
        this.connLock.lock();
        ConnectionConfiguration configuration = null;
        ConnectionProfile profile = null;
        CredentialsConfiguration credential = null;
        try {
            try {
                configuration = this.getConfiguration();
                profile = connectionManager.getConnectionProfile(configuration.getID());
                credential = credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
                if (this.ensureConnected()) {
                    if (!this.isClientCert() && credential != null) {
                        interaction.setRacfUserId(credential.getUserID());
                        interaction.setRacfPassword(String.valueOf(credential.getPasswordAsCharArray()));
                    }
                    interaction.execute();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                if (e instanceof ImsConnectExecutionException) {
                    ImsConnectExecutionException execException = (ImsConnectExecutionException)e;
                    if (credential != null && (execException.getracfReturnCode() > 0 || StringUtils.startsWith((CharSequence)execException.getErrorMessage(), (CharSequence)"HWS0043E"))) {
                        logger.info("Authentication failed so invalidating credential: {0}", new Object[]{credential.getName()});
                        credentialsManager.invalidate(credential.getID());
                        logger.info("Disconnecting all connections that use credential: {0}", new Object[]{credential.getName()});
                        ImsTmConnectionUtil.disconnectAllWithSameCredential(profile);
                    }
                }
                throw new ImsTmConnectionException(e);
            }
        }
        finally {
            this.connLock.unlock();
        }
        logger.exiting(TAG, "executeTmInteraction(TmInteraction)", new Object[0]);
    }

    public void connect() throws ConnectionException {
        logger.entering(TAG, "connect()", new Object[0]);
        try {
            ConnectionConfiguration configuration = this.getConfiguration();
            this.connProfile = connectionManager.getConnectionProfile(configuration.getID());
            if (this.isSecure()) {
                this.initSSLConfiguration();
            }
            this.initTmConnection();
            this.pingIms();
            boolean iconPingValue = ImsTmConnectionPreferences.getImsConnectPing(configuration);
            if (iconPingValue) {
                int pingInterval = ImsTmConnectionPreferences.getImsConnectPingInterval(configuration);
                this.setPreventIdleTOTimer(pingInterval);
            }
        }
        catch (ImsTmConnectionException e) {
            logger.error((Throwable)e);
            if (e.isCausedByCertificateException()) {
                throw new ConnectionException((Exception)e);
            }
            final ConnectionConfiguration configuration = this.getConfiguration();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IStatus status = logger.createMultiStatus(4, Xlat.label("VIEW_DETAILS", new String[0]), (Throwable)e);
                    ErrorDialog.openError((Shell)XSwt.getActiveShell(), (String)Xlat.label("ERRDLG_TITLE", new String[0]), (String)Xlat.label("CONNECT_ERROR", configuration.getName()), (IStatus)status);
                }
            });
            throw new ConnectionException(e.getExternalMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new ConnectionException(e);
        }
        logger.exiting(TAG, "connect()", new Object[0]);
    }

    private void initTmConnection() throws ImsTmConnectionException {
        logger.entering(TAG, "initTmConnection()", new Object[0]);
        ConnectionConfiguration configuration = this.getConfiguration();
        ConnectionFactory imsConnFactory = null;
        try {
            imsConnFactory = new ConnectionFactory();
            imsConnFactory.setHostName(configuration.getHost());
            imsConnFactory.setPortNumber(configuration.getPort());
            imsConnFactory.setSocketType((byte)16);
            imsConnFactory.setUseSslConnection(this.isSecure());
            this.connection = imsConnFactory.getConnection();
            if (this.isSecure()) {
                this.connection.setCustomSslContext(this.sslContext);
            }
            this.connection.connect();
        }
        catch (Exception e) {
            throw new ImsTmConnectionException(e);
        }
        logger.exiting(TAG, "initTmConnection()", new Object[0]);
    }

    public void disconnect() throws ConnectionException {
        block12: {
            logger.entering(TAG, "disconnect()", new Object[0]);
            try {
                try {
                    if (this.connection != null) {
                        this.connection.disconnect();
                    }
                }
                catch (ImsConnectApiException e) {
                    logger.error((Throwable)e);
                    this.connection = null;
                    if (this.heartbeat != null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Cancelling heartbeat.");
                        }
                        this.heartbeat.cancel();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.connection = null;
                if (this.heartbeat != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Cancelling heartbeat.");
                    }
                    this.heartbeat.cancel();
                }
                throw throwable;
            }
            this.connection = null;
            if (this.heartbeat != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Cancelling heartbeat.");
                }
                this.heartbeat.cancel();
            }
        }
        logger.exiting(TAG, "disconnect()", new Object[0]);
    }

    public boolean isConnected() {
        logger.entering(TAG, "isConnected()", new Object[0]);
        boolean connected = false;
        if (this.connection != null && this.connection.isConnected()) {
            connected = true;
        }
        logger.exiting(TAG, "isConnected():{0}", new Object[]{connected});
        return connected;
    }

    public boolean ensureConnected() throws ImsTmConnectionException {
        logger.entering(TAG, "ensureConnected()", new Object[0]);
        if (!this.isConnected()) {
            this.initTmConnection();
        }
        logger.exiting(TAG, "ensureConnected()", new Object[0]);
        return this.isConnected();
    }

    public void initSSLConfiguration() throws IOException {
        logger.entering(TAG, "initSSLConfiguration()", new Object[0]);
        boolean enableExtraTLSProtocols = false;
        if (this.isClientCert()) {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
        } else {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        logger.info("protocol={0},enableExtraTLSProtocols={1}", new Object[]{this.sslContext.getProtocol(), enableExtraTLSProtocols});
        logger.exiting(TAG, "initSSLConfiguration()", new Object[0]);
    }

    public boolean isClientCert() {
        return this.getConfiguration().getCertificateDetails() != null;
    }

    public boolean isSecure() {
        return this.getConfiguration().getSecureHint();
    }

    @Override
    public String getId() {
        return this.getConfiguration().getID();
    }

    @Override
    public String getName() {
        return this.getConfiguration().getName();
    }

    private void pingIms() throws ImsTmConnectionException, ImsConnectApiException, UnsupportedEncodingException {
        this.connLock.lock();
        try {
            TmInteraction tmInteraction = this.createTmInteraction();
            String datastoreName = ImsTmConnectionPreferences.getImsDatastoreName();
            if (datastoreName != null && !datastoreName.isEmpty()) {
                tmInteraction.setImsDatastoreName(datastoreName);
            }
            tmInteraction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(false);
            tmInteraction.setTrancode("");
            InputMessage inMsg = tmInteraction.getInputMessage();
            byte[][] byteArray = new byte[1][];
            String inputMsgStr = "PING IMS_CONNECT";
            byteArray[0] = inputMsgStr.getBytes("037");
            TraceWriter tw = null;
            if (logger.isLoggable(Level.FINEST)) {
                tw = new TraceWriter();
                int i = 0;
                while (i < 1) {
                    tw.traceBuffer(byteArray[i], 0, byteArray[i].length, 1);
                    ++i;
                }
            }
            inMsg.setInputMessageData((byte[][])byteArray);
            this.executeTmInteraction(tmInteraction);
            OutputMessage outMsg = tmInteraction.getOutputMessage();
            byte[][] outputByteArray = outMsg.getDataAsArrayOfByteArrays();
            if (logger.isLoggable(Level.FINEST)) {
                int i = 0;
                while (i < outputByteArray.length) {
                    tw.traceBuffer(outputByteArray[i], 0, outputByteArray[i].length, 2);
                    ++i;
                }
            }
        }
        finally {
            this.connLock.unlock();
        }
    }

    private void setPreventIdleTOTimer(int pingInterval) {
        Timer timer = new Timer();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Scheduling recurring timer!");
        }
        this.heartbeat = new IconapiHeartbeat(this);
        timer.scheduleAtFixedRate((TimerTask)this.heartbeat, pingInterval, (long)pingInterval);
    }

    public void setConnProfile(ConnectionProfile connProfile) {
        this.connProfile = connProfile;
    }

    @Override
    public void triggerDisconnect() {
        ImsTmConnectionUtil.doDisconnect(this.connProfile);
    }

    private class IconapiHeartbeat
    extends TimerTask {
        private ImsTmConnection conn = null;

        public IconapiHeartbeat(ImsTmConnection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("27 seconds have passed!");
                    logger.finer("Pinging IMS to keep iconapi connection open.");
                }
                this.conn.pingIms();
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Exception occurred while pinging IMS: " + e.getMessage(), new Object[0]);
            }
            catch (ImsTmConnectionException | ImsConnectApiException e) {
                String errorMsg = "IMS Connect connection lost. Failure occurred while attempting to ping IMS Connect in order to prevent an Idle Timeout: " + e.getMessage();
                boolean isDisconnectException = false;
                if (errorMsg.contains("socket") || errorMsg.contains("EOFException")) {
                    isDisconnectException = true;
                }
                ImsTmConnection imsTmConnForDisconnect = null;
                if (isDisconnectException) {
                    imsTmConnForDisconnect = this.conn;
                }
                RunDialog runErrorPopup = new RunDialog(errorMsg, "Error", imsTmConnForDisconnect);
                Display.getDefault().syncExec((Runnable)runErrorPopup);
            }
        }
    }

    private class RunDialog
    implements Runnable {
        private ImsTmConnection connection;
        private String errorMsg;
        private String title;

        public RunDialog(String errorMsg, String title, ImsTmConnection connection) {
            this.errorMsg = errorMsg;
            this.title = title;
            this.connection = connection;
        }

        @Override
        public void run() {
            if (this.connection != null) {
                this.connection.triggerDisconnect();
            }
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)this.title, (String)this.errorMsg);
        }
    }
}

