/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.listeners;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;

public class ImsTmConnectionServiceListener
extends ConnectionServiceListener {
    public static final String TAG = ImsTmConnectionServiceListener.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
        logger.entering(TAG, "event(event={0})", new Object[]{event});
        try {
            if ("com.ibm.im.ims.workbench.transaction.connections.category".equals(event.getConnectionCategoryId())) {
                ConnectionProfile profile = event.getConnectionProfile();
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    logger.info("IMS TM connection \"{0}\" {1} connected", new Object[]{profile.getName(), profile.getId()});
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    logger.info("IMS TM connection \"{0}\" {1} disconnected", new Object[]{profile.getName(), profile.getId()});
                } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                    Exception eventException = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                    logger.info("IMS TM connection \"{0}\" {1} exception: {2}", new Object[]{profile.getName(), profile.getId(), eventException.getMessage()});
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "event(ConnectionServiceEvent)", new Object[0]);
    }
}

