/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.exceptions;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.im.ims.workbench.transaction.connections.exceptions.IImsTmConnectionException;
import com.ibm.ims.connect.ImsConnectCommunicationException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.bind.JAXBException;

public class ImsTmConnectionException
extends Exception
implements IImsTmConnectionException {
    private static final long serialVersionUID = 1L;
    private IConnection connection;

    public ImsTmConnectionException() {
    }

    public ImsTmConnectionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ImsTmConnectionException(String message, Throwable cause, IConnection connection) {
        super(message, cause);
        this.connection = connection;
    }

    public ImsTmConnectionException(Throwable throwable, IConnection connection) {
        super(throwable);
        this.connection = connection;
    }

    public ImsTmConnectionException(String message, IConnection connection) {
        super(message);
        this.connection = connection;
    }

    public ImsTmConnectionException(String message) {
        super(message);
    }

    public ImsTmConnectionException(Throwable cause) {
        super(cause);
    }

    @Override
    public Exception getExternalException() {
        return this;
    }

    @Override
    public String getExternalMessage() {
        return this.getMessage();
    }

    public static String getMessage(Throwable t) {
        String msg;
        String retVal = t.getMessage();
        if (t instanceof JAXBException && (msg = ImsTmConnectionException.getMessage((JAXBException)t)) != null) {
            retVal = msg;
        }
        return retVal;
    }

    private static String getMessage(JAXBException e) {
        String retVal = e.getMessage();
        Throwable linked = e.getLinkedException();
        if (linked != null && linked.getMessage() != null && !linked.getMessage().isEmpty()) {
            retVal = linked.getMessage();
        }
        return retVal;
    }

    @Override
    public boolean isCausedByConnectivityException() {
        boolean isConnectivityException = false;
        Throwable cause = this.getCause();
        if (cause instanceof ConnectException || cause instanceof SocketException || cause instanceof UnknownHostException || cause instanceof SocketTimeoutException) {
            isConnectivityException = true;
        }
        return isConnectivityException;
    }

    @Override
    public boolean isCausedBySecurityException() {
        return false;
    }

    @Override
    public boolean isCausedByUnexpectedResponse() {
        return false;
    }

    @Override
    public boolean isCausedByCertificateException() {
        boolean result = false;
        Throwable cause = this.getCause();
        if (cause instanceof ImsConnectCommunicationException) {
            cause = cause.getCause();
        }
        if (cause instanceof SSLHandshakeException && cause.getCause() instanceof CertificateException) {
            result = true;
        }
        return result;
    }

    public static String getExternalMessage(StackTraceElement ele) {
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append(ele.getClassName());
        msgBuf.append(".");
        msgBuf.append(ele.getMethodName());
        msgBuf.append("(");
        if (ele.isNativeMethod()) {
            msgBuf.append("Native Method");
        } else if (ele.getFileName() != null) {
            msgBuf.append(ele.getFileName());
            if (ele.getLineNumber() >= 0) {
                msgBuf.append(":");
                msgBuf.append(ele.getLineNumber());
            }
        } else {
            msgBuf.append("Unknown Source");
        }
        msgBuf.append(")");
        return msgBuf.toString();
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }
}

