/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.customizers;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.preferences.ImsTmPreferenceConstants;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.runtime.Platform;

public class ImsTmConnectionPreferences
implements ImsTmPreferenceConstants {
    public static final String TAG = ImsTmConnectionPreferences.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public static void setImsConnectPingInterval(int value, ConnectionConfiguration configuration) {
        logger.entering(TAG, "setImsConnectPingInterval(value={0},configuration={1})", new Object[]{value, configuration});
        try {
            configuration.setExtendedAttribute("IPC_IMS_CONNECT_PING_INTERVAL", String.valueOf(value));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "setImsConnectPingInterval(String,String)", new Object[0]);
    }

    public static void setImsConnectPingInterval(String value, ConnectionConfiguration configuration) {
        logger.entering(TAG, "setImsConnectPingInterval(value={0},configuration={1})", new Object[]{value, configuration});
        try {
            configuration.setExtendedAttribute("IPC_IMS_CONNECT_PING_INTERVAL", String.valueOf(value));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "setImsConnectPingInterval(String,String)", new Object[0]);
    }

    public static int getImsConnectPingInterval(ConnectionConfiguration configuration) {
        logger.entering(TAG, "getImsConnectPingInterval(configuration={0})", new Object[]{configuration});
        int imsConnectPingInterval = Platform.getPreferencesService().getInt("com.ibm.im.ims.workbench.transaction", "IPC_IMS_CONNECT_PING_INTERVAL", DEFAULT_IMS_CONNECT_PING_INTERVAL.intValue(), null);
        try {
            imsConnectPingInterval = NumberUtils.toInt((String)configuration.getExtendedAttribute("IPC_IMS_CONNECT_PING_INTERVAL"), (int)imsConnectPingInterval);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "getImsConnectPingInterval(int,String)", new Object[0]);
        return imsConnectPingInterval;
    }

    public static int getDefaultImsConnectPingInterval() {
        return DEFAULT_IMS_CONNECT_PING_INTERVAL;
    }

    public static String getImsDatastoreName() {
        logger.entering(TAG, "getImsDatastoreName()", new Object[0]);
        String imsDatastoreName = Platform.getPreferencesService().getString("com.ibm.im.ims.workbench.transaction", "IPC_IMS_DATASTORE_NAME", "MYDSTRNM", null);
        logger.exiting(TAG, "getImsDatastoreName()", new Object[0]);
        return imsDatastoreName;
    }

    public static String getDefaultImsDatastoreName() {
        return "MYDSTRNM";
    }

    public static void setImsConnectPing(boolean value, ConnectionConfiguration configuration) {
        logger.entering(TAG, "setImsConnectPing(value={0},configuration={1})", new Object[]{value, configuration});
        try {
            configuration.setExtendedAttribute("IPC_IMS_CONNECT_PING", String.valueOf(value));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "setImsConnectPing(boolean,String)", new Object[0]);
    }

    public static boolean getImsConnectPing(ConnectionConfiguration configuration) {
        logger.entering(TAG, "getImsConnectPing(configuration={0})", new Object[]{configuration});
        boolean imsConnectPing = Platform.getPreferencesService().getBoolean("com.ibm.im.ims.workbench.transaction", "IPC_IMS_CONNECT_PING", DEFAULT_IMS_CONNECT_PING.booleanValue(), null);
        try {
            imsConnectPing = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)configuration.getExtendedAttribute("IPC_IMS_CONNECT_PING")), (boolean)imsConnectPing);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "getImsConnectPing()", new Object[0]);
        return imsConnectPing;
    }

    public static boolean getDefaultImsConnectPing() {
        return DEFAULT_IMS_CONNECT_PING;
    }
}

