/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.connections.customizers;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.AbstractConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.im.ims.workbench.transaction.connections.customizers.ImsTmConnectionPreferences;
import com.ibm.im.ims.workbench.transaction.connections.utils.Xlat;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.preferences.ImsTmPreferenceConstants;
import com.ibm.ims.explorer.eclipse.common.swt.ButtonBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.CompositeBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.LabelBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.TextBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImsTmConnectionCustomizer
extends AbstractConnectionCustomizer
implements ModifyListener,
SelectionListener,
ImsTmPreferenceConstants {
    public static final String TAG = ImsTmConnectionCustomizer.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Label iconPingIntervalStartLabel = null;
    private Text iconPingInterval = null;
    private Label iconPingIntervalEndLabel = null;
    private Button iconPing = null;
    private FieldDecorationRegistry decorationRegistry = FieldDecorationRegistry.getDefault();
    private FieldDecoration errorFieldDecoration = this.decorationRegistry.getFieldDecoration("DEC_ERROR");
    private ControlDecoration iconPingIntervalDecoration;
    private Boolean iconPingValue;
    private Integer iconPingIntervalValue;
    private ConnectionConfiguration configuration;

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        logger.entering(TAG, "setConfiguration(configID={0})", new Object[]{connectionConfiguration.getID()});
        this.configuration = connectionConfiguration;
        this.iconPingValue = ImsTmConnectionPreferences.getImsConnectPing(this.configuration);
        XSwt.setSelection((Button)this.iconPing, (boolean)this.iconPingValue);
        this.iconPingIntervalValue = ImsTmConnectionPreferences.getImsConnectPingInterval(this.configuration);
        if (this.iconPingValue.booleanValue()) {
            XSwt.setText((Text)this.iconPingInterval, (Integer)this.iconPingIntervalValue);
        }
        this.addListeners();
        this.updateWidgetEnableStates();
        logger.exiting(TAG, "setConfiguration(ConnectionConfiguration)", new Object[0]);
    }

    public void createControl(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.minimumHeight = -1;
        Composite health = (Composite)new CompositeBuilder().numColumns(3).verticalIndent(5).marginHeight(0).marginWidth(0).grabExcessVerticalSpace(false).grabExcessHorizontalSpace(false).build(parent);
        this.iconPing = (Button)new ButtonBuilder().text(Xlat.label("ICON_PING", new String[0])).toolTipText(Xlat.label("ICON_PING_TOOLTIP", new String[0])).style(Integer.valueOf(32)).horizontalSpan(3).build(health);
        this.iconPingIntervalStartLabel = (Label)new LabelBuilder().text(Xlat.label("ICON_PING_INTERVAL", new String[0]) + Xlat.colon()).toolTipText(Xlat.label("ICON_PING_INTERVAL_TOOLTIP", new String[0])).horizontalIndent(25).build(health);
        this.iconPingInterval = (Text)new TextBuilder().toolTipText(Xlat.label("ICON_PING_INTERVAL_TOOLTIP", new String[0])).horizontalIndent(this.decorationRegistry.getMaximumDecorationWidth()).widthHint(150).build(health);
        this.iconPingIntervalEndLabel = new LabelBuilder().text(Xlat.label("UNIT_MILLISECONDS", new String[0])).build(health);
        this.iconPingIntervalDecoration = new ControlDecoration((Control)this.iconPingInterval, 16512);
        this.iconPingIntervalDecoration.setImage(this.errorFieldDecoration.getImage());
        this.iconPingIntervalDecoration.hide();
    }

    private void addListeners() {
        if (XSwt.isNotDisposed((Control)this.iconPing)) {
            this.iconPing.addSelectionListener((SelectionListener)this);
        }
        if (XSwt.isNotDisposed((Control)this.iconPingInterval)) {
            this.iconPingInterval.addModifyListener((ModifyListener)this);
        }
    }

    public void clear() {
        this.configuration = null;
    }

    public void performDefaults() {
    }

    public void updateCurrentConfiguration() {
        ImsTmConnectionPreferences.setImsConnectPing(this.iconPingValue, this.configuration);
        if (this.iconPingValue.booleanValue()) {
            ImsTmConnectionPreferences.setImsConnectPingInterval(this.iconPingIntervalValue, this.configuration);
        } else {
            ImsTmConnectionPreferences.setImsConnectPingInterval("", this.configuration);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelectedImpl(event);
    }

    public void widgetSelected(SelectionEvent event) {
        this.widgetSelectedImpl(event);
    }

    private void widgetSelectedImpl(SelectionEvent event) {
        Object source = event.getSource();
        if (source == this.iconPing) {
            this.iconPingValue = XSwt.getSelection((Button)this.iconPing);
            if (this.iconPingValue.booleanValue()) {
                XSwt.setText((Text)this.iconPingInterval, (Integer)this.iconPingIntervalValue);
            } else {
                XSwt.setText((Text)this.iconPingInterval, (String)"");
            }
            for (IConnectionCustomizerListener listener : this.getListeners()) {
                listener.propertyChanged("IPC_IMS_CONNECT_PING", (Object)this.iconPingValue);
            }
        }
    }

    public void modifyText(ModifyEvent event) {
        Object source = event.getSource();
        if (source == this.iconPingInterval && XSwt.isEnabled((Control)this.iconPingInterval)) {
            String iconPingIntervalText = XSwt.getText((Text)this.iconPingInterval);
            try {
                this.iconPingIntervalValue = Integer.valueOf(iconPingIntervalText);
            }
            catch (NumberFormatException numberFormatException) {}
            for (IConnectionCustomizerListener listener : this.getListeners()) {
                listener.propertyChanged("IPC_IMS_CONNECT_PING_INTERVAL", (Object)iconPingIntervalText);
            }
        }
    }

    private void updateWidgetEnableStates() {
        if (this.iconPingValue.booleanValue()) {
            XSwt.enable((Control[])new Control[]{this.iconPingIntervalStartLabel, this.iconPingInterval, this.iconPingIntervalEndLabel});
        } else {
            XSwt.disable((Control[])new Control[]{this.iconPingIntervalStartLabel, this.iconPingInterval, this.iconPingIntervalEndLabel});
        }
    }

    public String validateEnteredData() {
        String message = null;
        this.updateWidgetEnableStates();
        this.iconPingIntervalDecoration.setDescriptionText("");
        this.iconPingIntervalDecoration.hide();
        if (StringUtils.isBlank(message) && XSwt.isEnabled((Control)this.iconPingInterval)) {
            try {
                this.iconPingIntervalValue = Integer.valueOf(XSwt.getText((Text)this.iconPingInterval));
                if (this.iconPingIntervalValue < 1 || this.iconPingIntervalValue > Integer.MAX_VALUE) {
                    message = Xlat.label("INVALID_ICON_PING_INTERVAL_VALUE", new String[0]);
                    this.iconPingIntervalDecoration.setDescriptionText(message);
                    this.iconPingIntervalDecoration.show();
                }
            }
            catch (NumberFormatException numberFormatException) {
                message = Xlat.label("INVALID_ICON_PING_INTERVAL_VALUE", new String[0]);
                this.iconPingIntervalDecoration.setDescriptionText(message);
                this.iconPingIntervalDecoration.show();
            }
        }
        return message;
    }
}

