/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli2xsd.typesimport;

import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.etools.tdlang.TDLangModelElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class PliTypeHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static PliTypeHelper fieldInstance;
    private Resource importerResource;

    PliTypeHelper() {
    }

    public static synchronized PliTypeHelper getInstance() {
        if (fieldInstance == null) {
            fieldInstance = new PliTypeHelper();
        }
        return fieldInstance;
    }

    public List getPliTopElements() {
        ArrayList eleList = new ArrayList();
        if (this.importerResource == null) {
            return eleList;
        }
        for (Object possibleType : this.importerResource.getContents()) {
            PLIClassifier childClassifier;
            if (!(possibleType instanceof PLIElement) || !((childClassifier = ((PLIElement)possibleType).getSharedType()) instanceof PLIComposedType)) continue;
            eleList.add(possibleType);
        }
        return eleList;
    }

    public void importPli(IFile typesFile, HashMap options) throws Exception {
        String fullPath = typesFile.getLocation().toOSString();
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(URI.createFileURI((String)fullPath));
        this.importerResource = factory.createResource(URI.createFileURI((String)fullPath));
        this.importerResource.load((Map)options);
    }

    public String getPathFromURI(URI uri) {
        return uri.path();
    }

    public static String getID(TDLangModelElement elem) {
        String id = null;
        id = PliTypeHelper.getRefId((EObject)elem);
        return id;
    }

    public static String getRefId(EObject pe) {
        String refID = null;
        String elementName = "";
        String path = "";
        PLIElement pliElement = null;
        if (pe instanceof PLIElement) {
            refID = "Element:";
            pliElement = (PLIElement)pe;
        } else if (pe instanceof PLIClassifier) {
            refID = "Type:";
            pliElement = (PLIElement)((PLIClassifier)pe).getTypedElement().get(0);
        }
        elementName = pliElement.getName();
        while (pliElement.getGroup() != null) {
            PLIElement parentPE = (PLIElement)pliElement.getGroup().getTypedElement().get(0);
            path = String.valueOf(parentPE.getName()) + "/" + path;
            pliElement = parentPE;
        }
        refID = String.valueOf(refID) + path + elementName;
        return refID;
    }
}

