/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLIElementInitialValue;
import com.ibm.ccl.pli.PLIFixedBoundArray;
import com.ibm.ccl.pli.PLIFixedLboundArray;
import com.ibm.ccl.pli.PLIHboundArray;
import com.ibm.ccl.pli.PLINamedType;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.PLIStringType;
import com.ibm.ccl.pli.PLIVariableBoundArray;
import com.ibm.ccl.pli2xsd.INameConverter;
import com.ibm.ccl.pli2xsd.MessageResource;
import com.ibm.ccl.pli2xsd.Pli2XSDPlugin;
import com.ibm.ccl.pli2xsd.typesimport.PLINameConverter;
import com.ibm.ccl.pli2xsd.typesimport.PliTypeHelper;
import com.ibm.ccl.pli2xsd.typesimport.XsdHelper;
import com.ibm.ccl.pli2xsd.util.GeneralUtil;
import com.ibm.etools.tdlang.TDLangModelElement;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PliElementVisitor {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected IFile pliFile;
    protected XSDComplexTypeDefinition topComplexType;
    protected boolean isThisTopComplexType = true;
    protected List topTypes;
    protected XSDFactory xsdFactory;
    protected XSDSchema xsdSchema;
    protected PliTypeHelper pliHelper;
    protected XsdHelper xsdHelper;
    protected GeneralUtil util;
    protected Map xsdTypesTdBasePair;
    protected boolean overwriteTypes;
    protected String topTypeName;
    protected String origTopTypeName;
    private Map elementSwapMap = new HashMap();
    private Map pathArrayOfXsdPair = new HashMap();
    private INameConverter converter;
    protected String topTypePrefix;
    protected boolean generateFlat;
    private int offsetAdjustment = 0;
    public static final int VISIT_ITEM = 1;
    public static final int VISIT_CHILDREN = 2;

    public PliElementVisitor() {
        this.xsdFactory = XSDFactoryImpl.eINSTANCE;
        this.pliHelper = PliTypeHelper.getInstance();
        this.xsdHelper = XsdHelper.getNewInstance();
        this.util = GeneralUtil.getInstance();
        this.converter = this.getConverter();
        this.converter.initialize(this.xsdHelper);
        this.topTypes = new ArrayList();
    }

    private XSDSchemaContent getParentXsdType(String path) {
        int slashPos;
        if (path.indexOf(":") >= 0) {
            path = GeneralUtil.getPathFromRefID(path);
        }
        if ((slashPos = path.lastIndexOf("/")) >= 0) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        return this.xsdHelper.getThisXsdType(path, this.elementSwapMap);
    }

    private void populateInitial(PLIElement item, XSDElementDeclaration elementDec) {
        EList initList = item.getInitial();
        if (initList != null) {
            if (initList.isEmpty()) {
                return;
            }
            PLIElementInitialValue initValObj = (PLIElementInitialValue)initList.get(0);
            String initVal = initValObj.getInitialValue();
            XSDAnnotation annotation = elementDec.getAnnotation();
            if (annotation == null) {
                annotation = this.xsdFactory.createXSDAnnotation();
                elementDec.setAnnotation(annotation);
            }
            if (this.xsdSchema.getElement() == null) {
                this.xsdSchema.updateElement();
            }
            Element appInfoElement = annotation.createApplicationInformation("http://www.wsadie.com/appinfo");
            annotation.getElement().appendChild(appInfoElement);
            Element initTag = annotation.getElement().getOwnerDocument().createElement("initialValue");
            String valType = initValObj.getInitialValue();
            if (valType != null) {
                if (valType.equalsIgnoreCase("zero_value")) {
                    initTag.setAttribute("kind", "ZERO");
                } else if (valType.equalsIgnoreCase("space_value")) {
                    initTag.setAttribute("kind", "SPACE");
                } else if (initVal != null) {
                    if (initVal.equals("0")) {
                        initTag.setAttribute("kind", "ZERO");
                    } else if (initVal.equals(" ")) {
                        initTag.setAttribute("kind", "SPACE");
                    } else if (initVal.equals("'")) {
                        initTag.setAttribute("kind", "ALL");
                        initTag.setAttribute("value", initVal);
                    } else if (item.getSharedType() instanceof PLIStringType) {
                        if (valType.equalsIgnoreCase("all_literal")) {
                            initTag.setAttribute("kind", "ALL");
                            initTag.setAttribute("value", initVal);
                        } else {
                            initTag.setAttribute("kind", valType);
                            initTag.setAttribute("value", initVal);
                        }
                    } else {
                        initTag.setAttribute("kind", valType);
                        initTag.setAttribute("value", initVal);
                    }
                } else {
                    initTag.setAttribute("kind", valType);
                }
                appInfoElement.appendChild(initTag);
            }
        }
    }

    private void adjustOffset(InstanceTDBase tdBase) {
        if (this.offsetAdjustment != 0) {
            tdBase.setOffset(String.valueOf(Integer.parseInt(tdBase.getOffset()) - this.offsetAdjustment));
        }
    }

    public boolean visit(Object item) throws CoreException {
        if (item instanceof PLIElement) {
            this.visitPLIElement((PLIElement)item);
        } else if (item instanceof PLISimpleType) {
            return false;
        }
        this.acceptItemVisitor(item, 2);
        return true;
    }

    public void visitPLIComposedType(PLIElement item, XSDSchemaContent parent) throws BaseException {
        String refID = PliTypeHelper.getID((TDLangModelElement)item);
        if (this.isThisTopComplexType) {
            if (!item.getInstanceTDBase().getOffset().equals("0")) {
                this.offsetAdjustment = Integer.parseInt(item.getInstanceTDBase().getOffset());
            }
            this.origTopTypeName = item.getName();
            this.topComplexType = this.xsdFactory.createXSDComplexTypeDefinition();
            this.topTypeName = this.util.getJavaNameFromXMLName(this.topTypeName);
            if (this.generateFlat) {
                this.topTypeName = this.util.capitalizeFirstLetter(this.topTypeName);
            }
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                this.topTypeName = String.valueOf(this.topTypePrefix) + this.topTypeName;
            }
            this.topComplexType.setName(this.topTypeName);
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)this.topComplexType, this.xsdSchema, this.overwriteTypes);
            this.topTypes.add(this.topComplexType);
            XSDParticle part = this.xsdFactory.createXSDParticle();
            XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.get((String)"sequence"));
            part.setContent((XSDParticleContent)modelGroup);
            this.topComplexType.setContent((XSDComplexTypeContent)part);
            this.adjustOffset(item.getInstanceTDBase());
            this.xsdTypesTdBasePair.put(this.topComplexType, item.getInstanceTDBase());
            this.xsdHelper.putPathXsdPair(GeneralUtil.getPathFromRefID(refID), this.topComplexType);
            this.isThisTopComplexType = false;
        } else {
            XSDParticle groupPart;
            String groupName = this.xsdHelper.createGroupNameFromRefID(refID, this.topTypeName);
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                groupName = String.valueOf(this.topTypePrefix) + groupName.substring(this.topTypePrefix.length());
            } else if (UCharacter.isDigit((int)UTF16.charAt((String)groupName, (int)0))) {
                groupName = "__" + groupName;
            }
            XSDModelGroupDefinition group = this.xsdHelper.createGroupDef(groupName, "sequence", this.xsdSchema);
            group.setTargetNamespace(this.xsdSchema.getTargetNamespace());
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)group, this.xsdSchema, this.overwriteTypes);
            this.topTypes.add(group);
            if (parent == null) {
                parent = this.getParentXsdType(refID);
            }
            this.adjustOffset(item.getInstanceTDBase());
            if (this.generateFlat) {
                groupPart = this.xsdHelper.createGroupRefParticle(group);
                this.xsdTypesTdBasePair.put(group, item.getInstanceTDBase());
            } else {
                groupPart = this.xsdHelper.createComplexTypeParticle(this.converter.getConvertedName(GeneralUtil.getElementNameFromPathNoCaseChange(refID), this.createPathVector(refID), item, this.origTopTypeName, this.topTypeName, this.generateFlat), groupName, this.xsdSchema);
                this.xsdTypesTdBasePair.put(groupPart.getContent(), item.getInstanceTDBase());
            }
            XSDModelGroup parentModelGroup = this.xsdHelper.getModelGroup(parent);
            parentModelGroup.getContents().add((Object)groupPart);
            this.xsdHelper.putPathXsdPair(GeneralUtil.getPathFromRefID(refID), group);
            if (!this.generateFlat) {
                XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
                complexType.setName(groupName);
                XSDParticle modelGroupParticle = this.xsdHelper.createGroupRefParticle(group);
                complexType.setContent((XSDComplexTypeContent)modelGroupParticle);
                this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)complexType, this.xsdSchema, this.overwriteTypes);
                this.topTypes.add(complexType);
            }
        }
    }

    public void visitPLIElement(PLIElement item) throws BaseException {
        if (item.getArray() != null && item.getArray().size() != 0) {
            this.visitArray(item, null);
        } else if (item.getSharedType() instanceof PLIComposedType) {
            this.visitPLIComposedType(item, null);
        } else if (item.getSharedType() instanceof PLISimpleType) {
            this.visitPLISimpleType(item, null);
        } else if (item.getSharedType() instanceof PLINamedType) {
            this.visitPLINamedType(item, null);
        }
    }

    public void visitPLISimpleType(PLIElement item, XSDSchemaContent parent) {
        PLISimpleType pliST = (PLISimpleType)item.getSharedType();
        String refID = PliTypeHelper.getID((TDLangModelElement)item);
        String name = this.converter.getConvertedName(GeneralUtil.getElementNameFromPathNoCaseChange(refID), this.createPathVector(refID), item, this.origTopTypeName, this.topTypeName, this.generateFlat);
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        elementDec.setName(name);
        elementPart.setContent((XSDParticleContent)elementDec);
        if (parent == null) {
            parent = this.getParentXsdType(refID);
        }
        this.xsdHelper.getModelGroup(parent).getContents().add((Object)elementPart);
        this.populateInitial(item, elementDec);
        elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDSimpleType(pliST, this.xsdSchema));
        this.adjustOffset(item.getInstanceTDBase());
        this.xsdTypesTdBasePair.put(elementDec, item.getInstanceTDBase());
        this.xsdHelper.putPathXsdPair(GeneralUtil.getPathFromRefID(refID), elementDec);
    }

    public void visitPLINamedType(PLIElement item, XSDSchemaContent parent) throws BaseException {
    }

    public void visitPLIHboundArray(PLIElement item, PLIHboundArray array, XSDSchemaContent parent) throws BaseException {
        this.visitArray(item, parent);
    }

    public void visitPLIFixedLboundArray(PLIElement item, PLIFixedLboundArray array, XSDSchemaContent parent) throws BaseException {
        this.visitArray(item, parent);
    }

    private XSDSchemaContent generateAndRegisterComplexType(XSDElementDeclaration elementDec, String ctName, String groupName) throws BaseException {
        XSDComplexTypeDefinition xsdCT = this.xsdHelper.createComplexTypeWithModelGroup(ctName, "sequence");
        xsdCT.setTargetNamespace(this.xsdSchema.getTargetNamespace());
        elementDec.setTypeDefinition((XSDTypeDefinition)xsdCT);
        this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)xsdCT, this.xsdSchema, this.overwriteTypes);
        XSDModelGroupDefinition group = this.xsdHelper.createGroupDef(groupName, "sequence", this.xsdSchema);
        this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)group, this.xsdSchema, this.overwriteTypes);
        XSDParticle groupRefPart = this.xsdHelper.createGroupRefParticle(group);
        XSDModelGroup ctModelGroup = this.xsdHelper.getModelGroup(xsdCT);
        ctModelGroup.getContents().add((Object)groupRefPart);
        return group;
    }

    private XSDParticle generateElementDeclaration(String elementName) {
        XSDParticle elePart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        elementDec.setName(elementName);
        elePart.setContent((XSDParticleContent)elementDec);
        return elePart;
    }

    private XSDParticle generateFixedBoundElementDeclaration(String elementName, PLIFixedBoundArray array) {
        XSDParticle elePart = this.generateElementDeclaration(elementName);
        int maxValue = array.getUBound() - array.getLBound() + 1;
        elePart.setMinOccurs(maxValue);
        elePart.setMaxOccurs(maxValue);
        return elePart;
    }

    private XSDParticle generateFixedLboundElementDeclaration(String elementName, PLIFixedLboundArray array) throws BaseException {
        XSDParticle elePart = this.generateElementDeclaration(elementName);
        elePart.setMinOccurs(array.getLBound().intValue());
        return elePart;
    }

    private XSDParticle generatePLIHboundElementDeclaration(String elementName, PLIHboundArray array) throws BaseException {
        XSDParticle elePart = this.generateElementDeclaration(elementName);
        elePart.setMaxOccurs(array.getUBound().intValue());
        return elePart;
    }

    private XSDParticle generatePLIVariableElementDeclaration(String elementName, PLIVariableBoundArray array) throws BaseException {
        XSDParticle elePart = this.generateElementDeclaration(elementName);
        elePart.setMinOccurs(0);
        elePart.setMaxOccurs(10);
        return elePart;
    }

    private void createAnnotationForVariableLengthArray(XSDElementDeclaration elementDec, PLIElement dependEle) throws BaseException {
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        elementDec.setAnnotation(annotation);
        if (this.xsdSchema.getElement() == null) {
            this.xsdSchema.updateElement();
        }
        Element annotationElement = annotation.getElement();
        Element appInfoElement = annotation.createApplicationInformation("http://www.wsadie.com/appinfo");
        annotationElement.appendChild(appInfoElement);
        Element dependingOnEle = annotationElement.getOwnerDocument().createElement("dependingOn");
        XSDElementDeclaration dependType = (XSDElementDeclaration)this.xsdHelper.getThisXsdType(PliTypeHelper.getID((TDLangModelElement)dependEle));
        if (dependType == null) {
            String errorMsg = MessageResource._ERROR_missing_referred_element;
            Status status = new Status(4, Pli2XSDPlugin.getPluginID(), 4, errorMsg, null);
            throw new BaseException((IStatus)status);
        }
        String dependedName = this.generateFlat ? dependType.getName() : dependType.eResource().getURIFragment((EObject)dependType);
        Text text = annotationElement.getOwnerDocument().createTextNode(dependedName);
        dependingOnEle.appendChild(text);
        appInfoElement.appendChild(dependingOnEle);
    }

    public void visitPLIFixedBoundArray(PLIElement item, PLIFixedBoundArray array, XSDSchemaContent parent) throws BaseException {
        this.visitArray(item, parent);
    }

    private String genArrayOfString(int num) {
        StringBuffer buf = new StringBuffer("");
        int i = 0;
        while (i < num) {
            buf.append("ArrayOf");
            ++i;
        }
        return buf.toString();
    }

    private void visitArray(PLIElement item, XSDSchemaContent parent) throws BaseException {
        String topGroupName;
        String refID = PliTypeHelper.getID((TDLangModelElement)item);
        PLIClassifier pliType = item.getSharedType();
        String crefID = PliTypeHelper.getID((TDLangModelElement)pliType);
        String topElementName = this.converter.getConvertedName(GeneralUtil.getElementNameFromPathNoCaseChange(refID), this.createPathVector(refID), item, this.origTopTypeName, this.topTypeName, this.generateFlat);
        String topCTName = topGroupName = this.xsdHelper.createGroupNameFromRefID(crefID, this.topTypeName);
        topCTName = this.util.getJavaNameFromXMLName(topCTName.toLowerCase());
        topCTName = this.util.capitalizeFirstLetter(topCTName);
        if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
            topCTName = String.valueOf(this.topTypePrefix) + topCTName.substring(this.topTypePrefix.length());
            topGroupName = String.valueOf(this.topTypePrefix) + topGroupName.substring(this.topTypePrefix.length());
        }
        XSDElementDeclaration topElementDeclaration = null;
        XSDElementDeclaration lastElementDeclaration = null;
        XSDSchemaContent currentParent = parent;
        if (currentParent == null) {
            currentParent = this.getParentXsdType(GeneralUtil.getPathFromRefID(refID));
        }
        String currentRefID = refID;
        int dimSize = item.getArray().size();
        ArrayList<XSDElementDeclaration> arrayList = (ArrayList<XSDElementDeclaration>)this.pathArrayOfXsdPair.get(GeneralUtil.getPathFromRefID(refID));
        if (arrayList == null) {
            arrayList = new ArrayList<XSDElementDeclaration>(dimSize);
            this.pathArrayOfXsdPair.put(GeneralUtil.getPathFromRefID(refID), arrayList);
        }
        int index = 0;
        while (index < dimSize) {
            String elementName = index == 0 ? topElementName : String.valueOf(this.genArrayOfString(dimSize - index)) + topCTName;
            String ctName = String.valueOf(this.genArrayOfString(dimSize - index - 1)) + topCTName;
            String groupName = String.valueOf(this.genArrayOfString(dimSize - index - 1)) + topGroupName;
            Object o = item.getArray().get(index);
            XSDParticle part = null;
            if (o instanceof PLIVariableBoundArray) {
                part = this.generatePLIVariableElementDeclaration(elementName, (PLIVariableBoundArray)o);
            } else if (o instanceof PLIHboundArray) {
                part = this.generatePLIHboundElementDeclaration(elementName, (PLIHboundArray)o);
            } else if (o instanceof PLIFixedLboundArray) {
                part = this.generateFixedLboundElementDeclaration(elementName, (PLIFixedLboundArray)o);
            } else if (o instanceof PLIFixedBoundArray) {
                part = this.generateFixedBoundElementDeclaration(elementName, (PLIFixedBoundArray)o);
            } else {
                throw new IllegalStateException();
            }
            XSDElementDeclaration elementDec = (XSDElementDeclaration)part.getContent();
            if (index == 0) {
                topElementDeclaration = elementDec;
            }
            if (index == dimSize - 1) {
                lastElementDeclaration = elementDec;
            }
            if (index != 0) {
                currentRefID = String.valueOf(currentRefID) + "/" + elementName;
            }
            this.xsdHelper.putPathXsdPair(GeneralUtil.getPathFromRefID(currentRefID), elementDec);
            arrayList.add(elementDec);
            XSDModelGroup parentModelGroup = this.xsdHelper.getModelGroup(currentParent);
            parentModelGroup.getContents().add((Object)part);
            elementDec.setTargetNamespace(this.xsdSchema.getTargetNamespace());
            if (pliType instanceof PLISimpleType) {
                if (index == dimSize - 1) {
                    this.populateInitial(item, elementDec);
                    XSDSimpleTypeDefinition simpType = this.xsdHelper.getXSDSimpleType((PLISimpleType)pliType, this.xsdSchema);
                    elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)simpType);
                } else {
                    currentParent = this.generateAndRegisterComplexType(elementDec, ctName, groupName);
                }
            } else if (pliType instanceof PLIComposedType) {
                currentParent = this.generateAndRegisterComplexType(elementDec, ctName, groupName);
            }
            if (o instanceof PLIVariableBoundArray) {
                this.createAnnotationForVariableLengthArray(elementDec, ((PLIVariableBoundArray)o).getReferredTo());
            } else if (o instanceof PLIHboundArray) {
                this.createAnnotationForVariableLengthArray(elementDec, ((PLIHboundArray)o).getReferedTo());
            } else if (o instanceof PLIFixedLboundArray) {
                this.createAnnotationForVariableLengthArray(elementDec, ((PLIFixedLboundArray)o).getReferredTo());
            } else if (!(o instanceof PLIFixedBoundArray)) {
                throw new IllegalStateException();
            }
            ++index;
        }
        this.adjustOffset(item.getInstanceTDBase());
        this.xsdTypesTdBasePair.put(topElementDeclaration, item.getInstanceTDBase());
        this.elementSwapMap.put(topElementDeclaration, lastElementDeclaration);
    }

    public void visitPLIVariableBoundArray(PLIElement item, PLIVariableBoundArray array, XSDSchemaContent parent) throws BaseException {
        this.visitArray(item, parent);
    }

    public void acceptItemVisitor(Object item, int depth) throws CoreException {
        if (depth == 1) {
            this.visit(item);
            return;
        }
        if (depth == 2) {
            depth = 1;
        }
        if (item instanceof PLIComposedType) {
            PLIComposedType composedType = (PLIComposedType)item;
            EList elements = composedType.getElements();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.acceptItemVisitor(iter.next(), depth);
            }
        } else if (item instanceof PLIElement) {
            PLIElement element = (PLIElement)item;
            PLIClassifier classifier = element.getSharedType();
            this.acceptItemVisitor(classifier, depth);
        }
    }

    public void setXsdSchema(XSDSchema schema) {
        this.xsdSchema = schema;
    }

    public void setXsdTypeName(String newName) {
        this.topTypeName = newName;
    }

    public void setTopTypePrefix(String prefix) {
        this.topTypePrefix = prefix;
    }

    public XSDTypeDefinition getXSDType() {
        return this.topComplexType;
    }

    public void setGenerateFlat(boolean generateFlat) {
        this.generateFlat = generateFlat;
    }

    public Map getXsdTypesTdBasePair() {
        return this.xsdTypesTdBasePair;
    }

    public void setXsdTypesTdBasePair(Map xsdTypesTdBasePair) {
        this.xsdTypesTdBasePair = xsdTypesTdBasePair;
    }

    private INameConverter getConverter() {
        INameConverter conv = null;
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.ccl.pli2xsd", "nameConverter");
            if (point != null) {
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] ces = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < ces.length) {
                        if (ces[j].getAttribute("id") != "" && ces[j].getAttribute("class") != null) {
                            String convClass = ces[j].getAttribute("class");
                            String enabled = ces[j].getAttribute("enabled");
                            if (enabled.equals("true")) {
                                Class<?> c = Class.forName(convClass);
                                conv = (INameConverter)c.newInstance();
                                return conv;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (conv == null) {
            conv = new PLINameConverter();
        }
        return conv;
    }

    private List createPathVector(String path) {
        ArrayList<String> list = new ArrayList<String>();
        String pathStr = GeneralUtil.getPathFromRefID(path);
        while (pathStr.indexOf("/") > 0) {
            String first = pathStr.substring(0, pathStr.indexOf("/"));
            list.add(first);
            pathStr = pathStr.substring(pathStr.indexOf("/") + 1);
        }
        return list;
    }

    public void setOverwriteTypes(boolean ow) {
        this.overwriteTypes = ow;
    }

    protected Map getPathArrayOfXsdPair() {
        return this.pathArrayOfXsdPair;
    }
}

