/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.wizards;

import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.j2ca.ConnectorProjectDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterListener;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discpub.ui.core.internal.environment.UICoreImportEnvironment;
import com.ibm.j2c.ui.internal.listeners.ResourceAdapterClasspathListener;
import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.threads.ClasspathWaitingThread;
import com.ibm.j2c.ui.internal.wizards.J2CWizardDynamicPage_PropertyGroup;
import com.ibm.j2c.ui.wizards.J2CWizard;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.AdapterConfiguration;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class J2CWizard_AdapterConfigPage
extends J2CWizardDynamicPage_PropertyGroup {
    protected AdapterConfiguration adapterConfig_ = null;
    protected IResourceAdapterDescriptor descriptor_ = null;
    protected URI[] applicationEntries_ = null;
    protected URI[] systemEntries_ = null;
    protected boolean classpathModified_ = false;

    public J2CWizard_AdapterConfigPage(String name, J2CUIMessageBundle newBundle) {
        super(name, newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("J2C_UI_WIZARDS_ADAPTER_CONFIG_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("J2C_UI_WIZARDS_ADAPTER_CONFIG_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_J2C_WIZARD_ADAPTER_CONFIG_PAGE")));
    }

    public void initPage(IResourceAdapterDescriptor descriptor) {
        PropertyGroup emdProperties;
        this.isModified(true);
        this.applicationEntries_ = new URI[0];
        this.systemEntries_ = new URI[0];
        this.descriptor_ = descriptor;
        ConnectorProjectDescriptor projectDescriptor = descriptor.getConnectorProjectDescriptor();
        EMDDescriptor emdDescriptor = (EMDDescriptor)descriptor.getExtendedData().get("EMD_DESCRIPTOR");
        this.adapterConfig_ = emdDescriptor.getAdapterConfiguration();
        if (this.adapterConfig_ == null) {
            return;
        }
        if (projectDescriptor.isConfigured()) {
            this.applicationEntries_ = projectDescriptor.getCopiedClasspathEntries();
            this.systemEntries_ = projectDescriptor.getReferencedClasspathEntries();
            try {
                if (this.applicationEntries_.length > 0) {
                    this.adapterConfig_.setApplicationEntries(this.applicationEntries_);
                }
                if (this.systemEntries_.length > 0) {
                    this.adapterConfig_.setSystemEntries(this.systemEntries_);
                }
            }
            catch (MetadataException exc) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage((Throwable)exc, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), exc.getLocalizedMessage());
                return;
            }
        }
        if ((emdProperties = this.adapterConfig_.createAdapterEnvironmentProperties()) == null) {
            return;
        }
        PropertyGroupWrapper wrapper = null;
        try {
            wrapper = new PropertyGroupWrapper(emdProperties.getName(), emdProperties.getDisplayName(), emdProperties.getDescription(), EMDUtil.getEMDSpecVersion((IResourceAdapterDescriptor)descriptor));
        }
        catch (CoreException exc) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage((Throwable)exc, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException(exc));
            return;
        }
        wrapper.addPropertiesToPropertyGroup(emdProperties);
        this.displayPage((IPropertyGroup)wrapper);
    }

    public AdapterConfiguration getAdapterConfiguration() {
        return this.adapterConfig_;
    }

    public IResourceAdapterDescriptor getResourceAdapterDescriptor() {
        return this.descriptor_;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean performPageFinish() {
        if (this.isModified()) {
            try {
                PropertyGroupWrapper wrapper = (PropertyGroupWrapper)this.getPropertyGroup();
                this.adapterConfig_.applyAdapterEnvironmentProperties(wrapper.getWrappedPropertyGroup());
            }
            catch (MetadataException exc) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage((Throwable)exc, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), exc.getLocalizedMessage());
                return false;
            }
            final ResourceAdapterClasspathListener listener = new ResourceAdapterClasspathListener(this.descriptor_.getConnectorProject());
            try {
                try {
                    final URI[] applicationEntries = this.adapterConfig_.getApplicationEntries() == null ? new URI[]{} : this.adapterConfig_.getApplicationEntries();
                    final URI[] systemEntries = this.adapterConfig_.getSystemEntries() == null ? new URI[]{} : this.adapterConfig_.getSystemEntries();
                    boolean pathsModified = false;
                    if (applicationEntries.length != this.applicationEntries_.length || systemEntries.length != this.systemEntries_.length) {
                        pathsModified = true;
                    }
                    if (!pathsModified) {
                        int i = 0;
                        while (i < applicationEntries.length) {
                            if (!applicationEntries[i].equals(this.applicationEntries_[i])) {
                                pathsModified = true;
                                break;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < systemEntries.length && !pathsModified) {
                            if (!systemEntries[i].equals(this.systemEntries_[i])) {
                                pathsModified = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (pathsModified) {
                        this.saveToStore();
                        RegistryFactory.getFactory().getAPIResourceAdapterRegistry().addResourceAdapterListener((IResourceAdapterListener)listener);
                        final ConnectorProjectDescriptor desc = this.descriptor_.getConnectorProjectDescriptor();
                        this.classpathModified_ = false;
                        WorkspaceJob job = new WorkspaceJob(this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_UPDATE_RA_REGISTRY")){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                boolean copyModified = desc.copyClasspathEntries(applicationEntries);
                                boolean refModified = desc.referenceClasspathEntries(systemEntries);
                                J2CWizard_AdapterConfigPage.this.classpathModified_ = copyModified || refModified;
                                return Status.OK_STATUS;
                            }
                        };
                        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        job.schedule();
                        job.join();
                        if (this.classpathModified_) {
                            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    ClasspathWaitingThread wThread;
                                    monitor.beginTask(J2CWizard_AdapterConfigPage.this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_UPDATE_RA_REGISTRY"), -1);
                                    UICoreImportEnvironment env = ((J2CWizard)J2CWizard_AdapterConfigPage.this.getWizard()).getImportEnvironment();
                                    env.setProgressMonitor(monitor);
                                    ClasspathWaitingThread classpathWaitingThread = wThread = new ClasspathWaitingThread((IEnvironment)env, listener);
                                    synchronized (classpathWaitingThread) {
                                        wThread.start();
                                        while (!wThread.isFinished()) {
                                            ((Object)((Object)wThread)).wait(2000L);
                                            if (!monitor.isCanceled()) continue;
                                            wThread.setCanceled(true);
                                            break;
                                        }
                                    }
                                    monitor.done();
                                    if (wThread.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                    try {
                                        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            });
                            EMDDescriptor emdDescriptor = (EMDDescriptor)this.descriptor_.getExtendedData().get("EMD_DESCRIPTOR");
                            this.adapterConfig_ = emdDescriptor.getAdapterConfiguration();
                            this.adapterConfig_.setApplicationEntries(applicationEntries);
                            this.adapterConfig_.setSystemEntries(systemEntries);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    RegistryFactory.getFactory().getAPIResourceAdapterRegistry().removeResourceAdapterListener((IResourceAdapterListener)listener);
                    return false;
                }
                catch (Exception exc) {
                    DiscUIHelper.getDiscUIHelper().showExceptionMessage((Throwable)exc, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), exc.getLocalizedMessage());
                    RegistryFactory.getFactory().getAPIResourceAdapterRegistry().removeResourceAdapterListener((IResourceAdapterListener)listener);
                    return false;
                }
            }
            finally {
                RegistryFactory.getFactory().getAPIResourceAdapterRegistry().removeResourceAdapterListener((IResourceAdapterListener)listener);
            }
        }
        return true;
    }
}

