/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.j2c.ui.core.internal.utilities.J2CLogUtil;
import com.ibm.j2c.ui.internal.model.CommandBeanInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;

public class J2CCodeParsingUtil {
    private IJavaProject parentJavaProject;
    private CompilationUnit _astCU;
    public Vector meths = new Vector();
    public Vector typesToCopy = new Vector();
    public Vector commmandBeanInfos = new Vector();

    public void initialize(IType interfaceDefinitionBinding) {
        try {
            ICompilationUnit cu = interfaceDefinitionBinding.getCompilationUnit();
            Document doc = new Document(cu.getSource());
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setSource(doc.get().toCharArray());
            this._astCU = (CompilationUnit)parser.createAST(null);
        }
        catch (JavaModelException e) {
            J2CLogUtil.log((String)e.getMessage(), (short)60);
        }
    }

    public void initialize(IType interfaceDefinitionBinding, IJavaProject parent) {
        this.initialize(interfaceDefinitionBinding);
        this.parentJavaProject = parent;
    }

    public void resolveCommandBeanInfos() {
        this._astCU.accept(new ASTVisitor(true){

            public boolean visit(MethodDeclaration methodDecl) {
                String methodName = methodDecl.getName().getFullyQualifiedName();
                boolean isBusinessMethod = J2CCodeParsingUtil.this.isBusinessMethod(methodDecl);
                if (isBusinessMethod) {
                    try {
                        CommandBeanInfo method = new CommandBeanInfo();
                        method.setMethodName(methodName);
                        J2CCodeParsingUtil.this.commmandBeanInfos.add(method);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
        });
    }

    private boolean typeExistsInProject(Type astType, IJavaProject proj) {
        String typeName;
        boolean res;
        block8: {
            res = false;
            typeName = null;
            if (astType.isSimpleType()) {
                typeName = ((SimpleType)astType).getName().getFullyQualifiedName();
            } else if (astType.isQualifiedType()) {
                typeName = ((QualifiedType)astType).getName().getFullyQualifiedName();
            }
            if (typeName != null) break block8;
            return false;
        }
        try {
            if (J2CCodeParsingUtil.getType(typeName, proj) != null) {
                res = true;
                this.typesToCopy.add(typeName);
            } else {
                res = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static IType getType(String typeName, IJavaProject project) {
        IType type = null;
        try {
            type = project.findType(typeName);
        }
        catch (JavaModelException e) {
            J2CLogUtil.log((String)e.getMessage(), (short)60);
        }
        return type;
    }

    public void handleMethodDeclarations() {
        this._astCU.accept(new ASTVisitor(true){

            public boolean visit(MethodDeclaration methodDecl) {
                try {
                    Type returnType = methodDecl.getReturnType2();
                    returnType.resolveBinding();
                    if (!returnType.isPrimitiveType()) {
                        J2CCodeParsingUtil.this.typeExistsInProject(returnType, J2CCodeParsingUtil.this.parentJavaProject);
                    }
                    List params = methodDecl.parameters();
                    int i = 0;
                    while (i < params.size()) {
                        SingleVariableDeclaration svd = (SingleVariableDeclaration)params.get(i);
                        Type paramType = svd.getType();
                        paramType.resolveBinding();
                        if (!paramType.isPrimitiveType()) {
                            J2CCodeParsingUtil.this.typeExistsInProject(paramType, J2CCodeParsingUtil.this.parentJavaProject);
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                return false;
            }
        });
    }

    public void handleSimpleTypes() {
        this._astCU.accept(new ASTVisitor(true){

            public boolean visit(SimpleType typeDecl) {
                try {
                    if (!typeDecl.isPrimitiveType()) {
                        J2CCodeParsingUtil.this.typeExistsInProject((Type)typeDecl, J2CCodeParsingUtil.this.parentJavaProject);
                    }
                }
                catch (Exception exception) {}
                return false;
            }
        });
    }

    public void excludeSuperTypes() {
        this._astCU.accept(new ASTVisitor(true){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean visit(TypeDeclaration typeDecl) {
                try {
                    List lst = typeDecl.superInterfaceTypes();
                    if (lst == null) return false;
                    Iterator iter = lst.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            return false;
                        }
                        Type astType = (Type)iter.next();
                        String typeName = null;
                        if (astType.isSimpleType()) {
                            typeName = ((SimpleType)astType).getName().getFullyQualifiedName();
                        } else if (astType.isQualifiedType()) {
                            typeName = ((QualifiedType)astType).getName().getFullyQualifiedName();
                        }
                        if (typeName == null) {
                            return false;
                        }
                        if (!J2CCodeParsingUtil.this.typesToCopy.contains(typeName)) continue;
                        J2CCodeParsingUtil.this.typesToCopy.remove(typeName);
                    }
                }
                catch (Exception exception) {}
                return false;
            }
        });
    }

    public void handleImportDeclarations() {
        this._astCU.accept(new ASTVisitor(true){

            public boolean visit(ImportDeclaration importDecl) {
                String importName = importDecl.getName().getFullyQualifiedName();
                try {
                    if (J2CCodeParsingUtil.getType(importName, J2CCodeParsingUtil.this.parentJavaProject) != null) {
                        J2CCodeParsingUtil.this.typesToCopy.add(importName);
                    }
                }
                catch (Exception exception) {}
                return false;
            }
        });
    }

    public void handleQualifiedTypes() {
        this._astCU.accept(new ASTVisitor(true){

            public boolean visit(QualifiedType qualifiedTypeDecl) {
                try {
                    if (!qualifiedTypeDecl.isPrimitiveType()) {
                        J2CCodeParsingUtil.this.typeExistsInProject((Type)qualifiedTypeDecl, J2CCodeParsingUtil.this.parentJavaProject);
                    }
                }
                catch (Exception exception) {}
                return false;
            }
        });
    }

    public void lookupAllDependecies() {
        this.handleMethodDeclarations();
        this.handleImportDeclarations();
        this.handleSimpleTypes();
        this.excludeSuperTypes();
    }

    private boolean isBusinessMethod(MethodDeclaration methodDecl) {
        Javadoc javadoc = methodDecl.getJavadoc();
        if (javadoc != null) {
            List tags = javadoc.tags();
            for (TagElement tagElement : tags) {
                String tagName = tagElement.getTagName();
                if (tagName == null || !tagName.equals("@j2c.interactionSpec")) continue;
                return true;
            }
        }
        return false;
    }
}

