/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.utilities.RADUIUtils;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class EJB30Utils {
    public static boolean isEJB30Project(IProject proj) {
        boolean res = false;
        IFacetedProject fProj = null;
        try {
            fProj = ProjectFacetsManager.create((IProject)proj);
        }
        catch (Exception exception) {}
        if (fProj != null) {
            Set st2 = fProj.getProjectFacets();
            for (IProjectFacetVersion pfv : st2) {
                int iVer;
                String sVersionMajor;
                String sVersion;
                int ind;
                String sId = pfv.getProjectFacet().getId();
                if (!sId.equals("jst.ejb") || (ind = (sVersion = pfv.getVersionString()).indexOf(46)) <= 0 || (sVersionMajor = sVersion.substring(0, ind)).length() <= 0 || (iVer = new Integer(sVersionMajor).intValue()) < 3) continue;
                return true;
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEJB30FacetExists(IProject proj, IProject connProject) {
        boolean res = false;
        try {
            boolean b2 = EJB30Utils.doesEjb30ExistForParticularProject(proj);
            if (b2) {
                return true;
            }
            if (ResourceUtils.isTrueJavaProject((IProject)proj)) {
                Vector dependentProjects = RADUIUtils.getConnectorProjectsOnClassPath(proj);
                if (dependentProjects != null && dependentProjects.size() > 0) {
                    IProject pr = (IProject)dependentProjects.get(0);
                    return EJB30Utils.doesEjb30ExistForParticularProject(pr);
                }
                if (connProject == null) return res;
                return EJB30Utils.doesEjb30ExistForParticularProject(connProject);
            }
            org.eclipse.wst.server.core.IRuntime[] runs = ServerCore.getRuntimes();
            int n = 0;
            while (true) {
                if (n >= runs.length) {
                    return res;
                }
                IRuntime rT = FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)runs[n]);
                IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
                IProjectFacetVersion pfv1 = pf.getLatestSupportedVersion(rT);
                boolean is30Ver = EJB30Utils.is30Version(pfv1);
                if (is30Ver) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static boolean doesEjb30ExistForParticularProject(IProject proj) {
        IFacetedProject fProj = null;
        try {
            fProj = ProjectFacetsManager.create((IProject)proj);
        }
        catch (Exception exception) {}
        Set runtimes = null;
        if (fProj != null) {
            runtimes = fProj.getTargetedRuntimes();
        }
        IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        if (runtimes != null && !runtimes.isEmpty()) {
            for (IRuntime rT : runtimes) {
                try {
                    IProjectFacetVersion pfv1 = pf.getLatestSupportedVersion(rT);
                    boolean is30Ver = EJB30Utils.is30Version(pfv1);
                    if (!is30Ver) continue;
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private static boolean is30Version(IProjectFacetVersion pfv) {
        int iVer;
        String sVersionMajor;
        String sVersion = pfv.getVersionString();
        int ind = sVersion.indexOf(46);
        return ind > 0 && (sVersionMajor = sVersion.substring(0, ind)).length() > 0 && (iVer = new Integer(sVersionMajor).intValue()) >= 3;
    }
}

