/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.util;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;

public class TraceWriter {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final int TYPE_TRACE_RECEIVE = 2;
    public static final int TYPE_TRACE_SEND = 1;
    private static final char[] asciiChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final String colPosHeader__ = "       0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF";
    private static final char[] ebcdicChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '|', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '`', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '.', '.', '.', '.', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '.', '.', '.', '.', '.', '.', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '\\', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    private static final char[] hexDigit__ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String receiveHeader__ = "       RECEIVE BUFFER:                     (ASCII)           (EBCDIC)";
    private static final String sendHeader__ = "       SEND BUFFER:                        (ASCII)           (EBCDIC)";
    private static final char spaceChar__ = ' ';
    private static final char zeroChar__ = '0';

    public String traceBuffer(byte[] buff, int offset, int totalBytesToTrace, int type) {
        StringBuffer finalTrace = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        int bytesLeftToTrace = totalBytesToTrace;
        boolean printColPos = true;
        char[] trcDump = new char[77];
        int bCounter = 7;
        int aCounter = 43;
        int eCounter = 61;
        trcDump[0] = 48;
        trcDump[1] = 48;
        trcDump[2] = 48;
        trcDump[3] = 48;
        int lineCounter = 16;
        finalTrace.append(lineSep + "[ibm][ims][tran] " + new String(TraceWriter.getHeader(type).toCharArray()) + lineSep);
        if (printColPos) {
            finalTrace.append("[ibm][ims][tran]        0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF" + lineSep);
            printColPos = false;
        }
        int j = 4;
        while (j < 77) {
            trcDump[j] = 32;
            ++j;
        }
        int i = 0;
        do {
            int num = buff[offset] < 0 ? buff[offset] + 256 : buff[offset];
            ++offset;
            ++i;
            int n = bCounter;
            bCounter = (short)(n + 1);
            trcDump[n] = hexDigit__[num >>> 4 & 0xF];
            int n2 = bCounter;
            bCounter = (short)(n2 + 1);
            trcDump[n2] = hexDigit__[num & 0xF];
            int n3 = aCounter;
            aCounter = (short)(n3 + 1);
            trcDump[n3] = asciiChar__[num];
            int n4 = eCounter;
            eCounter = (short)(n4 + 1);
            trcDump[n4] = ebcdicChar__[num];
            if (i % 8 != 0) continue;
            if (i % 16 == 0) {
                finalTrace.append("[ibm][ims][tran] " + new String(trcDump) + lineSep);
                if (i == bytesLeftToTrace) continue;
                if (bytesLeftToTrace - i < 16) {
                    int j2 = 0;
                    while (j2 < trcDump.length) {
                        trcDump[j2] = 32;
                        ++j2;
                    }
                }
                bCounter = 0;
                aCounter = 43;
                eCounter = 61;
                if (lineCounter == 0x100000) {
                    lineCounter = 0;
                }
                int n5 = bCounter;
                bCounter = (short)(n5 + 1);
                trcDump[n5] = hexDigit__[lineCounter >>> 12 & 0xF];
                int n6 = bCounter;
                bCounter = (short)(n6 + 1);
                trcDump[n6] = hexDigit__[lineCounter >>> 8 & 0xF];
                int n7 = bCounter;
                bCounter = (short)(n7 + 1);
                trcDump[n7] = hexDigit__[lineCounter >>> 4 & 0xF];
                int n8 = bCounter;
                bCounter = (short)(n8 + 1);
                trcDump[n8] = hexDigit__[lineCounter & 0xF];
                bCounter = (short)(bCounter + 3);
                lineCounter += 16;
                continue;
            }
            bCounter = (short)(bCounter + 2);
        } while (i < bytesLeftToTrace);
        bytesLeftToTrace -= i;
        if (i % 16 != 0) {
            finalTrace.append("[ibm][ims][tran] " + new String(trcDump) + lineSep);
        }
        String retVal = finalTrace.toString();
        logger.finest(retVal);
        return retVal;
    }

    private static String getHeader(int type) {
        switch (type) {
            case 1: {
                return sendHeader__;
            }
            case 2: {
                return receiveHeader__;
            }
        }
        return null;
    }

    private static int getStartPosition(int type) {
        switch (type) {
            case 1: {
                return 20;
            }
            case 2: {
                return 23;
            }
        }
        return 0;
    }
}

