/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.tools.messages;

import com.ibm.ims.transaction.tools.messages.MessageBundle;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public enum MessageBundles {

    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2014, 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ResourceBundle bundle;

    private MessageBundles(String baseName) {
        this.bundle = ResourceBundle.getBundle(baseName);
    }

    public String getString(String key) {
        return this.bundle.getString(key);
    }

    public static String getMessage(MessageBundle messageCode) {
        return messageCode.parentBundle().getString(messageCode.toString());
    }

    public static String getMessage(MessageBundle messageCode, Object ... parms) {
        return MessageFormat.format(messageCode.parentBundle().getString(messageCode.toString()), parms);
    }

    public static enum MW implements MessageBundle
    {
        MW0005E,
        MW0006E,
        MW0007E,
        MW0008E,
        MW0009E,
        MW0010E,
        MW0011E,
        MW0012E,
        MW0013E,
        MW0014E,
        MW0015E,
        MW0016E,
        MW0017E;

        private static final String BASE_NAME = "com.ibm.ims.transaction.tools.properties.MWBundle";
        private static final ResourceBundle BUNDLE;

        static {
            BUNDLE = ResourceBundle.getBundle(BASE_NAME, Locale.getDefault(), MessageBundles.class.getClassLoader());
        }

        public static String baseName() {
            return BASE_NAME;
        }

        public static ResourceBundle bundle() {
            return BUNDLE;
        }

        @Override
        public ResourceBundle parentBundle() {
            return BUNDLE;
        }

        @Override
        public String type() {
            return "Message Walker";
        }
    }
}

