/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.ims.dli.DLIErrorMessages;
import com.ibm.ims.dli.conversion.util.MarshallExternalDecimalUtils;
import com.ibm.ims.dli.types.BaseTypeConverter;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;

public class ZonedDecimalConverter2
extends BaseTypeConverter {
    private static final long serialVersionUID = 2349778553046933237L;
    private int scale;
    private int precision;
    private boolean isSigned;
    private boolean isSignLeading;
    private boolean isSignSeparate;
    private int signFormat;
    private int externalDecimalSign;
    private boolean isWCHAROnly;
    private String encoding;
    private String pictureString;
    private int numberDigits;

    public ZonedDecimalConverter2(String pictureString) throws ConversionException {
        this.pictureString = pictureString;
        this.scale = this.determineScale();
        this.precision = this.numberDigits;
        if (pictureString.contains("P") || pictureString.contains("p")) {
            Object[] inserts = new Object[]{"P"};
            throw new ConversionException(DLIErrorMessages.getIMSBundle().getString("INVALID_PICTURE_STRING", inserts));
        }
        if (pictureString.contains(".")) {
            Object[] inserts = new Object[]{"."};
            throw new ConversionException(DLIErrorMessages.getIMSBundle().getString("INVALID_PICTURE_STRING", inserts));
        }
    }

    public ZonedDecimalConverter2(Integer scale, Integer precision, boolean isSigned) {
        this(scale, precision, isSigned, false, false, false);
    }

    public ZonedDecimalConverter2(Integer scale, Integer precision, boolean isSigned, boolean isSignLeading, boolean isSignSeparate, boolean isWCHAROnly) {
        this.scale = scale == null ? 0 : scale;
        this.precision = precision == null ? 0 : precision;
        this.numberDigits = this.precision;
        this.isSigned = isSigned;
        this.isSignLeading = isSignLeading;
        this.isSignSeparate = isSignSeparate;
        this.signFormat = isSignLeading && isSignSeparate ? 2 : (isSignLeading && !isSignSeparate ? 0 : (isSignSeparate ? 3 : 1));
        if (!isWCHAROnly) {
            this.encoding = "Cp1047";
            this.externalDecimalSign = 0;
        } else {
            this.encoding = "UTF-16BE";
            this.externalDecimalSign = 3;
        }
    }

    public boolean isWCHAROnly() {
        return this.isWCHAROnly;
    }

    public int getSignFormat() {
        return this.signFormat;
    }

    public void setSignFormat(int signFormat) {
        this.signFormat = signFormat;
    }

    public int getExternalDecimalSign() {
        return this.externalDecimalSign;
    }

    public void setExternalDecimalSign(int externalDecimalSign) {
        this.externalDecimalSign = externalDecimalSign;
    }

    public Object readObject(byte[] ioArea, int start, int length, Class objectType, Collection<String> warningMessages) throws UnsupportedTypeConversion, IOException, ConversionException {
        if (objectType == BigDecimal.class) {
            return this.zonedDecimalBytesToBigDecimal(ioArea, start, length, this.precision, this.scale);
        }
        if (objectType == BigInteger.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            return BigInteger.valueOf(value.longValue());
        }
        if (objectType == Byte.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            if (warningMessages != null) {
                Object[] inserts = new Object[]{"ZONEDDECIMAL", "java.lang.Byte"};
                warningMessages.add(DLIErrorMessages.getIMSBundle().getString("DATA_TRUNCATION_WARNING_READ", inserts));
            }
            return value.byteValue();
        }
        if (objectType == Short.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            if (warningMessages != null) {
                Object[] inserts = new Object[]{"ZONEDDECIMAL", "java.lang.Short"};
                warningMessages.add(DLIErrorMessages.getIMSBundle().getString("DATA_TRUNCATION_WARNING_READ", inserts));
            }
            return value.shortValue();
        }
        if (objectType == Integer.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            if (warningMessages != null) {
                Object[] inserts = new Object[]{"ZONEDDECIMAL", "java.lang.Integer"};
                warningMessages.add(DLIErrorMessages.getIMSBundle().getString("DATA_TRUNCATION_WARNING_READ", inserts));
            }
            return value.intValue();
        }
        if (objectType == Long.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            if (warningMessages != null) {
                Object[] inserts = new Object[]{"ZONEDDECIMAL", "java.lang.Long"};
                warningMessages.add(DLIErrorMessages.getIMSBundle().getString("DATA_TRUNCATION_WARNING_READ", inserts));
            }
            return value.longValue();
        }
        if (objectType == Float.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            return Float.valueOf(value.floatValue());
        }
        if (objectType == Double.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            return value.doubleValue();
        }
        if (objectType == Boolean.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            return value.intValue() != 0;
        }
        if (objectType == String.class) {
            BigDecimal value = (BigDecimal)this.readObject(ioArea, start, length, BigDecimal.class, warningMessages);
            return new String(value.toString());
        }
        Object[] inserts = new Object[]{"ZonedDecimal", objectType};
        throw new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
    }

    public BigDecimal zonedDecimalBytesToBigDecimal(byte[] buffer, int offset, int length, int precision, int scale) throws ConversionException {
        BigDecimal result = null;
        try {
            result = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer((byte[])buffer, (int)offset, (int)length, (boolean)this.isSigned, (int)scale, (int)this.signFormat, (int)this.externalDecimalSign, (String)this.encoding);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(e.getMessage());
        }
        return result;
    }

    private void validateZonedDecimal(byte[] ioArea, int length, Object object) throws ConversionException {
        int decimalIndex;
        BigDecimal value;
        int sign;
        if (ioArea == null) {
            ioArea = new byte[length];
        }
        if ((sign = (value = (BigDecimal)object).signum()) == -1 && !this.isSigned) {
            Object[] inserts = new Object[]{value.toString(), this.pictureString};
            throw new ConversionException(DLIErrorMessages.getIMSBundle().getString("NEGATIVE_NUMBER_NOT_ALLOWED", inserts));
        }
        value = value.setScale(this.scale, RoundingMode.DOWN);
        if (sign == -1) {
            value = value.negate();
        }
        Object number = value.toString();
        int numberLength = ((String)number).length();
        if (this.scale == this.precision && ((String)number).startsWith("0.")) {
            number = ((String)number).substring(1);
            --numberLength;
        }
        if ((decimalIndex = ((String)number).indexOf(46)) != -1) {
            number = ((String)number).substring(0, decimalIndex) + ((String)number).substring(decimalIndex + 1);
            --numberLength;
        }
        if (numberLength > this.numberDigits) {
            if (this.pictureString == null) {
                this.pictureString = this.getZonedDecimalFormat();
            }
            Object[] inserts = new Object[]{this.pictureString, value.toString()};
            throw new ConversionException(DLIErrorMessages.getIMSBundle().getString("BIG_DECIMAL_WRITE_OVERFLOW", inserts));
        }
    }

    public void writeObject(byte[] buffer, int start, int length, Object object, Collection<String> warningMessages) throws UnsupportedTypeConversion, IOException, ConversionException {
        if (object instanceof BigDecimal) {
            this.validateZonedDecimal(buffer, length, object);
            try {
                MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer((BigDecimal)((BigDecimal)object), (byte[])buffer, (int)start, (int)length, (boolean)this.isSigned, (int)this.scale, (int)this.signFormat, (int)this.externalDecimalSign, (String)this.encoding);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException(e.getMessage());
            }
        } else if (object instanceof BigInteger) {
            BigInteger value = (BigInteger)object;
            this.writeObject(buffer, start, length, new BigDecimal(value.intValue()), warningMessages);
        } else if (object instanceof Byte) {
            Byte value = (Byte)object;
            this.writeObject(buffer, start, length, new BigDecimal(value.byteValue()), warningMessages);
        } else if (object instanceof Short) {
            Short value = (Short)object;
            this.writeObject(buffer, start, length, new BigDecimal(value.shortValue()), warningMessages);
        } else if (object instanceof Integer) {
            Integer value = (Integer)object;
            this.writeObject(buffer, start, length, new BigDecimal(value), warningMessages);
        } else if (object instanceof Long) {
            Long value = (Long)object;
            this.writeObject(buffer, start, length, new BigDecimal(value), warningMessages);
        } else if (object instanceof Float) {
            Float value = (Float)object;
            this.writeObject(buffer, start, length, new BigDecimal(value.floatValue()), warningMessages);
        } else if (object instanceof Double) {
            Double value = (Double)object;
            this.writeObject(buffer, start, length, new BigDecimal(value), warningMessages);
        } else if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            this.writeObject(buffer, start, length, new BigDecimal(value != false ? 1 : 0), warningMessages);
        } else if (object instanceof String) {
            String value = (String)object;
            this.writeObject(buffer, start, length, new BigDecimal(value), warningMessages);
        } else {
            Object[] inserts = new Object[]{object.getClass(), "ZonedDecimal"};
            throw new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
        }
    }

    public boolean isNull(byte[] ioArea, int offset) {
        return false;
    }

    public void setNull(byte[] ioArea, int offset) throws IOException {
        Object[] inserts = new Object[]{((Object)((Object)this)).getClass().toString()};
        throw new IOException(DLIErrorMessages.getIMSBundle().getString("CONVERTER_NULL_NOT_SUPPORTED", inserts));
    }

    private int determineScale() {
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(this.pictureString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
            return scale;
        }
        return scale;
    }

    private String expandStringAndGetNumDigits(String pictureString) {
        StringBuffer expandedString = new StringBuffer();
        int startingIndex = -1;
        int index = 0;
        int expandCount = 0;
        char expandChar = '\u0000';
        if (pictureString.startsWith("S") || pictureString.startsWith("s")) {
            pictureString = pictureString.substring(1);
            this.isSigned = true;
        } else {
            this.isSigned = false;
        }
        while ((index = pictureString.indexOf(40, startingIndex)) != -1) {
            expandedString.append(pictureString.substring(startingIndex + 1, index));
            startingIndex = pictureString.indexOf(41, index);
            expandChar = pictureString.charAt(index - 1);
            expandCount = Integer.parseInt(pictureString.substring(index + 1, startingIndex));
            int i = 0;
            while (i < expandCount - 1) {
                expandedString.append(expandChar);
                ++i;
            }
        }
        expandedString.append(pictureString.substring(startingIndex + 1, pictureString.length()));
        int count = 0;
        int length = expandedString.length();
        int i = 0;
        while (i < length) {
            if (String.valueOf(expandedString.charAt(i)).equals("9")) {
                ++count;
            }
            ++i;
        }
        this.numberDigits = count;
        return expandedString.toString();
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isSignLeading() {
        return this.isSignLeading;
    }

    public boolean isSignSeparate() {
        return this.isSignSeparate;
    }

    private String getZonedDecimalFormat() {
        String format = "scale(" + this.scale + "), precision(" + this.precision + "), signed(" + (this.isSigned ? "true" : "false") + "), isSignLeading(" + (this.isSignLeading ? "true" : "false") + "), isSignSeparate(" + (this.isSignSeparate ? "true" : "false") + "), isWCHAROnly(" + (this.isWCHAROnly ? "true" : "false") + ")";
        return format;
    }
}

