/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.ims.dli.DLIErrorMessages;
import com.ibm.ims.dli.conversion.util.MarshallResource;
import com.ibm.ims.dli.conversion.util.MarshallStringUtils;
import com.ibm.ims.dli.types.BaseTypeConverter;
import com.ibm.ims.dli.types.ComplexDateFormat;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class StringConverter2
extends BaseTypeConverter {
    private static final long serialVersionUID = -320964277424589701L;
    protected String encoding;
    private boolean DBCSOnly = false;
    private boolean unicode = false;
    protected String typeQualifier;

    public StringConverter2() {
        this.encoding = Charset.defaultCharset().name();
        this.typeQualifier = null;
    }

    public StringConverter2(String encoding) {
        String encodingSubstr;
        this.encoding = encoding;
        this.typeQualifier = null;
        if (encoding.length() >= 5 && (encodingSubstr = encoding.substring(0, 4)).equalsIgnoreCase("UTF-")) {
            this.unicode = true;
        }
    }

    public StringConverter2(String encoding, String typeQualifier) {
        String encodingSubstr;
        this.encoding = encoding;
        this.typeQualifier = typeQualifier;
        if (encoding.length() >= 5 && (encodingSubstr = encoding.substring(0, 4)).equalsIgnoreCase("UTF-")) {
            this.unicode = true;
        }
    }

    public static String unmarshallFixedLengthStringFromBuffer(byte[] buffer, int startingOffset, String codePage, int size) throws IllegalArgumentException {
        if (buffer[startingOffset] == 0) {
            return "";
        }
        String result = null;
        try {
            result = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", codePage));
        }
        return result;
    }

    public Object readObject(byte[] ioArea, int start, int length, Class objectType, Collection<String> warningStrings) throws UnsupportedTypeConversion, IOException {
        if (objectType == String.class) {
            if (this.encoding == null) {
                return new String(ioArea, start, length);
            }
            try {
                if (this.unicode) {
                    return MarshallStringUtils.unmarshallFixedLengthUnicodeDBCSStringFromBuffer((byte[])ioArea, (int)start, (String)this.encoding, (int)length, (boolean)false);
                }
                if (this.DBCSOnly) {
                    return MarshallStringUtils.unmarshallFixedLengthDBCSStringFromBuffer((byte[])ioArea, (int)start, (String)this.encoding, (int)length, (boolean)true);
                }
                String result = null;
                try {
                    result = new String(ioArea, start, length, this.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", this.encoding));
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                UnsupportedTypeConversion newE = new UnsupportedTypeConversion(e.getMessage());
                newE.initCause((Throwable)e);
                throw newE;
            }
        }
        if (objectType == Byte.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return Byte.parseByte(value, 10);
        }
        if (objectType == Short.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return Short.parseShort(value, 10);
        }
        if (objectType == Integer.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return Integer.parseInt(value.trim(), 10);
        }
        if (objectType == Long.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return Long.parseLong(value, 10);
        }
        if (objectType == Float.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return Float.valueOf(Float.valueOf(value).floatValue());
        }
        if (objectType == Double.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return (double)Double.valueOf(value);
        }
        if (objectType == Boolean.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return value.equalsIgnoreCase("true");
        }
        if (objectType == BigDecimal.class) {
            String value = (String)this.readObject(ioArea, start, length, String.class, warningStrings);
            return new BigDecimal(value);
        }
        if (objectType == Date.class) {
            Date result = null;
            SimpleDateFormat sdf = new SimpleDateFormat();
            String dateString = null;
            dateString = this.encoding == null ? new String(ioArea, start, length) : new String(ioArea, start, length, this.encoding);
            if (this.typeQualifier != null) {
                sdf.applyPattern(this.typeQualifier);
            }
            try {
                result = new Date(sdf.parse(dateString).getTime());
            }
            catch (ParseException e) {
                Object[] inserts = new Object[]{e.getMessage()};
                UnsupportedTypeConversion newException = new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
                newException.initCause((Throwable)e);
                throw newException;
            }
            return result;
        }
        if (objectType == Time.class) {
            Time result = null;
            SimpleDateFormat sdf = new SimpleDateFormat();
            byte[] data = new byte[length];
            System.arraycopy(ioArea, start, data, 0, length);
            String timeString = null;
            timeString = this.encoding == null ? new String(ioArea, start, length) : new String(ioArea, start, length, this.encoding);
            if (this.typeQualifier != null) {
                sdf.applyPattern(this.typeQualifier);
            }
            try {
                result = new Time(sdf.parse(timeString).getTime());
            }
            catch (ParseException e) {
                Object[] inserts = new Object[]{e.getMessage()};
                UnsupportedTypeConversion newException = new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
                newException.initCause((Throwable)e);
                throw newException;
            }
            return result;
        }
        if (objectType == Timestamp.class) {
            Timestamp result = null;
            ComplexDateFormat cdf = new ComplexDateFormat();
            String timestampString = null;
            timestampString = this.encoding == null ? new String(ioArea, start, length) : new String(ioArea, start, length, this.encoding);
            if (this.typeQualifier != null) {
                cdf.applyPattern(this.typeQualifier);
            }
            try {
                result = (Timestamp)cdf.parse(timestampString);
            }
            catch (ParseException e) {
                Object[] inserts = new Object[]{e.getMessage()};
                UnsupportedTypeConversion newException = new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
                newException.initCause((Throwable)e);
                throw newException;
            }
            return result;
        }
        Object[] inserts = new Object[]{String.class, objectType};
        throw new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
    }

    public void writeObject(byte[] ioArea, int start, int length, Object object, Collection<String> warningStrings) throws UnsupportedTypeConversion, IOException {
        if (object instanceof String) {
            try {
                if (this.unicode) {
                    MarshallStringUtils.marshallFixedLengthUnicodeDBCSStringIntoBuffer((String)((String)object), (byte[])ioArea, (int)start, (String)this.encoding, (int)0, (int)length, (int)0, (String)" ", (boolean)false);
                }
                if (this.DBCSOnly) {
                    MarshallStringUtils.marshallFixedLengthDBCSStringIntoBuffer((String)((String)object), (byte[])ioArea, (int)start, (String)this.encoding, (int)0, (int)length, (int)0, (String)" ", (boolean)true);
                }
                MarshallStringUtils.marshallFixedLengthStringIntoBuffer((String)((String)object), (byte[])ioArea, (int)start, (String)this.encoding, (int)length, (int)0, (String)" ");
            }
            catch (IllegalArgumentException e) {
                UnsupportedTypeConversion newE = new UnsupportedTypeConversion(e.getMessage());
                newE.initCause((Throwable)e);
                throw newE;
            }
        } else if (object instanceof Byte) {
            Byte value = (Byte)object;
            this.writeObject(ioArea, start, length, String.valueOf(value.byteValue()), warningStrings);
        } else if (object instanceof Short) {
            Short value = (Short)object;
            this.writeObject(ioArea, start, length, String.valueOf(value.shortValue()), warningStrings);
        } else if (object instanceof Integer) {
            Integer value = (Integer)object;
            this.writeObject(ioArea, start, length, String.valueOf(value), warningStrings);
        } else if (object instanceof Long) {
            Long value = (Long)object;
            this.writeObject(ioArea, start, length, String.valueOf(value), warningStrings);
        } else if (object instanceof Float) {
            Float value = (Float)object;
            this.writeObject(ioArea, start, length, String.valueOf(value.floatValue()), warningStrings);
        } else if (object instanceof Double) {
            Double value = (Double)object;
            this.writeObject(ioArea, start, length, String.valueOf(value), warningStrings);
        } else if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            if (value.booleanValue()) {
                this.writeObject(ioArea, start, length, "1", warningStrings);
            } else {
                this.writeObject(ioArea, start, length, "0", warningStrings);
            }
        } else if (object instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)object;
            this.writeObject(ioArea, start, length, value.toString(), warningStrings);
        } else if (object instanceof Date) {
            Date value = (Date)object;
            this.writeObject(ioArea, start, length, value.toString(), warningStrings);
        } else if (object instanceof Time) {
            Time value = (Time)object;
            this.writeObject(ioArea, start, length, value.toString(), warningStrings);
        } else if (object instanceof Timestamp) {
            Timestamp value = (Timestamp)object;
            this.writeObject(ioArea, start, length, value.toString(), warningStrings);
        } else {
            Object[] inserts = new Object[]{object.getClass(), String.class};
            throw new UnsupportedTypeConversion(DLIErrorMessages.getIMSBundle().getString("CONVERTER_INVALID_TYPE", inserts));
        }
    }

    public boolean isNull(byte[] ioArea, int offset) {
        return ioArea[offset] != 0;
    }

    public void setNull(byte[] ioArea, int offset) throws IOException {
        ioArea[offset] = 0;
    }

    public void setDBCSOnly(boolean only) {
        this.DBCSOnly = only;
    }

    public boolean isDBCSOnly() {
        return this.DBCSOnly;
    }
}

