/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.message.overlay.InterfaceFieldType;
import com.ibm.im.ims.metadata.message.overlay.MessageInterfaceType;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.tools.messages.MessageBundles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class ModelToJSONVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap<String, Object> rootCompositeNode;
    private HashMap<String, Object> currCompositeNode;
    private Stack<HashMap<String, Object>> compositeNodeStack;
    private Stack<FieldType> prevFieldStack;
    private InterfaceFieldType currParentInterfaceField;
    private Stack<InterfaceFieldType> parentInterfaceFieldStack;
    private Stack<Integer> interfaceFieldIxStack = new Stack();
    private MessageInterfaceType msgInterface;
    private ServiceInterfaceSegmentType currInterfaceSegment;
    private int segmentIx = -1;

    public ModelToJSONVisitor(MessageInterfaceType msgInterface) {
        this.compositeNodeStack = new Stack();
        this.prevFieldStack = new Stack();
        this.parentInterfaceFieldStack = new Stack();
        this.msgInterface = msgInterface;
    }

    @Override
    public boolean isExpandArrays() {
        return true;
    }

    @Override
    public Object startOfMessageType(MessageType message, Object state) {
        this.rootCompositeNode = new HashMap();
        this.currCompositeNode = this.rootCompositeNode;
        this.compositeNodeStack.clear();
        this.interfaceFieldIxStack.clear();
        return state;
    }

    @Override
    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        ++this.segmentIx;
        this.currInterfaceSegment = this.msgInterface.getSegment().get(this.segmentIx);
        this.interfaceFieldIxStack.push(-1);
        this.prevFieldStack.push(null);
        return state;
    }

    @Override
    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        if (this.parentInterfaceFieldStack.size() == 0) {
            interfaceFields = this.currInterfaceSegment.getInterfaceField();
            if (interfaceFields.size() - 1 < fieldIx) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0015E)).messageCode(MessageBundles.MW.MW0015E).build();
                throw walkerException;
            }
            currInterfaceField = interfaceFields.get(fieldIx);
        } else {
            interfaceFields = this.currParentInterfaceField.getField();
            if (interfaceFields.size() - 1 < fieldIx) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0015E)).messageCode(MessageBundles.MW.MW0015E).build();
                throw walkerException;
            }
            currInterfaceField = interfaceFields.get(fieldIx);
        }
        String defaultValue = currInterfaceField.getDefaultValue();
        if (field.getApplicationDatatype().getDatatype() == DatatypeType.CHAR || ModelToJSONVisitor.isTrue(field.isDependedOn()).booleanValue() || defaultValue != null && !defaultValue.isEmpty()) {
            if (defaultValue != null) {
                this.currCompositeNode.put(field.getName(), defaultValue);
            } else {
                this.currCompositeNode.put(field.getName(), "");
            }
        }
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        return state;
    }

    public HashMap<String, Object> getMap() {
        return this.rootCompositeNode;
    }

    @Override
    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        ArrayList leafArrayList = new ArrayList();
        int maxOccurs = fieldParents.peek().getMaxOccurs();
        int index = 0;
        while (index < maxOccurs) {
            ++index;
        }
        this.currCompositeNode.put(fieldPath.peek(), leafArrayList);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        return state;
    }

    @Override
    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currField = null;
        if (this.parentInterfaceFieldStack.size() == 0) {
            interfaceFields = this.currInterfaceSegment.getInterfaceField();
            if (interfaceFields.size() - 1 < fieldIx) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0015E)).messageCode(MessageBundles.MW.MW0015E).build();
                throw walkerException;
            }
            currField = interfaceFields.get(fieldIx);
        } else {
            interfaceFields = this.currParentInterfaceField.getField();
            if (interfaceFields.size() - 1 < fieldIx) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0015E)).messageCode(MessageBundles.MW.MW0015E).build();
                throw walkerException;
            }
            currField = interfaceFields.get(fieldIx);
        }
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        HashMap composite = new HashMap();
        this.currCompositeNode.put(field.getName(), composite);
        this.currCompositeNode = composite;
        this.compositeNodeStack.push(this.currCompositeNode);
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        this.prevFieldStack.push(null);
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        List composite = null;
        if (index == 0) {
            composite = new ArrayList();
            this.currCompositeNode.put(field.getName(), composite);
        } else {
            composite = (List)this.currCompositeNode.get(field.getName());
        }
        composite.add(index, new HashMap());
        this.currCompositeNode = (HashMap)composite.get(index);
        this.compositeNodeStack.push(this.currCompositeNode);
        int compositeFieldStackPos = this.compositeNodeStack.size() - 1;
        FieldType prevField = (FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        if (prevField != field) {
            fieldIx = fieldIx + 1;
            this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        }
        InterfaceFieldType currField = null;
        if (this.parentInterfaceFieldStack.size() == 0) {
            List<InterfaceFieldType> interfaceFields = this.currInterfaceSegment.getInterfaceField();
            if (interfaceFields.size() - 1 < fieldIx) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0015E)).messageCode(MessageBundles.MW.MW0015E).build();
                throw walkerException;
            }
            currField = interfaceFields.get(fieldIx);
        } else {
            List<InterfaceFieldType> interfaceFields = this.currParentInterfaceField.getField();
            if (interfaceFields.size() - 1 < fieldIx) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0015E)).messageCode(MessageBundles.MW.MW0015E).build();
                throw walkerException;
            }
            currField = interfaceFields.get(fieldIx);
        }
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        this.prevFieldStack.push(null);
        return state;
    }

    @Override
    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        this.prevFieldStack.pop();
        this.compositeNodeStack.pop();
        this.currCompositeNode = !this.compositeNodeStack.isEmpty() ? this.compositeNodeStack.peek() : this.rootCompositeNode;
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        this.prevFieldStack.pop();
        this.compositeNodeStack.pop();
        this.currCompositeNode = !this.compositeNodeStack.isEmpty() ? this.compositeNodeStack.peek() : this.rootCompositeNode;
        return state;
    }

    @Override
    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.interfaceFieldIxStack.pop();
        this.prevFieldStack.pop();
        return state;
    }

    @Override
    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.currParentInterfaceField = null;
        this.currCompositeNode = this.rootCompositeNode;
        return state;
    }

    public HashMap<String, Object> getRootNode() {
        return this.rootCompositeNode;
    }

    @Override
    public int getVariableArrayOccurrenceCount(FieldType dynArrayField) {
        HashMap<String, Object> dependingOnComposite;
        Object numArrayElementsObj;
        int retVal = -1;
        String dependingOnFieldName = dynArrayField.getDependsOn();
        if (dependingOnFieldName != null && !dependingOnFieldName.isEmpty() && (numArrayElementsObj = (dependingOnComposite = super.getDependingOnComposite(dependingOnFieldName, this.compositeNodeStack)).get(dependingOnFieldName)) instanceof String) {
            try {
                retVal = Integer.parseInt((String)numArrayElementsObj);
            }
            catch (NumberFormatException numberFormatException) {
                retVal = 3;
                dependingOnComposite.put(dependingOnFieldName, "3");
            }
        }
        return retVal;
    }
}

