/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.ims.transaction.tools.messages.MessageBundle;
import java.text.MessageFormat;
import org.osgi.framework.Bundle;

public class MessageWalkerException
extends Exception {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -5305246800577477124L;
    private static final String COLON = ": ";
    private Bundle bundle;
    private MessageBundle messageCode;
    private String message;
    private Object[] args;
    private Throwable cause;

    public MessageWalkerException() {
    }

    public MessageWalkerException(String message) {
        super(message);
    }

    public MessageWalkerException(Throwable cause) {
        super(cause);
    }

    public MessageWalkerException(String message, Throwable cause) {
        super(message, cause);
    }

    public MessageWalkerException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public MessageWalkerException(Builder builder) {
        this.bundle = builder.bundle;
        this.message = builder.message;
        this.messageCode = builder.messageCode;
        this.args = builder.args;
        if (this.message != null && this.args != null) {
            this.message = MessageFormat.format(String.valueOf(this.messageCode) + COLON + this.message, this.args);
        }
        this.cause = builder.cause;
        if (this.cause != null) {
            this.setStackTrace(this.cause.getStackTrace());
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public MessageBundle getMessageCode() {
        return this.messageCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Bundle bundle;
        private String message;
        private MessageBundle messageCode;
        private Object[] args;
        private Throwable cause;

        Builder() {
        }

        public Builder bundle(Bundle bundle) {
            this.bundle = bundle;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageCode(MessageBundle messageCode) {
            this.messageCode = messageCode;
            return this;
        }

        public Builder args(Object ... args) {
            this.args = args;
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public MessageWalkerException build() {
            return new MessageWalkerException(this);
        }
    }
}

