/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.IMessageVisitor;
import com.ibm.ims.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.util.List;
import java.util.Stack;

public class MessageWalker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    MessageType message;

    public void accept(IMessageVisitor visitor, MessageType message) throws MessageWalkerException {
        this.accept(visitor, message, null);
    }

    public Object accept(IMessageVisitor visitor, MessageType message, Object state) throws MessageWalkerException {
        this.message = message;
        Stack<FieldType> fieldParents = new Stack<FieldType>();
        FieldPath fieldPath = new FieldPath();
        state = this.walkMessageType(message, visitor, fieldPath, fieldParents, state);
        this.message = null;
        return state;
    }

    public void accept(IMessageVisitor visitor, SegmentType segment) throws MessageWalkerException {
        this.accept(visitor, segment, null);
    }

    public Object accept(IMessageVisitor visitor, SegmentType segment, Object state) throws MessageWalkerException {
        Stack<FieldType> fieldParents = new Stack<FieldType>();
        FieldPath fieldPath = new FieldPath();
        state = this.walkSegmentType(segment, visitor, fieldPath, fieldParents, state);
        return state;
    }

    public void accept(IMessageVisitor visitor, FieldType field) throws MessageWalkerException {
        this.accept(visitor, field, null);
    }

    public Object accept(IMessageVisitor visitor, FieldType field, Object state) throws MessageWalkerException {
        Stack<FieldType> fieldParents = new Stack<FieldType>();
        FieldPath fieldPath = new FieldPath();
        state = this.walkField(field, visitor, fieldPath, fieldParents, state);
        state = this.emptyFieldParentStack(visitor, fieldPath, fieldParents, state);
        return state;
    }

    private Object walkMessageType(MessageType message, IMessageVisitor visitor, FieldPath fieldPath, Stack<FieldType> fieldParents, Object state) throws MessageWalkerException {
        state = visitor.startOfMessageType(message, state);
        for (SegmentType segment : message.getSegment()) {
            state = visitor.startOfSegmentType(segment, state);
            state = this.walkSegmentType(segment, visitor, fieldPath, fieldParents, state);
            state = visitor.endOfSegmentType(segment, state);
        }
        state = visitor.endOfMessageType(message, state);
        return state;
    }

    private Object walkSegmentType(SegmentType segment, IMessageVisitor visitor, FieldPath fieldPath, Stack<FieldType> fieldParents, Object state) throws MessageWalkerException {
        for (FieldType field : segment.getField()) {
            state = this.walkField(field, visitor, fieldPath, fieldParents, state);
            state = this.emptyFieldParentStack(visitor, fieldPath, fieldParents, state);
        }
        return state;
    }

    private Object walkField(FieldType field, IMessageVisitor visitor, FieldPath fieldPath, Stack<FieldType> fieldParents, Object state) throws MessageWalkerException {
        while (!fieldParents.isEmpty() && !MessageWalker.isContainedBy(fieldParents.peek().getField(), field)) {
            FieldType parent = fieldParents.pop();
            state = MessageWalker.isArray(parent) ? visitor.endOfCompositeArrayField(parent, fieldPath, -1, fieldParents, MessageWalker.isRedefiningField(parent), state) : visitor.endOfCompositeField(parent, fieldPath, fieldParents, MessageWalker.isRedefiningField(parent), state);
            fieldPath.pop();
        }
        int upperbound = 1;
        if (MessageWalker.isFixedLengthArrayField(field)) {
            upperbound = field.getMaxOccurs();
        } else if (MessageWalker.isVariableLengthArray(field)) {
            upperbound = visitor instanceof JSONConversionVisitor ? ((JSONConversionVisitor)visitor).getVariableArrayOccurrenceCount(field) : field.getMaxOccurs().intValue();
        }
        if (MessageWalker.isCompositeField(field)) {
            if (MessageWalker.isArray(field)) {
                if (visitor.isExpandArrays()) {
                    if (upperbound == 0 && visitor instanceof JSONConversionVisitor) {
                        ((JSONConversionVisitor)visitor).validateFieldCanHaveZeroElements(field, fieldPath);
                    } else {
                        int i = 0;
                        while (i < upperbound) {
                            fieldPath.push(field.getName());
                            state = visitor.startOfCompositeArrayField(field, fieldPath, i, fieldParents, MessageWalker.isRedefiningField(field), state);
                            fieldParents.push(field);
                            for (FieldType cField : field.getField()) {
                                state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                            }
                            fieldParents.pop();
                            state = visitor.endOfCompositeArrayField(field, fieldPath, i, fieldParents, MessageWalker.isRedefiningField(field), state);
                            fieldPath.pop();
                            ++i;
                        }
                    }
                } else {
                    fieldPath.push(field.getName());
                    state = visitor.startOfCompositeArrayField(field, fieldPath, -1, fieldParents, MessageWalker.isRedefiningField(field), state);
                    fieldParents.push(field);
                    for (FieldType cField : field.getField()) {
                        state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                    }
                    fieldParents.pop();
                    state = visitor.endOfCompositeArrayField(field, fieldPath, -1, fieldParents, MessageWalker.isRedefiningField(field), state);
                    fieldPath.pop();
                }
            } else {
                fieldPath.push(field.getName());
                state = visitor.startOfCompositeField(field, fieldPath, fieldParents, MessageWalker.isRedefiningField(field), state);
                fieldParents.push(field);
                for (FieldType cField : field.getField()) {
                    state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                }
                fieldParents.pop();
                state = visitor.endOfCompositeField(field, fieldPath, fieldParents, MessageWalker.isRedefiningField(field), state);
                fieldPath.pop();
            }
        } else {
            fieldPath.push(field.getName());
            if (MessageWalker.isArray(field)) {
                fieldParents.push(field);
                FieldType nestedField = field.getField().get(0);
                state = visitor.leafArrayField(nestedField, fieldPath, fieldParents, MessageWalker.isRedefiningField(field), state);
                fieldParents.pop();
            } else {
                state = visitor.leafField(field, fieldPath, fieldParents, MessageWalker.isRedefiningField(field), state);
            }
            fieldPath.pop();
        }
        return state;
    }

    private Object emptyFieldParentStack(IMessageVisitor visitor, FieldPath fieldPath, Stack<FieldType> fieldParents, Object state) throws MessageWalkerException {
        while (!fieldParents.isEmpty()) {
            FieldType parent = fieldParents.pop();
            fieldPath.pop();
            state = MessageWalker.isArray(parent) ? visitor.endOfCompositeArrayField(parent, fieldPath, -1, fieldParents, MessageWalker.isRedefiningField(parent), state) : visitor.endOfCompositeField(parent, fieldPath, fieldParents, MessageWalker.isRedefiningField(parent), state);
        }
        return state;
    }

    public static boolean isArray(FieldType field) {
        if (MessageWalker.isFixedLengthArrayField(field)) {
            return true;
        }
        return MessageWalker.isVariableLengthArray(field);
    }

    public static boolean isCompositeField(FieldType field) {
        return !MessageWalker.isLeafArrayField(field) && !field.getField().isEmpty();
    }

    public static boolean isLeafArrayField(FieldType field) {
        return field.getApplicationDatatype().getDatatype() == DatatypeType.ARRAY && field.getField().size() == 1 && field.getField().get(0).getName().endsWith("_SUB");
    }

    public static boolean isFixedLengthArrayField(FieldType field) {
        return field.getApplicationDatatype().getDatatype() == DatatypeType.ARRAY && field.getMinOccurs().intValue() == field.getMaxOccurs().intValue();
    }

    public static boolean isVariableLengthArray(FieldType field) {
        return field.getApplicationDatatype().getDatatype() == DatatypeType.ARRAY && field.getMaxOccurs() > 1 && field.getMinOccurs().intValue() != field.getMaxOccurs().intValue();
    }

    public static boolean isRedefiningField(FieldType field) {
        String redefiningField = field.getRedefines();
        return redefiningField != null && !redefiningField.isEmpty();
    }

    public static boolean isContainedBy(List<FieldType> fieldList, FieldType field) {
        boolean retVal = false;
        int i = 0;
        while (i < fieldList.size() && !retVal) {
            if (fieldList.get(i) == field) {
                retVal = true;
            }
            ++i;
        }
        return retVal;
    }
}

