/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.message.overlay.InterfaceFieldType;
import com.ibm.im.ims.metadata.message.overlay.MessageInterfaceType;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.im.ims.metadata.message.overlay.YesnoType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.ims.dli.types.BaseTypeConverter;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.ims.transaction.messages.walkers.JSONToByteArrayOptions;
import com.ibm.ims.transaction.messages.walkers.MessageWalker;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.messages.walkers.TypeConverterWrapper;
import com.ibm.ims.transaction.tools.TransactionToolsLogger;
import com.ibm.ims.transaction.tools.messages.MessageBundles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;

public class JSONToByteArrayVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final TransactionToolsLogger logger = new TransactionToolsLogger();
    private JSONToByteArrayOptions options = new JSONToByteArrayOptions();
    private int redefinesDepth;
    private HashMap<String, Object> rootCompositeNode;
    private HashMap<String, Object> currCompositeNode;
    private List<HashMap<String, Object>> currCompositeNodeList;
    private Stack<HashMap<String, Object>> compositeNodeStack;
    private MessageType message;
    private Stack<FieldType> prevFieldStack;
    private Stack<Integer> redefinesGroupFieldMaxSizeStack;
    private Stack<Integer> compositeArrayStartOffsetStack;
    private HashMap<String, FieldType> fieldPathToFieldType;
    private HashMap<Object, List<?>> nodeToNodeList;
    private byte[] byteBuffer;
    private int byteOffset;
    private int segmentStartOffset;
    private int segmentEndOffset;
    private int segmentCount;
    private FieldType segmentFirstLeafField;
    private InterfaceFieldType currParentInterfaceField;
    private Stack<InterfaceFieldType> parentInterfaceFieldStack;
    private Stack<Integer> interfaceFieldIxStack = new Stack();
    private MessageInterfaceType msgInterface;
    private ServiceInterfaceSegmentType currInterfaceSegment;
    private int segmentIx = -1;

    public JSONToByteArrayVisitor(HashMap<String, Object> rootCompNode, String defaultStringEncoding, MessageInterfaceType msgInterface) throws MessageWalkerException {
        super(defaultStringEncoding);
        this.rootCompositeNode = rootCompNode;
        this.compositeNodeStack = new Stack();
        this.redefinesGroupFieldMaxSizeStack = new Stack();
        this.prevFieldStack = new Stack();
        this.msgInterface = msgInterface;
        this.fieldPathToFieldType = new HashMap();
        this.nodeToNodeList = new HashMap();
        this.parentInterfaceFieldStack = new Stack();
        this.compositeArrayStartOffsetStack = new Stack();
    }

    @Override
    public boolean isExpandArrays() {
        return true;
    }

    private boolean inRedefinesScope() {
        return this.redefinesDepth > 0;
    }

    @Override
    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.message = message;
        this.currCompositeNode = this.rootCompositeNode;
        this.segmentCount = message.getSegment().size();
        this.byteBuffer = new byte[this.segmentCount * Short.MAX_VALUE + 1];
        this.byteOffset = 0;
        this.interfaceFieldIxStack.clear();
        this.segmentIx = -1;
        if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
            logger.finer("Starting to walk the message", new Object[0]);
        }
        return state;
    }

    @Override
    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.segmentStartOffset = this.byteOffset;
        this.segmentEndOffset = this.byteOffset;
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        this.fieldPathToFieldType.clear();
        this.nodeToNodeList.clear();
        this.segmentFirstLeafField = null;
        this.redefinesDepth = 0;
        ++this.segmentIx;
        this.currInterfaceSegment = this.msgInterface.getSegment().get(this.segmentIx);
        this.interfaceFieldIxStack.push(-1);
        return state;
    }

    @Override
    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines) {
            ++this.redefinesDepth;
        }
        if (this.segmentFirstLeafField == null) {
            this.segmentFirstLeafField = field;
        }
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        Object leafNode = null;
        if (currInterfaceField.getIncluded() == YesnoType.Y) {
            leafNode = this.currCompositeNode.get(field.getName());
        }
        if (JSONToByteArrayVisitor.isTrue(field.isDependedOn()).booleanValue()) {
            this.fieldPathToFieldType.put(fieldPath.getValue(), field);
            leafNode = null;
        }
        if (leafNode != null && (leafNode instanceof HashMap || leafNode instanceof List)) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode(MessageBundles.MW.MW0009E).message(MessageBundles.getMessage(MessageBundles.MW.MW0009E)).args(fieldPath.getValue(), this.message.getName()).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = this.prevFieldStack.peek().getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leaField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
            }
            this.segmentEndOffset -= redefinesGroupFieldMaxSize;
            int amountRedefinesGroupGrewBy = 0;
            if (currFieldSize > redefinesGroupFieldMaxSize) {
                amountRedefinesGroupGrewBy = currFieldSize - redefinesGroupFieldMaxSize;
                redefinesGroupFieldMaxSize = currFieldSize;
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            if (amountRedefinesGroupGrewBy > 0) {
                this.manageByteBuffer(amountRedefinesGroupGrewBy);
            }
            try {
                int stackTopIndex;
                TypeConverterWrapper converterWrapper = this.getTypeConverter(field);
                BaseTypeConverter converter = converterWrapper.getTypeConverter();
                ArrayList warnings = new ArrayList();
                if (!this.compositeArrayStartOffsetStack.isEmpty() && (Integer)this.compositeArrayStartOffsetStack.get(stackTopIndex = this.compositeArrayStartOffsetStack.size() - 1) == 0) {
                    this.compositeArrayStartOffsetStack.set(stackTopIndex, this.byteOffset - this.segmentStartOffset);
                }
                if (leafNode != null) {
                    Integer startPos = field.getStartPos();
                    if (startPos != null && this.byteOffset != startPos - 1) {
                        int offset = this.byteOffset + 1;
                        logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                    } else if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                        int offset = this.byteOffset + 1;
                        logger.finer("Writing field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                    }
                    converter.writeObject(this.byteBuffer, this.byteOffset, currFieldSize, (Object)String.valueOf(leafNode), warnings);
                } else {
                    String defaultValue = currInterfaceField.getDefaultValue();
                    if (defaultValue != null && !defaultValue.isEmpty()) {
                        Integer startPos = field.getStartPos();
                        if (startPos != null && this.byteOffset != startPos - 1) {
                            int offset = this.byteOffset + 1;
                            logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                        } else if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                            int offset = this.byteOffset + 1;
                            logger.finer("Writing field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                        }
                        converter.writeObject(this.byteBuffer, this.byteOffset, currFieldSize, (Object)defaultValue, warnings);
                    } else if (!this.inRedefinesScope() && this.options.isInitializeInputFields()) {
                        Object initialValue = converterWrapper.getInitialValue();
                        Integer startPos = field.getStartPos();
                        if (startPos != null && this.byteOffset != startPos - 1) {
                            int offset = this.byteOffset + 1;
                            logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                        } else if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                            int offset = this.byteOffset + 1;
                            logger.finer("Writing field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                        }
                        converter.writeObject(this.byteBuffer, this.byteOffset, currFieldSize, (Object)String.valueOf(initialValue), warnings);
                    }
                }
                this.byteOffset += redefinesGroupFieldMaxSize;
                if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                    int offset = this.byteOffset + 1;
                    logger.finer("At leafField \"" + field.getName() + "\" bumping byteOffset forward by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because this field is part of a redefines group and the next field will start after the biggest field of this group.", new Object[0]);
                }
                this.segmentEndOffset += redefinesGroupFieldMaxSize;
            }
            catch (Exception e) {
                MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0005E).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(fieldPath.getValue(), this.message.getName(), e.getMessage()).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
        }
        this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, 0);
        try {
            int stackTopIndex;
            TypeConverterWrapper converterWrapper = this.getTypeConverter(field);
            BaseTypeConverter converter = converterWrapper.getTypeConverter();
            ArrayList warnings = new ArrayList();
            int slackBytes = JSONToByteArrayVisitor.getSlackByteCount(field, this.byteOffset - this.segmentStartOffset);
            this.byteOffset += slackBytes;
            if (slackBytes > 0 && JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("For field \"" + field.getName() + "\" byteOffset is being bumped forward by slackBytes: " + slackBytes + " to: " + offset + " because the field is numeric and aligned.", new Object[0]);
            }
            this.segmentEndOffset += slackBytes;
            if (!this.compositeArrayStartOffsetStack.isEmpty() && (Integer)this.compositeArrayStartOffsetStack.get(stackTopIndex = this.compositeArrayStartOffsetStack.size() - 1) == 0) {
                this.compositeArrayStartOffsetStack.set(stackTopIndex, this.byteOffset - this.segmentStartOffset);
            }
            Integer fieldBytes = field.getBytes();
            this.manageByteBuffer(fieldBytes + slackBytes);
            if (leafNode != null) {
                Integer startPos = field.getStartPos();
                if (startPos != null && this.byteOffset != startPos - 1) {
                    int offset = this.byteOffset + 1;
                    logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                } else if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                    int offset = this.byteOffset + 1;
                    logger.finer("Writing field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                }
                converter.writeObject(this.byteBuffer, this.byteOffset, fieldBytes.intValue(), (Object)String.valueOf(leafNode), warnings);
            } else {
                String defaultValue = currInterfaceField.getDefaultValue();
                if (defaultValue != null && !defaultValue.isEmpty()) {
                    Integer startPos = field.getStartPos();
                    if (startPos != null && this.byteOffset != startPos - 1) {
                        int offset = this.byteOffset + 1;
                        logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                    } else if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                        int offset = this.byteOffset + 1;
                        logger.finer("Writing field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                    }
                    converter.writeObject(this.byteBuffer, this.byteOffset, fieldBytes.intValue(), (Object)String.valueOf(defaultValue), warnings);
                } else if (!this.inRedefinesScope() && this.options.isInitializeInputFields()) {
                    Object initialValue = converterWrapper.getInitialValue();
                    Integer startPos = field.getStartPos();
                    if (startPos != null && this.byteOffset != startPos - 1) {
                        int offset = this.byteOffset + 1;
                        logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                    } else if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                        int offset = this.byteOffset + 1;
                        logger.finer("Writing field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                    }
                    converter.writeObject(this.byteBuffer, this.byteOffset, fieldBytes.intValue(), (Object)String.valueOf(initialValue), warnings);
                }
            }
            this.byteOffset += fieldBytes.intValue();
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leafField \"" + field.getName() + "\" bumping byteOffset forward by: " + String.valueOf(fieldBytes) + " to: " + offset + " to account for the size of this field.", new Object[0]);
            }
            this.segmentEndOffset += fieldBytes.intValue();
        }
        catch (Exception e) {
            MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0005E).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(fieldPath.getValue(), this.message.getName(), e.getMessage()).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        if (redefines) {
            --this.redefinesDepth;
        }
        return state;
    }

    @Override
    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        int stackTopIndex;
        int actualLeafArraySize;
        if (redefines) {
            ++this.redefinesDepth;
        }
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        Object leafArrayNode = null;
        if (currInterfaceField.getIncluded() == YesnoType.Y) {
            leafArrayNode = this.currCompositeNode.get(fieldPath.peek());
        }
        FieldType parentField = fieldParents.peek();
        int maxOccurs = 0;
        maxOccurs = MessageWalker.isVariableLengthArray(parentField) ? this.getVariableArrayOccurrenceCount(parentField) : parentField.getMaxOccurs().intValue();
        List leafArrayList = Collections.emptyList();
        if (leafArrayNode != null) {
            if (!(leafArrayNode instanceof List)) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0010E)).messageCode(MessageBundles.MW.MW0010E).args(fieldPath.getValue(), this.message.getName()).build();
                logger.error(walkerException.getMessage(), walkerException);
                throw walkerException;
            }
            List list = (List)leafArrayNode;
            if (!list.isEmpty() && !(list.get(0) instanceof String)) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0010E)).messageCode(MessageBundles.MW.MW0010E).args(fieldPath.getValue(), this.message.getName()).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
            leafArrayList = list;
        }
        if ((actualLeafArraySize = leafArrayList.size()) > maxOccurs) {
            MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0011E)).messageCode(MessageBundles.MW.MW0011E).args(maxOccurs, fieldPath.getValue(), this.message.getName(), actualLeafArraySize).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        int currFieldCellSize = field.getBytes();
        int currFieldRowSize = currFieldCellSize * maxOccurs;
        int currFieldRowRemain = 0;
        if (redefines) {
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = this.prevFieldStack.peek().getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leafArrayField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
            }
            this.segmentEndOffset -= redefinesGroupFieldMaxSize;
            int amountRedefinesGroupGrewBy = 0;
            if (currFieldRowSize > redefinesGroupFieldMaxSize) {
                amountRedefinesGroupGrewBy = currFieldRowSize - redefinesGroupFieldMaxSize;
                redefinesGroupFieldMaxSize = currFieldRowSize;
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            if (amountRedefinesGroupGrewBy > 0) {
                this.manageByteBuffer(amountRedefinesGroupGrewBy);
            }
            currFieldRowRemain = redefinesGroupFieldMaxSize;
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, 0);
            currFieldRowRemain = currFieldRowSize;
        }
        if (!this.compositeArrayStartOffsetStack.isEmpty() && (Integer)this.compositeArrayStartOffsetStack.get(stackTopIndex = this.compositeArrayStartOffsetStack.size() - 1) == 0) {
            this.compositeArrayStartOffsetStack.set(stackTopIndex, this.byteOffset - this.segmentStartOffset);
        }
        this.manageByteBuffer(currFieldRowRemain);
        TypeConverterWrapper converterWrapper = this.getTypeConverter(field);
        BaseTypeConverter converter = converterWrapper.getTypeConverter();
        Object initialValue = converterWrapper.getInitialValue();
        int countActualLeafEntry = 0;
        int index = 0;
        while (index < maxOccurs) {
            try {
                String leafNode = null;
                if (index < leafArrayList.size()) {
                    leafNode = (String)leafArrayList.get(index);
                }
                if (leafNode != null) {
                    if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                        offset = this.byteOffset + 1;
                        logger.finer("Writing leafArrayfield \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                    }
                    converter.writeObject(this.byteBuffer, this.byteOffset, currFieldCellSize, (Object)String.valueOf(leafNode), null);
                    ++countActualLeafEntry;
                } else if (!this.inRedefinesScope() && this.options.isInitializeInputFields()) {
                    if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                        offset = this.byteOffset + 1;
                        logger.finer("Payload did not contain a value, initialize the field based on its type for leafArrayfield \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                    }
                    converter.writeObject(this.byteBuffer, this.byteOffset, currFieldCellSize, (Object)String.valueOf(initialValue), null);
                }
            }
            catch (Exception e) {
                MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0005E).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(fieldPath.getValue(), this.message.getName(), e.getMessage()).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
            this.byteOffset += currFieldCellSize;
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leafArrayfield for field \"" + field.getName() + "\" bumping offset forward by: " + currFieldCellSize + " to: " + offset + " to move forward for the next array cell.", new Object[0]);
            }
            this.segmentEndOffset += currFieldCellSize;
            currFieldRowRemain -= currFieldCellSize;
            ++index;
        }
        this.byteOffset += currFieldRowRemain;
        if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
            int offset = this.byteOffset + 1;
            logger.finer("At leafArrayfield for field \"" + field.getName() + "\" bumping offset forward by: " + currFieldRowRemain + " to: " + offset + " to move forward for the next array cell.", new Object[0]);
        }
        this.segmentEndOffset += currFieldRowRemain;
        currFieldRowRemain = 0;
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        if (redefines) {
            --this.redefinesDepth;
        }
        int minOccurs = parentField.getMinOccurs();
        if (this.options.isEnforceMinArrayOccurrence() && countActualLeafEntry < minOccurs) {
            MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage(MessageBundles.MW.MW0017E)).messageCode(MessageBundles.MW.MW0017E).args(minOccurs, fieldPath.getValue(), this.message.getName(), countActualLeafEntry).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        return state;
    }

    @Override
    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines) {
            ++this.redefinesDepth;
        }
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currField = null;
        currField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        Object compositeNode = this.currCompositeNode.get(field.getName());
        if (compositeNode != null && !(compositeNode instanceof HashMap)) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode(MessageBundles.MW.MW0007E).message(MessageBundles.getMessage(MessageBundles.MW.MW0007E)).args(fieldPath.getValue(), this.message.getName()).build();
            throw walkerException;
        }
        this.currCompositeNode = compositeNode != null ? (HashMap)compositeNode : new HashMap();
        this.compositeNodeStack.push(this.currCompositeNode);
        int compositeFieldStackPos = this.redefinesGroupFieldMaxSizeStack.size() - 1;
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = (Integer)this.redefinesGroupFieldMaxSizeStack.elementAt(compositeFieldStackPos);
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = ((FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos)).getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At startOfCompositeField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
            }
            this.segmentEndOffset -= redefinesGroupFieldMaxSize;
            int amountRedefinesGroupGrewBy = 0;
            if (currFieldSize > redefinesGroupFieldMaxSize) {
                amountRedefinesGroupGrewBy = currFieldSize - redefinesGroupFieldMaxSize;
                redefinesGroupFieldMaxSize = currFieldSize;
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
            if (amountRedefinesGroupGrewBy > 0) {
                this.manageByteBuffer(amountRedefinesGroupGrewBy);
            }
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, 0);
        }
        this.prevFieldStack.set(compositeFieldStackPos, field);
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines) {
            ++this.redefinesDepth;
        }
        HashMap<String, Object> compositeNode = this.currCompositeNode.get(field.getName());
        if (index == 0 && compositeNode instanceof List) {
            int maxOccurs = field.getMaxOccurs();
            int minOccurs = field.getMinOccurs();
            int actualNumberOfFieldsInComposite = ((List)((Object)compositeNode)).size();
            if (actualNumberOfFieldsInComposite > maxOccurs) {
                MessageWalkerException walkerException = MessageWalkerException.builder().messageCode(MessageBundles.MW.MW0012E).message(MessageBundles.getMessage(MessageBundles.MW.MW0012E)).args(maxOccurs, fieldPath.getValue(), this.message.getName(), actualNumberOfFieldsInComposite).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
            if (this.options.isEnforceMinArrayOccurrence() && actualNumberOfFieldsInComposite < minOccurs) {
                MessageWalkerException walkerException = MessageWalkerException.builder().messageCode(MessageBundles.MW.MW0016E).message(MessageBundles.getMessage(MessageBundles.MW.MW0016E)).args(minOccurs, fieldPath.getValue(), this.message.getName(), actualNumberOfFieldsInComposite).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
        }
        if (compositeNode instanceof List && ((List)((Object)compositeNode)).size() > index && !(((List)((Object)compositeNode)).get(index) instanceof HashMap)) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode(MessageBundles.MW.MW0008E).message(MessageBundles.getMessage(MessageBundles.MW.MW0008E)).args(fieldPath.getValue(), this.message.getName()).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        if (compositeNode instanceof List) {
            if (((List)((Object)compositeNode)).size() - 1 < index) {
                compositeNode = null;
            } else if (((List)((Object)compositeNode)).get(index) instanceof HashMap) {
                this.currCompositeNodeList = (List)((Object)compositeNode);
                compositeNode = this.currCompositeNodeList.get(index);
            }
        }
        if (compositeNode != null) {
            this.currCompositeNode = compositeNode;
        } else {
            this.currCompositeNode = new HashMap();
            this.currCompositeNodeList = null;
        }
        this.compositeNodeStack.push(this.currCompositeNode);
        int compositeFieldStackPos = this.redefinesGroupFieldMaxSizeStack.size() - 1;
        FieldType prevField = (FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        if (prevField != field) {
            fieldIx = fieldIx + 1;
            this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        }
        InterfaceFieldType currField = null;
        currField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        if (redefines) {
            if (index == 0) {
                int currFieldSize = field.getBytes();
                int redefinesGroupFieldMaxSize = (Integer)this.redefinesGroupFieldMaxSizeStack.elementAt(compositeFieldStackPos);
                if (redefinesGroupFieldMaxSize == 0) {
                    redefinesGroupFieldMaxSize = ((FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos)).getBytes();
                    this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
                }
                this.byteOffset -= redefinesGroupFieldMaxSize;
                if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                    int offset = this.byteOffset + 1;
                    logger.finer("At startOfCompositeArrayField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
                }
                this.segmentEndOffset -= redefinesGroupFieldMaxSize;
                int amountRedefinesGroupGrewBy = 0;
                if (currFieldSize > redefinesGroupFieldMaxSize) {
                    amountRedefinesGroupGrewBy = currFieldSize - redefinesGroupFieldMaxSize;
                    redefinesGroupFieldMaxSize = currFieldSize;
                    this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
                }
                if (amountRedefinesGroupGrewBy > 0) {
                    this.manageByteBuffer(amountRedefinesGroupGrewBy);
                }
            }
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, 0);
        }
        this.prevFieldStack.set(compositeFieldStackPos, field);
        this.compositeArrayStartOffsetStack.push(0);
        return state;
    }

    @Override
    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        this.compositeNodeStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            int difference = 0;
            if (currFieldSize < redefinesGroupFieldMaxSize) {
                difference = redefinesGroupFieldMaxSize - currFieldSize;
            }
            this.byteOffset += difference;
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At endOfCompositeField for field \"" + field.getName() + "\" byteOffset is being bumped forward by: " + difference + " to: " + offset + " because it's in a redefines group.", new Object[0]);
            }
            this.segmentEndOffset += difference;
        }
        this.currCompositeNode = !this.compositeNodeStack.isEmpty() ? this.compositeNodeStack.peek() : this.rootCompositeNode;
        if (redefines) {
            --this.redefinesDepth;
        }
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        this.compositeNodeStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        this.currCompositeNodeList = null;
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            int difference = 0;
            if (currFieldSize < redefinesGroupFieldMaxSize) {
                difference = redefinesGroupFieldMaxSize - currFieldSize;
            }
            this.byteOffset += difference;
            if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.info("At endOfCompositeArrayField for field \"" + field.getName() + "\" byteOffset is being bumped forward by: " + difference + " to: " + offset + " because it's in a redefines group.");
            }
            this.segmentEndOffset += difference;
        } else {
            Integer startOffset = this.compositeArrayStartOffsetStack.peek();
            int endOffset = this.byteOffset - this.segmentStartOffset;
            int arrayStride = endOffset - startOffset;
            int slackBytes = JSONToByteArrayVisitor.getSlackByteCount(field, arrayStride);
            this.byteOffset += slackBytes;
            if (slackBytes > 0 && JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("For field \"" + field.getName() + "\" byteOffset is being bumped forward by slackBytes: " + slackBytes + " to: " + offset + " because the field is numeric and aligned.", new Object[0]);
            }
            this.segmentEndOffset += slackBytes;
        }
        this.currCompositeNode = !this.compositeNodeStack.isEmpty() ? this.compositeNodeStack.peek() : this.rootCompositeNode;
        this.compositeArrayStartOffsetStack.pop();
        if (redefines) {
            --this.redefinesDepth;
        }
        return state;
    }

    @Override
    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.interfaceFieldIxStack.pop();
        try {
            if (this.options.isSetLL()) {
                TypeConverterWrapper converterWrapper = this.getTypeConverter(this.segmentFirstLeafField);
                BaseTypeConverter converter = converterWrapper.getTypeConverter();
                Integer segmentLength = this.segmentEndOffset - this.segmentStartOffset;
                converter.writeObject(this.byteBuffer, this.segmentStartOffset, this.segmentFirstLeafField.getBytes().intValue(), (Object)segmentLength, null);
            }
        }
        catch (Exception e) {
            MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0005E).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(this.segmentFirstLeafField.getName(), this.message.getName(), e.getMessage()).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        this.segmentStartOffset = this.byteOffset;
        this.segmentEndOffset = this.byteOffset;
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        return state;
    }

    @Override
    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.currParentInterfaceField = null;
        if (JSONToByteArrayVisitor.logger.logger.isLoggable(Level.FINER)) {
            logger.finer("At endOfMessageType for message \"" + message.getName() + "\" .", new Object[0]);
        }
        return state;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public Integer getByteBufferOffset() {
        return this.byteOffset;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.byteBuffer, this.byteOffset);
    }

    private void manageByteBuffer(Integer requiredBytes) {
        if (this.byteOffset + 1 + requiredBytes > this.byteBuffer.length) {
            byte[] byteBufferTmp = this.byteBuffer;
            this.byteBuffer = new byte[this.byteBuffer.length * 2];
            System.arraycopy(byteBufferTmp, 0, this.byteBuffer, 0, byteBufferTmp.length);
        }
    }

    @Override
    public int getVariableArrayOccurrenceCount(FieldType field) throws MessageWalkerException {
        String dependsOnPath = field.getDependsOnPath();
        if (dependsOnPath == null || dependsOnPath.isEmpty()) {
            return 0;
        }
        FieldType dependsOnField = this.fieldPathToFieldType.get(dependsOnPath);
        if (dependsOnField == null) {
            return 0;
        }
        Integer occurrenceCount = 0;
        TypeConverterWrapper converterWrapper = this.getTypeConverter(dependsOnField);
        BaseTypeConverter converter = converterWrapper.getTypeConverter();
        try {
            int dependsOnFieldOffset = dependsOnField.getStartPos() - 1;
            occurrenceCount = (Integer)converter.readObject(this.byteBuffer, dependsOnFieldOffset += this.segmentStartOffset, dependsOnField.getBytes().intValue(), Integer.class, null);
            if (this.currCompositeNodeList != null) {
                for (HashMap<String, Object> node : this.currCompositeNodeList) {
                    Object array = node.get(field.getName());
                    if (!(array instanceof List)) continue;
                    occurrenceCount = Math.max(occurrenceCount, ((List)array).size());
                }
            } else {
                Object array = this.currCompositeNode.get(field.getName());
                if (array instanceof List) {
                    occurrenceCount = Math.max(occurrenceCount, ((List)array).size());
                }
            }
            occurrenceCount = Math.min(occurrenceCount, field.getMaxOccurs());
            converter.writeObject(this.byteBuffer, dependsOnFieldOffset, dependsOnField.getBytes().intValue(), (Object)occurrenceCount, null);
        }
        catch (Exception e) {
            MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0013E).message(MessageBundles.getMessage(MessageBundles.MW.MW0013E)).args(dependsOnField.getName(), field.getName(), this.message.getName(), e.getMessage()).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        return occurrenceCount;
    }

    public JSONToByteArrayOptions getOptions() {
        return this.options;
    }

    public void setOptions(JSONToByteArrayOptions conversionOptions) {
        this.options = conversionOptions;
    }

    @Override
    public void validateFieldCanHaveZeroElements(FieldType field, FieldPath fieldPath) throws MessageWalkerException {
        int zero = 0;
        if (this.getOptions().isEnforceMinArrayOccurrence() && zero < field.getMinOccurs()) {
            String elementName = this.message == null ? field.getName() : this.message.getName();
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode(MessageBundles.MW.MW0016E).message(MessageBundles.getMessage(MessageBundles.MW.MW0016E)).args(field.getMinOccurs(), fieldPath.getValue(), elementName, zero).build();
            throw walkerException;
        }
    }
}

