/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.message.overlay.InterfaceFieldType;
import com.ibm.im.ims.metadata.message.overlay.MessageInterfaceType;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.YesnoType;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.JSONConversionUtil;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.messages.walkers.SimpleMessageVisitor;
import com.ibm.ims.transaction.util.MapUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;

public class JSONSchemaVisitor
extends SimpleMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static int INBOUND = 0;
    public static int OUTBOUND = 1;
    private JsonObjectRef rootJsonObject;
    private Stack<JsonObjectRef> jsonObjectStack;
    public static String attr_default = "default";
    public static String attr_description = "description";
    public static String attr_format = "format";
    public static String attr_items = "items";
    public static String attr_maximum = "maximum";
    public static String attr_maxLength = "maxLength";
    public static String attr_maxItems = "maxItems";
    public static String attr_minimum = "minimum";
    public static String attr_minItems = "minItems";
    public static String attr_multipleOf = "multipleOf";
    public static String attr_properties = "properties";
    public static String attr_required = "required";
    public static String attr_type = "type";
    public static String attr_value = "value";
    public static String type_array = "array";
    public static String type_integer = "integer";
    public static String type_number = "number";
    public static String type_object = "object";
    public static String type_string = "string";
    public static String format_decimal = "decimal";
    public static String format_float = "float";
    public static String format_double = "double";
    private InterfaceFieldType currParentInterfaceField;
    private Stack<InterfaceFieldType> parentInterfaceFieldStack;
    private Stack<Integer> interfaceFieldIxStack = new Stack();
    private MessageInterfaceType msgInterface;
    private ServiceInterfaceSegmentType currInterfaceSegment;
    private int segmentIx = -1;

    public JSONSchemaVisitor(int direction, MessageInterfaceType msgInterface) {
        this.msgInterface = msgInterface;
        this.rootJsonObject = new JsonObjectRef();
        this.jsonObjectStack = new Stack();
        this.parentInterfaceFieldStack = new Stack();
    }

    public HashMap<String, Object> getHashMap() {
        return this.rootJsonObject.ref;
    }

    @Override
    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        super.startOfMessageType(message, state);
        this.interfaceFieldIxStack.clear();
        this.rootJsonObject.ref.put(attr_type, type_object);
        this.rootJsonObject.ref.put(attr_properties, new LinkedHashMap());
        this.jsonObjectStack.push(this.rootJsonObject);
        return state;
    }

    @Override
    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        super.endOfMessageType(message, state);
        this.currParentInterfaceField = null;
        this.jsonObjectStack.pop();
        if (this.rootJsonObject.refCnt == 0) {
            this.rootJsonObject.ref.remove(attr_type);
            this.rootJsonObject.ref.remove(attr_properties);
        }
        return state;
    }

    @Override
    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        super.leafField(field, fieldPath, fieldParents, redefines, state);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        if (currInterfaceField.getIncluded() == com.ibm.im.ims.metadata.message.overlay.YesnoType.Y) {
            LinkedHashMap<String, Object> attributeNode = new LinkedHashMap<String, Object>();
            String defaultValue = currInterfaceField.getDefaultValue();
            this.processField(field, attributeNode, defaultValue);
            JsonObjectRef parentObject = this.jsonObjectStack.peek();
            LinkedHashMap properties = null;
            if (parentObject.ref.containsKey(attr_properties)) {
                properties = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_properties);
            } else if (parentObject.ref.containsKey(attr_items)) {
                LinkedHashMap items = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_items);
                properties = (LinkedHashMap)MapUtil.get(items, attr_properties);
            }
            if (properties != null) {
                properties.put(field.getName(), attributeNode);
                ++parentObject.refCnt;
            }
        }
        return state;
    }

    @Override
    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        super.startOfCompositeField(field, fieldPath, fieldParents, redefines, state);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currField = null;
        currField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        LinkedHashMap<String, Object> compositeNode = new LinkedHashMap<String, Object>();
        compositeNode.put(attr_type, type_object);
        compositeNode.put(attr_properties, new LinkedHashMap());
        JsonObjectRef parentObject = this.jsonObjectStack.peek();
        LinkedHashMap properties = null;
        if (parentObject.ref.containsKey(attr_properties)) {
            properties = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_properties);
        } else if (parentObject.ref.containsKey(attr_items)) {
            LinkedHashMap items = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_items);
            properties = (LinkedHashMap)MapUtil.get(items, attr_properties);
        }
        if (properties != null) {
            properties.put(field.getName(), compositeNode);
            ++parentObject.refCnt;
        }
        this.jsonObjectStack.push(new JsonObjectRef(compositeNode));
        return state;
    }

    @Override
    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        super.endOfCompositeField(field, fieldPath, fieldParents, redefines, state);
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        JsonObjectRef composite = this.jsonObjectStack.pop();
        JsonObjectRef parentObject = this.jsonObjectStack.peek();
        if (composite.refCnt == 0) {
            LinkedHashMap properties = null;
            if (parentObject.ref.containsKey(attr_properties)) {
                properties = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_properties);
            } else if (parentObject.ref.containsKey(attr_items)) {
                LinkedHashMap items = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_items);
                properties = (LinkedHashMap)MapUtil.get(items, attr_properties);
            }
            if (properties != null) {
                properties.remove(field.getName());
                --parentObject.refCnt;
            }
        }
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer min;
        super.startOfCompositeArrayField(field, fieldPath, index, fieldParents, redefines, state);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currField = null;
        currField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        LinkedHashMap<String, Object> compositeArrayNode = new LinkedHashMap<String, Object>();
        JsonObjectRef parentObject = this.jsonObjectStack.peek();
        LinkedHashMap properties = null;
        if (parentObject.ref.containsKey(attr_properties)) {
            properties = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_properties);
        } else if (parentObject.ref.containsKey(attr_items)) {
            LinkedHashMap items = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_items);
            properties = (LinkedHashMap)MapUtil.get(items, attr_properties);
        }
        if (properties != null) {
            properties.put(field.getName(), compositeArrayNode);
            ++parentObject.refCnt;
        }
        compositeArrayNode.put(attr_type, type_array);
        Integer max = field.getMaxOccurs();
        if (max != null) {
            compositeArrayNode.put(attr_maxItems, BigInteger.valueOf(max.intValue()));
        }
        if ((min = field.getMinOccurs()) != null) {
            compositeArrayNode.put(attr_minItems, BigInteger.valueOf(min.intValue()));
        }
        LinkedHashMap<String, Object> itemsNode = new LinkedHashMap<String, Object>();
        itemsNode.put(attr_type, type_object);
        compositeArrayNode.put(attr_items, itemsNode);
        LinkedHashMap propertiesNode = new LinkedHashMap();
        itemsNode.put(attr_properties, propertiesNode);
        this.jsonObjectStack.push(new JsonObjectRef(compositeArrayNode));
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        super.endOfCompositeArrayField(field, fieldPath, index, fieldParents, redefines, state);
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        JsonObjectRef composite = this.jsonObjectStack.pop();
        JsonObjectRef parentObject = this.jsonObjectStack.peek();
        if (composite.refCnt == 0) {
            LinkedHashMap properties = null;
            if (parentObject.ref.containsKey(attr_properties)) {
                properties = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_properties);
            } else if (parentObject.ref.containsKey(attr_items)) {
                LinkedHashMap items = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_items);
                properties = (LinkedHashMap)MapUtil.get(items, attr_properties);
            }
            if (properties != null) {
                properties.remove(field.getName());
                --parentObject.refCnt;
            }
        }
        return state;
    }

    @Override
    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        super.startOfSegmentType(segment, state);
        ++this.segmentIx;
        this.currInterfaceSegment = this.msgInterface.getSegment().get(this.segmentIx);
        this.interfaceFieldIxStack.push(-1);
        return state;
    }

    @Override
    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        super.endOfSegmentType(segment, state);
        this.interfaceFieldIxStack.pop();
        return state;
    }

    @Override
    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        super.leafArrayField(field, fieldPath, fieldParents, redefines, state);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        if (currInterfaceField.getIncluded() == com.ibm.im.ims.metadata.message.overlay.YesnoType.Y) {
            Integer min;
            LinkedHashMap<String, Object> leafArrayNode = new LinkedHashMap<String, Object>();
            leafArrayNode.put(attr_type, type_array);
            Integer max = fieldParents.peek().getMaxOccurs();
            if (max != null) {
                leafArrayNode.put(attr_maxItems, BigInteger.valueOf(max.intValue()));
            }
            if ((min = fieldParents.peek().getMinOccurs()) != null) {
                leafArrayNode.put(attr_minItems, BigInteger.valueOf(min.intValue()));
            }
            LinkedHashMap<String, Object> itemsNode = new LinkedHashMap<String, Object>();
            leafArrayNode.put(attr_items, itemsNode);
            String defaultValue = currInterfaceField.getDefaultValue();
            this.processField(field, itemsNode, defaultValue);
            JsonObjectRef parentObject = this.jsonObjectStack.peek();
            LinkedHashMap properties = null;
            if (parentObject.ref.containsKey(attr_properties)) {
                properties = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_properties);
            } else if (parentObject.ref.containsKey(attr_items)) {
                LinkedHashMap items = (LinkedHashMap)MapUtil.get(parentObject.ref, attr_items);
                properties = (LinkedHashMap)MapUtil.get(items, attr_properties);
            }
            if (properties != null) {
                properties.put(fieldParents.peek().getName(), leafArrayNode);
                ++parentObject.refCnt;
            }
        }
        return state;
    }

    @Override
    public boolean isExpandArrays() {
        return super.isExpandArrays();
    }

    private Object scaleZero(Integer x) {
        int i = x;
        BigDecimal value = new BigDecimal(1);
        while (i > 0) {
            value = value.divide(BigDecimal.TEN);
            --i;
        }
        if (value.scale() == 0) {
            return value.toBigInteger();
        }
        return value;
    }

    private Object getMinPrecision(FieldType field, int precision, int scale, boolean signed, YesnoType nativeInt) {
        if (nativeInt == YesnoType.Y) {
            BigDecimal minValue = new BigDecimal(0);
            if (signed) {
                minValue = new BigDecimal(2);
                minValue = minValue.pow(8 * precision - 1);
            }
            int fractionDigits = scale;
            while (fractionDigits > 0) {
                minValue = minValue.divide(BigDecimal.TEN);
                --fractionDigits;
            }
            if ((minValue = minValue.negate()).scale() == 0) {
                return minValue.toBigInteger();
            }
            return minValue;
        }
        if (precision == 0 || !signed) {
            return BigInteger.ZERO;
        }
        BigDecimal minValue = new BigDecimal(9);
        int totalDigits = precision;
        while (--totalDigits > 0) {
            minValue = minValue.multiply(BigDecimal.TEN);
            minValue = minValue.add(new BigDecimal(9));
        }
        int fractionDigits = scale;
        while (--fractionDigits >= 0) {
            minValue = minValue.divide(BigDecimal.TEN);
        }
        if ((minValue = minValue.negate()).scale() == 0) {
            return minValue.toBigInteger();
        }
        return minValue;
    }

    private Object getMaxPrecision(FieldType field, int precision, int scale, boolean signed, YesnoType nativeInt) {
        if (nativeInt == YesnoType.Y) {
            BigDecimal maxValue = new BigDecimal(2);
            if (signed) {
                maxValue = maxValue.pow(8 * precision - 1);
                maxValue = maxValue.subtract(BigDecimal.ONE);
            } else {
                maxValue = maxValue.pow(8 * precision);
            }
            int fractionDigits = scale;
            while (fractionDigits > 0) {
                maxValue = maxValue.divide(BigDecimal.TEN);
                --fractionDigits;
            }
            if (maxValue.scale() == 0) {
                return maxValue.toBigInteger();
            }
            return maxValue;
        }
        if (precision == 0) {
            return BigInteger.ONE;
        }
        BigDecimal maxValue = new BigDecimal(9);
        int totalDigits = precision;
        while (--totalDigits > 0) {
            maxValue = maxValue.multiply(BigDecimal.TEN);
            maxValue = maxValue.add(new BigDecimal(9));
        }
        int fractionDigits = scale;
        while (--fractionDigits >= 0) {
            maxValue = maxValue.divide(BigDecimal.TEN);
        }
        if (maxValue.scale() == 0) {
            return maxValue.toBigInteger();
        }
        return maxValue;
    }

    private void processField(FieldType field, LinkedHashMap<String, Object> attributeNode, String defaultValue) {
        ApplicationDatatypeType adt = field.getApplicationDatatype();
        DatatypeType dataType = adt.getDatatype();
        String jsonDataType = "";
        String jsonFormat = "";
        int precision = 0;
        int scale = 0;
        String remarks = field.getRemarks();
        if (remarks == null) {
            remarks = "";
        }
        switch (dataType) {
            case CHAR: {
                jsonDataType = type_string;
                Object maxLength = JSONConversionUtil.subWithStringIfNotInRangeOfLong(new BigInteger(field.getBytes().toString()));
                attributeNode.put(attr_maxLength, maxLength);
                break;
            }
            case SHORT: 
            case INT: 
            case LONG: {
                YesnoType nativeInt = field.getMarshaller().getIsNativeInteger();
                precision = nativeInt == YesnoType.Y ? field.getBytes().intValue() : adt.getPrecision().intValue();
                jsonDataType = type_integer;
                attributeNode.put(attr_minimum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMinPrecision(field, precision, 0, true, nativeInt)));
                attributeNode.put(attr_maximum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMaxPrecision(field, precision, 0, true, nativeInt)));
                break;
            }
            case USHORT: 
            case UINT: 
            case ULONG: {
                YesnoType nativeInt = field.getMarshaller().getIsNativeInteger();
                precision = nativeInt == YesnoType.Y ? field.getBytes().intValue() : adt.getPrecision().intValue();
                jsonDataType = type_integer;
                attributeNode.put(attr_minimum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMinPrecision(field, precision, 0, false, nativeInt)));
                attributeNode.put(attr_maximum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMaxPrecision(field, precision, 0, false, nativeInt)));
                break;
            }
            case DECIMAL: {
                YesnoType nativeInt = field.getMarshaller().getIsNativeInteger();
                precision = nativeInt != null && nativeInt.equals((Object)YesnoType.Y) ? field.getBytes().intValue() : adt.getPrecision().intValue();
                scale = adt.getScale();
                if (field.getMarshaller().getTypeConverter() == PhysicalDatatypeType.ZONEDDECIMAL) {
                    if (adt.getScale() > 0) {
                        jsonDataType = type_number;
                        jsonFormat = format_decimal;
                        attributeNode.put(attr_multipleOf, this.scaleZero(scale));
                    } else {
                        jsonDataType = type_integer;
                    }
                } else if (field.getMarshaller().getTypeConverter() == PhysicalDatatypeType.PACKEDDECIMAL) {
                    jsonDataType = type_number;
                    jsonFormat = format_decimal;
                    attributeNode.put(attr_multipleOf, this.scaleZero(scale));
                } else {
                    jsonDataType = type_number;
                    jsonFormat = format_decimal;
                    attributeNode.put(attr_multipleOf, this.scaleZero(scale));
                }
                if (field.getMarshaller().getIsSigned() == YesnoType.N) {
                    attributeNode.put(attr_minimum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMinPrecision(field, precision, scale, false, nativeInt)));
                    attributeNode.put(attr_maximum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMaxPrecision(field, precision, scale, false, nativeInt)));
                    break;
                }
                attributeNode.put(attr_minimum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMinPrecision(field, precision, scale, true, nativeInt)));
                attributeNode.put(attr_maximum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMaxPrecision(field, precision, scale, true, nativeInt)));
                break;
            }
            case BINARY: {
                jsonDataType = type_number;
                precision = adt.getPrecision();
                scale = adt.getScale();
                YesnoType nativeInt = field.getMarshaller().getIsNativeInteger();
                if (field.getMarshaller().getIsSigned() == YesnoType.N) {
                    attributeNode.put(attr_minimum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMinPrecision(field, precision, scale, false, nativeInt)));
                    attributeNode.put(attr_maximum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMaxPrecision(field, precision, scale, false, nativeInt)));
                } else {
                    attributeNode.put(attr_minimum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMinPrecision(field, precision, scale, true, nativeInt)));
                    attributeNode.put(attr_maximum, JSONConversionUtil.subWithStringIfNotInRangeOfLong(this.getMaxPrecision(field, precision, scale, true, nativeInt)));
                }
                attributeNode.put(attr_multipleOf, this.scaleZero(scale));
                jsonFormat = format_decimal;
                break;
            }
            case FLOAT: {
                jsonDataType = type_number;
                jsonFormat = format_float;
                break;
            }
            case DOUBLE: {
                jsonDataType = type_number;
                jsonFormat = format_double;
                break;
            }
            default: {
                jsonDataType = type_string;
            }
        }
        if (jsonDataType != null && !jsonDataType.isEmpty()) {
            attributeNode.put(attr_type, jsonDataType);
        }
        if (jsonFormat != null && !jsonFormat.isEmpty()) {
            attributeNode.put(attr_format, jsonFormat);
        }
        if (defaultValue != null && !defaultValue.isEmpty()) {
            attributeNode.put(attr_default, defaultValue);
        }
        if (remarks != null && !remarks.isEmpty()) {
            attributeNode.put(attr_description, remarks);
        }
    }

    private class JsonObjectRef {
        private LinkedHashMap<String, Object> ref;
        private int refCnt;

        public JsonObjectRef() {
            this.ref = new LinkedHashMap();
            this.refCnt = 0;
        }

        public JsonObjectRef(LinkedHashMap<String, Object> ref) {
            this.ref = ref;
            this.refCnt = 0;
        }
    }
}

