/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.transaction.AlignmentType;
import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import com.ibm.im.ims.metadata.transaction.YesnoType;
import com.ibm.ims.dli.types.BaseTypeConverter;
import com.ibm.ims.dli.types.ByteConverter;
import com.ibm.ims.dli.types.BytesConverter;
import com.ibm.ims.dli.types.DoubleConverter;
import com.ibm.ims.dli.types.FloatConverter;
import com.ibm.ims.dli.types.IntegerConverter;
import com.ibm.ims.dli.types.LongConverter;
import com.ibm.ims.dli.types.PackedDecimalConverter;
import com.ibm.ims.dli.types.ShortConverter;
import com.ibm.ims.dli.types.UByteConverter;
import com.ibm.ims.dli.types.UIntegerConverter;
import com.ibm.ims.dli.types.ULongConverter;
import com.ibm.ims.dli.types.UShortConverter;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.IMessageVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.messages.walkers.StringConverter2;
import com.ibm.ims.transaction.messages.walkers.TypeConverterWrapper;
import com.ibm.ims.transaction.messages.walkers.ZonedDecimalConverter2;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Stack;

public abstract class JSONConversionVisitor
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static HashMap<DatatypeType, TypeConverterWrapper> typeConverters = new HashMap();
    private static HashMap<String, TypeConverterWrapper> stringConverters;
    private static HashMap<String, TypeConverterWrapper> bytesConverters;
    private static HashMap<String, TypeConverterWrapper> packedDecimalConverters;
    private static HashMap<String, TypeConverterWrapper> zonedDecimalConverters;
    private String defaultStringEncoding = "IBM-1140";

    static {
        typeConverters.put(DatatypeType.BYTE, new TypeConverterWrapper((BaseTypeConverter)new ByteConverter(), (byte)0, String.class));
        typeConverters.put(DatatypeType.SHORT, new TypeConverterWrapper((BaseTypeConverter)new ShortConverter(), (short)0, Short.class));
        typeConverters.put(DatatypeType.INT, new TypeConverterWrapper((BaseTypeConverter)new IntegerConverter(), 0, Integer.class));
        typeConverters.put(DatatypeType.LONG, new TypeConverterWrapper((BaseTypeConverter)new LongConverter(), 0L, Long.class));
        typeConverters.put(DatatypeType.UBYTE, new TypeConverterWrapper((BaseTypeConverter)new UByteConverter(), (byte)0, String.class));
        typeConverters.put(DatatypeType.USHORT, new TypeConverterWrapper((BaseTypeConverter)new UShortConverter(), (short)0, Integer.class));
        typeConverters.put(DatatypeType.UINT, new TypeConverterWrapper((BaseTypeConverter)new UIntegerConverter(), 0, Long.class));
        typeConverters.put(DatatypeType.ULONG, new TypeConverterWrapper((BaseTypeConverter)new ULongConverter(), 0L, BigInteger.class));
        typeConverters.put(DatatypeType.FLOAT, new TypeConverterWrapper((BaseTypeConverter)new FloatConverter(), Float.valueOf(0.0f), BigDecimal.class));
        typeConverters.put(DatatypeType.DOUBLE, new TypeConverterWrapper((BaseTypeConverter)new DoubleConverter(), 0.0, BigDecimal.class));
        stringConverters = new HashMap();
        bytesConverters = new HashMap();
        packedDecimalConverters = new HashMap();
        zonedDecimalConverters = new HashMap();
    }

    public JSONConversionVisitor() {
    }

    public JSONConversionVisitor(String defaultStringEncoding) {
        this.defaultStringEncoding = defaultStringEncoding;
    }

    public TypeConverterWrapper getTypeConverter(FieldType field) {
        DatatypeType fieldDatatype = field.getApplicationDatatype().getDatatype();
        TypeConverterWrapper typeConverter = typeConverters.get((Object)fieldDatatype);
        if (typeConverter != null) {
            return typeConverter;
        }
        MarshallerType fieldMarshaller = field.getMarshaller();
        switch (fieldDatatype) {
            case CHAR: {
                String format;
                String stringEncoding = null;
                YesnoType isDBCSOnly = null;
                if (fieldMarshaller != null) {
                    stringEncoding = fieldMarshaller.getEncoding();
                    isDBCSOnly = fieldMarshaller.getIsDBCSOnly();
                }
                if (stringEncoding == null) {
                    stringEncoding = this.defaultStringEncoding;
                }
                if (isDBCSOnly == null) {
                    isDBCSOnly = YesnoType.N;
                }
                if ((typeConverter = stringConverters.get(format = stringEncoding + "." + String.valueOf((Object)isDBCSOnly))) != null) break;
                typeConverter = new TypeConverterWrapper(new StringConverter2(stringEncoding), String.valueOf(" "), String.class);
                if (isDBCSOnly == YesnoType.Y) {
                    ((StringConverter2)typeConverter.getTypeConverter()).setDBCSOnly(true);
                }
                stringConverters.put(format, typeConverter);
                break;
            }
            case DECIMAL: {
                ApplicationDatatypeType adt = field.getApplicationDatatype();
                Integer scale = adt.getScale();
                Integer precision = adt.getPrecision();
                YesnoType isSignedYN = fieldMarshaller.getIsSigned();
                boolean isSigned = isSignedYN != null ? isSignedYN == YesnoType.Y : false;
                String format = String.valueOf(scale) + "." + String.valueOf(precision) + "." + isSigned;
                switch (fieldMarshaller.getTypeConverter()) {
                    case PACKEDDECIMAL: {
                        typeConverter = packedDecimalConverters.get(format);
                        if (typeConverter != null) break;
                        typeConverter = new TypeConverterWrapper((BaseTypeConverter)new PackedDecimalConverter(scale, precision, isSigned), BigDecimal.ZERO, BigDecimal.class);
                        packedDecimalConverters.put(format, typeConverter);
                        break;
                    }
                    case ZONEDDECIMAL: {
                        YesnoType isSignLeadingYN = fieldMarshaller.getIsSignLeading();
                        boolean isSignLeading = isSignLeadingYN != null ? isSignLeadingYN == YesnoType.Y : false;
                        format = format + "." + isSignLeading;
                        YesnoType isSignSeparateYN = fieldMarshaller.getIsSignSeparate();
                        boolean isSignSeparate = isSignSeparateYN != null ? isSignSeparateYN == YesnoType.Y : false;
                        format = format + "." + isSignSeparate;
                        YesnoType isWCHAROnlyYN = fieldMarshaller.getIsWCHAROnly();
                        boolean isWCHAROnly = isWCHAROnlyYN != null ? isWCHAROnlyYN == YesnoType.Y : false;
                        format = format + "." + isWCHAROnly;
                        typeConverter = zonedDecimalConverters.get(format);
                        if (typeConverter != null) break;
                        typeConverter = new TypeConverterWrapper(new ZonedDecimalConverter2(scale, precision, isSigned, isSignLeading, isSignSeparate, isWCHAROnly), BigDecimal.ZERO, BigDecimal.class);
                        zonedDecimalConverters.put(format, typeConverter);
                        break;
                    }
                    case BINARY: {
                        typeConverter = bytesConverters.get(format);
                        if (typeConverter != null) break;
                        typeConverter = new TypeConverterWrapper((BaseTypeConverter)new BytesConverter(scale, precision, isSigned), BigDecimal.ZERO, BigDecimal.class);
                        bytesConverters.put(format, typeConverter);
                    }
                }
                break;
            }
        }
        return typeConverter;
    }

    public abstract int getVariableArrayOccurrenceCount(FieldType var1) throws MessageWalkerException;

    public HashMap<String, Object> getDependingOnComposite(String dependingOnFieldName, Stack<HashMap<String, Object>> compositeNodeStack) {
        HashMap retVal = null;
        int topIx = compositeNodeStack.size();
        int i = topIx - 1;
        while (i >= 0) {
            HashMap currCompositeNode = (HashMap)compositeNodeStack.get(i);
            Object numArrayElementsObj = currCompositeNode.get(dependingOnFieldName);
            if (numArrayElementsObj != null) {
                retVal = currCompositeNode;
                break;
            }
            --i;
        }
        if (retVal == null) {
            retVal = this.getCompositeContainingField(dependingOnFieldName, (HashMap)compositeNodeStack.get(0));
        }
        return retVal;
    }

    public HashMap<String, Object> getCompositeContainingField(String fieldName, HashMap<String, Object> composite) {
        HashMap<String, Object> retVal = null;
        if (composite.get(fieldName) != null) {
            return composite;
        }
        for (Object currObj : composite.values()) {
            if (currObj instanceof HashMap && (retVal = this.getCompositeContainingField(fieldName, (HashMap)currObj)) != null) break;
        }
        return retVal;
    }

    public static int getSlackByteCount(FieldType field, int offset) {
        MarshallerType marshaller = field.getMarshaller();
        if (marshaller == null || marshaller.getAlignment() == null) {
            return 0;
        }
        AlignmentType fieldAlignment = marshaller.getAlignment();
        int slackByteCnt = 0;
        int r = 0;
        switch (fieldAlignment) {
            case HALFWORD: {
                slackByteCnt = offset > 0 ? ((r = offset % 2) > 0 ? 2 - r : 0) : 0;
                break;
            }
            case FULLWORD: {
                slackByteCnt = offset > 0 ? ((r = offset % 4) > 0 ? 4 - r : 0) : 0;
                break;
            }
            case DOUBLEWORD: {
                slackByteCnt = offset > 0 ? ((r = offset % 8) > 0 ? 8 - r : 0) : 0;
                break;
            }
        }
        return slackByteCnt;
    }

    public static Boolean isTrue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    public static Object stripMachineControlChars(Object objVal) {
        String value = (String)objVal;
        StringBuilder retVal = new StringBuilder(value.length() + 1);
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            char codepoint = character;
            if (!(codepoint >= '\u0000' && codepoint <= '\b' || codepoint >= '\u000b' && codepoint <= '\f' || codepoint >= '\u000e' && codepoint <= '\u001f' || codepoint >= '\u007f' && codepoint <= '\u0084' || codepoint >= '\u0086' && codepoint <= '\u009f')) {
                retVal.append(character);
            }
            ++i;
        }
        return retVal.toString();
    }

    public static Object trimLeadingWhitespaceChars(Object objVal) {
        boolean inWhitespace = true;
        String value = (String)objVal;
        int startPos = 0;
        if (value.length() > 0) {
            while (startPos < value.length() && inWhitespace) {
                inWhitespace = Character.isWhitespace(value.charAt(startPos));
                ++startPos;
            }
            return value.substring(startPos - 1);
        }
        return objVal;
    }

    public static Object trimTrailingWhitespaceChars(Object objVal) {
        boolean inWhitespace = true;
        String value = (String)objVal;
        int endPos = value.length() - 1;
        while (endPos >= 0 && inWhitespace) {
            inWhitespace = Character.isWhitespace(value.charAt(endPos));
            if (!inWhitespace) {
                ++endPos;
            }
            --endPos;
        }
        return value.substring(0, endPos + 1);
    }

    public static boolean allBytesEqual(byte[] byteBuffer, int byteOffset, int byteCount, int byteValue) {
        boolean allEqualTo = true;
        int endOffset = byteOffset + byteCount;
        int i = byteOffset;
        while (i < endOffset && allEqualTo) {
            if ((byteBuffer[i] & 0xFF) != byteValue) {
                allEqualTo = false;
            }
            ++i;
        }
        return allEqualTo;
    }

    public void validateFieldCanHaveZeroElements(FieldType field, FieldPath fieldPath) throws MessageWalkerException {
    }
}

