/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import java.math.BigDecimal;
import java.math.BigInteger;

public class JSONConversionUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final BigInteger LONG_MAX_VALUE_BIGINT = new BigInteger(String.valueOf(Long.MAX_VALUE));
    private static final BigInteger LONG_MIN_VALUE_BIGINT = new BigInteger(String.valueOf(Long.MIN_VALUE));
    private static final BigDecimal LONG_MAX_VALUE_BIGDEC = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE_BIGDEC = new BigDecimal(Long.MIN_VALUE);

    public static Object subWithStringIfNotInRangeOfLong(Object value) {
        Object retVal = value;
        if (value instanceof Number && !JSONConversionUtil.isInRangeOfLong(value)) {
            retVal = JSONConversionUtil.getAsString((Number)value);
        }
        return retVal;
    }

    public static boolean isInRangeOfLong(Object value) {
        if (value == null) {
            return false;
        }
        boolean retVal = false;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            retVal = true;
        } else if (value instanceof Float) {
            retVal = JSONConversionUtil.isInRangeOfLong((Float)value);
        } else if (value instanceof Double) {
            retVal = JSONConversionUtil.isInRangeOfLong((Double)value);
        } else if (value instanceof BigInteger) {
            retVal = JSONConversionUtil.isInRangeOfLong((BigInteger)value);
        } else if (value instanceof BigDecimal) {
            retVal = JSONConversionUtil.isInRangeOfLong((BigDecimal)value);
        } else if (value instanceof String) {
            retVal = JSONConversionUtil.isInRangeOfLong((String)value);
        }
        return retVal;
    }

    private static boolean isInRangeOfLong(BigInteger value) {
        boolean retVal = false;
        if (value != null && value.compareTo(LONG_MIN_VALUE_BIGINT) >= 0 && value.compareTo(LONG_MAX_VALUE_BIGINT) <= 0) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isInRangeOfLong(BigDecimal value) {
        boolean retVal = false;
        if (value != null && value.compareTo(LONG_MIN_VALUE_BIGDEC) >= 0 && value.compareTo(LONG_MAX_VALUE_BIGDEC) <= 0) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isInRangeOfLong(Float value) {
        boolean retVal = false;
        if (value != null && value.compareTo(Float.valueOf(LONG_MIN_VALUE_BIGDEC.floatValue())) >= 0 && value.compareTo(Float.valueOf(LONG_MAX_VALUE_BIGDEC.floatValue())) <= 0) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isInRangeOfLong(Double value) {
        boolean retVal = false;
        if (value != null && value.compareTo(LONG_MIN_VALUE_BIGDEC.doubleValue()) >= 0 && value.compareTo(LONG_MAX_VALUE_BIGDEC.doubleValue()) <= 0) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isInRangeOfLong(String value) {
        boolean retVal = false;
        if (value != null) {
            try {
                Long.parseLong(value);
                retVal = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return retVal;
    }

    public static String getAsString(Number value) {
        if (value == null) {
            return "";
        }
        String retVal = "";
        if (value instanceof Long) {
            retVal = ((Long)value).toString();
        } else if (value instanceof Integer) {
            retVal = ((Integer)value).toString();
        } else if (value instanceof Short) {
            retVal = ((Short)value).toString();
        } else if (value instanceof Byte) {
            retVal = ((Byte)value).toString();
        } else if (value instanceof Float) {
            retVal = ((Float)value).toString();
        } else if (value instanceof Double) {
            retVal = ((Double)value).toString();
        } else if (value instanceof BigInteger) {
            retVal = ((BigInteger)value).toString();
        } else if (value instanceof BigDecimal) {
            retVal = ((BigDecimal)value).toPlainString();
        }
        return retVal;
    }
}

