/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class FieldPath
implements Cloneable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Stack<String> segmentStack = new Stack();

    public FieldPath() {
    }

    public FieldPath(String path) {
        String[] stringArray = path.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.push(segment);
            ++n2;
        }
    }

    private FieldPath(Stack<String> segmentStack) {
        this.segmentStack = segmentStack;
    }

    public List<String> getSegments() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.segmentStack) {
            result.add(0, s);
        }
        return result;
    }

    public String getValue() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.segmentStack.size()) {
            String segment = (String)this.segmentStack.get(i);
            result.append(segment);
            if (++i >= this.segmentStack.size()) continue;
            result.append(".");
        }
        return result.toString();
    }

    public String toString() {
        return this.getValue();
    }

    public void push(String segment) {
        this.segmentStack.push(segment);
    }

    public String pop() {
        if (!this.segmentStack.isEmpty()) {
            return this.segmentStack.pop();
        }
        return null;
    }

    public String peek() {
        if (!this.segmentStack.isEmpty()) {
            return this.segmentStack.peek();
        }
        return null;
    }

    public String bottom() {
        if (!this.segmentStack.isEmpty()) {
            return (String)this.segmentStack.firstElement();
        }
        return null;
    }

    public int getDepth() {
        return this.segmentStack.size();
    }

    public FieldPath clone() {
        Stack<String> cloneStack = new Stack<String>();
        for (String segment : this.segmentStack) {
            cloneStack.push(new String(segment));
        }
        return new FieldPath(cloneStack);
    }

    public Stack<String> getSegmentStack() {
        return this.segmentStack;
    }
}

