/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.util.List;
import java.util.Stack;

public class FieldInfoPreservationVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FieldType existingDs;
    private FieldType newDs;

    public FieldInfoPreservationVisitor(FieldType existingDs, FieldType newDs) {
        this.existingDs = existingDs;
        this.newDs = newDs;
    }

    @Override
    public boolean isExpandArrays() {
        return false;
    }

    @Override
    public Object startOfMessageType(MessageType message, Object state) {
        return state;
    }

    @Override
    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    @Override
    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field, fieldPath);
        return state;
    }

    private void doFieldInfoPreservation(FieldType field, FieldPath fieldPath) {
        FieldType matchingNewField;
        String remarksStr;
        String nameStr = field.getName();
        String origNameStr = field.getOriginalName();
        boolean needToFindNewFld = false;
        if (nameStr != null & origNameStr != null && !nameStr.equals(origNameStr)) {
            needToFindNewFld = true;
        }
        if ((remarksStr = field.getRemarks()) != null && !remarksStr.isEmpty()) {
            needToFindNewFld = true;
        }
        if (needToFindNewFld && (matchingNewField = this.getMatchingField(field, fieldPath)) != null) {
            matchingNewField.setName(nameStr);
            matchingNewField.setRemarks(remarksStr);
        }
    }

    private FieldType getMatchingField(FieldType existingFld, FieldPath fieldPath) {
        FieldType retVal = null;
        Stack<String> pathStack = fieldPath.getSegmentStack();
        int size = pathStack.size();
        if (size > 1) {
            FieldType currExistingField = this.existingDs;
            FieldType currNewField = this.newDs;
            FieldType matchingExistingChild = null;
            FieldType matchingNewChild = null;
            int i = 1;
            while (i < size - 1) {
                String currPathSeg = (String)pathStack.get(i);
                matchingExistingChild = this.getMatchingChildField(currExistingField, currPathSeg, false);
                matchingNewChild = this.getMatchingChildField(currNewField, matchingExistingChild.getOriginalName(), true);
                if (matchingNewChild == null) {
                    currNewField = null;
                    break;
                }
                currExistingField = matchingExistingChild;
                currNewField = matchingNewChild;
                matchingNewChild = null;
                ++i;
            }
            if (currNewField != null) {
                retVal = this.getMatchingChildField(currNewField, existingFld.getOriginalName(), true);
            }
        }
        return retVal;
    }

    private FieldType getMatchingChildField(FieldType parentField, String nameToMatch, boolean matchOrigName) {
        FieldType retVal = null;
        List<FieldType> childList = parentField.getField();
        int i = 0;
        while (i < childList.size()) {
            FieldType currField = childList.get(i);
            String currFieldName = null;
            currFieldName = matchOrigName ? currField.getOriginalName() : currField.getName();
            if (currFieldName.equalsIgnoreCase(nameToMatch)) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    @Override
    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType arrayParentField = fieldParents.peek();
        this.doFieldInfoPreservation(arrayParentField, fieldPath);
        return state;
    }

    @Override
    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field, fieldPath);
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field, fieldPath);
        return state;
    }

    @Override
    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    @Override
    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    @Override
    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    @Override
    public int getVariableArrayOccurrenceCount(FieldType dynArrayField) {
        int retVal = -1;
        return retVal;
    }
}

