/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.im.ims.metadata.message.overlay.InterfaceFieldType;
import com.ibm.im.ims.metadata.message.overlay.MessageInterfaceType;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.im.ims.metadata.message.overlay.YesnoType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.ims.dli.types.BaseTypeConverter;
import com.ibm.ims.transaction.messages.walkers.ByteArrayToJSONOptions;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.JSONConversionUtil;
import com.ibm.ims.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalker;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.messages.walkers.TypeConverterWrapper;
import com.ibm.ims.transaction.tools.TransactionToolsLogger;
import com.ibm.ims.transaction.tools.messages.MessageBundles;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;

public class ByteArrayToJSONVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final TransactionToolsLogger logger = new TransactionToolsLogger();
    private ByteArrayToJSONOptions options = new ByteArrayToJSONOptions();
    private int byteBufferStartOffset;
    private JsonObjectRef rootJsonObject;
    private Stack<JsonObjectRef> jsonObjectStack;
    private MessageType message;
    private Stack<FieldType> prevFieldStack;
    private Stack<Integer> redefinesGroupFieldMaxSizeStack;
    private HashMap<String, FieldType> fieldPathToFieldType;
    private Stack<Integer> compositeArrayStartOffsetStack;
    byte[] byteBuffer;
    int byteOffset;
    int segmentStartOffset;
    int segmentEndOffset;
    int segmentCount;
    private InterfaceFieldType currParentInterfaceField;
    private Stack<InterfaceFieldType> parentInterfaceFieldStack;
    private Stack<Integer> interfaceFieldIxStack = new Stack();
    private MessageInterfaceType msgInterface;
    private ServiceInterfaceSegmentType currInterfaceSegment;
    private int segmentIx = -1;

    public ByteArrayToJSONVisitor(byte[] byteBuffer, String defaultStringEncoding, MessageInterfaceType msgInterface) {
        this(byteBuffer, 0, defaultStringEncoding, msgInterface);
    }

    public ByteArrayToJSONVisitor(byte[] byteBuffer, int byteBufferStartOffset, String defaultStringEncoding, MessageInterfaceType msgInterface) {
        super(defaultStringEncoding);
        this.byteBuffer = byteBuffer;
        this.byteBufferStartOffset = byteBufferStartOffset;
        this.jsonObjectStack = new Stack();
        this.redefinesGroupFieldMaxSizeStack = new Stack();
        this.prevFieldStack = new Stack();
        this.msgInterface = msgInterface;
        this.fieldPathToFieldType = new HashMap();
        this.parentInterfaceFieldStack = new Stack();
        this.compositeArrayStartOffsetStack = new Stack();
    }

    @Override
    public boolean isExpandArrays() {
        return true;
    }

    @Override
    public Object startOfMessageType(MessageType message, Object state) {
        this.message = message;
        this.jsonObjectStack.clear();
        this.rootJsonObject = new JsonObjectRef();
        this.jsonObjectStack.push(this.rootJsonObject);
        this.byteOffset = this.byteBufferStartOffset >= 0 && this.byteBufferStartOffset < this.byteBuffer.length ? this.byteBufferStartOffset : 0;
        if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
            int offset = this.byteOffset + 1;
            logger.finer("Starting to walk the message \"" + message.getName() + "\" with the Visitor byteOffset: " + offset, new Object[0]);
        }
        this.interfaceFieldIxStack.clear();
        this.segmentIx = -1;
        return state;
    }

    @Override
    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.segmentStartOffset = this.byteOffset;
        this.segmentEndOffset = this.byteOffset;
        ++this.segmentCount;
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        ++this.segmentIx;
        this.currInterfaceSegment = this.msgInterface.getSegment().get(this.segmentIx);
        this.interfaceFieldIxStack.push(-1);
        return state;
    }

    @Override
    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        if (ByteArrayToJSONVisitor.isTrue(field.isDependedOn()).booleanValue()) {
            this.fieldPathToFieldType.put(fieldPath.getValue(), field);
        }
        if (redefines) {
            int redefinesGroupFieldMaxSize;
            block61: {
                int currFieldSize = field.getBytes();
                redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
                if (redefinesGroupFieldMaxSize == 0) {
                    redefinesGroupFieldMaxSize = this.prevFieldStack.peek().getBytes();
                    this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
                }
                this.byteOffset -= redefinesGroupFieldMaxSize;
                if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                    int offset = this.byteOffset + 1;
                    logger.finer("At leaf field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
                }
                this.segmentEndOffset -= redefinesGroupFieldMaxSize;
                if (currFieldSize > redefinesGroupFieldMaxSize) {
                    redefinesGroupFieldMaxSize = currFieldSize;
                    this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
                }
                try {
                    if (currInterfaceField.getIncluded() == YesnoType.Y && !ByteArrayToJSONVisitor.isTrue(field.isDependedOn()).booleanValue()) {
                        int stackTopIndex;
                        TypeConverterWrapper converterWrapper = this.getTypeConverter(field);
                        BaseTypeConverter converter = converterWrapper.getTypeConverter();
                        Class<?> clazz = converterWrapper.getDataClass();
                        if (!this.compositeArrayStartOffsetStack.isEmpty() && (Integer)this.compositeArrayStartOffsetStack.get(stackTopIndex = this.compositeArrayStartOffsetStack.size() - 1) == 0) {
                            this.compositeArrayStartOffsetStack.set(stackTopIndex, this.byteOffset - this.segmentStartOffset);
                        }
                        boolean omitField = false;
                        int omitByteValue = this.options.getOmitOutputFieldsByValueByte();
                        int bufferLen = this.byteBuffer.length;
                        Object readValue = null;
                        if (this.byteOffset + currFieldSize <= bufferLen) {
                            if (this.options.isOmitOutputFieldsByValue() && converterWrapper.isStringType() && ByteArrayToJSONVisitor.allBytesEqual(this.byteBuffer, this.byteOffset, currFieldSize, omitByteValue)) {
                                omitField = true;
                            } else {
                                Integer startPos = field.getStartPos();
                                if (startPos != null && this.byteOffset != startPos - 1) {
                                    int offset = this.byteOffset + 1;
                                    logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                                } else if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                    int offset = this.byteOffset + 1;
                                    logger.finer("Reading field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                                }
                                readValue = converter.readObject(this.byteBuffer, this.byteOffset, currFieldSize, clazz, null);
                            }
                        } else {
                            int availBufferLength = bufferLen - this.byteOffset;
                            if (availBufferLength > 0) {
                                if (this.options.isOmitOutputFieldsByValue() && converterWrapper.isStringType() && ByteArrayToJSONVisitor.allBytesEqual(this.byteBuffer, this.byteOffset, availBufferLength, omitByteValue)) {
                                    omitField = true;
                                } else {
                                    Integer startPos = field.getStartPos();
                                    if (startPos != null && this.byteOffset != startPos - 1) {
                                        offset = this.byteOffset + 1;
                                        logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                                    } else if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                        offset = this.byteOffset + 1;
                                        logger.finer("Reading field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                                    }
                                    readValue = converter.readObject(this.byteBuffer, this.byteOffset, availBufferLength, clazz, null);
                                }
                            }
                            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                String subMsg = MessageBundles.getMessage(MessageBundles.MW.MW0006E, fieldPath.getValue(), this.message.getName());
                                String fullMsg = MessageBundles.getMessage(MessageBundles.MW.MW0005E, subMsg);
                                logger.finer(fullMsg, new Object[0]);
                            }
                        }
                        if (!omitField) {
                            if (readValue instanceof String) {
                                if (!this.options.isEscapeOutputControlCharacters()) {
                                    readValue = ByteArrayToJSONVisitor.stripMachineControlChars(readValue);
                                }
                                if (this.options.isTrimOutputLeadingWhitespace()) {
                                    readValue = ByteArrayToJSONVisitor.trimLeadingWhitespaceChars(readValue);
                                }
                                if (this.options.isTrimOutputTrailingWhitespace()) {
                                    readValue = ByteArrayToJSONVisitor.trimTrailingWhitespaceChars(readValue);
                                }
                            } else {
                                readValue = JSONConversionUtil.subWithStringIfNotInRangeOfLong(readValue);
                            }
                            if (this.options.isOmitOutputEmptyTags() && (readValue == null || readValue instanceof String && ((String)readValue).isEmpty())) {
                                omitField = true;
                            }
                        }
                        if (!omitField) {
                            JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
                            parentJsonObject.ref.put((Object)field.getName(), readValue);
                            ++parentJsonObject.refCnt;
                        }
                    }
                }
                catch (Exception e) {
                    if (!ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.WARNING)) break block61;
                    MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(fieldPath.getValue(), this.message.getName(), e.getMessage()).build();
                    logger.warn(walkerException.getMessage(), walkerException);
                }
            }
            this.byteOffset += redefinesGroupFieldMaxSize;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leafField \"" + field.getName() + "\" bumping byteOffset forward by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because this field is part of a redefines group and the next field will start after the biggest field of this group.", new Object[0]);
            }
            this.segmentEndOffset += redefinesGroupFieldMaxSize;
        } else {
            Integer fieldBytes;
            block62: {
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, 0);
                fieldBytes = field.getBytes();
                try {
                    int stackTopIndex;
                    int slackBytes = ByteArrayToJSONVisitor.getSlackByteCount(field, this.byteOffset - this.segmentStartOffset);
                    this.byteOffset += slackBytes;
                    if (slackBytes > 0 && ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                        int offset = this.byteOffset + 1;
                        logger.finer("For field \"" + field.getName() + "\" byteOffset is being bumped forward by slackBytes: " + slackBytes + " to: " + offset + " because the field is numeric and aligned.", new Object[0]);
                    }
                    this.segmentEndOffset += slackBytes;
                    if (!this.compositeArrayStartOffsetStack.isEmpty() && (Integer)this.compositeArrayStartOffsetStack.get(stackTopIndex = this.compositeArrayStartOffsetStack.size() - 1) == 0) {
                        this.compositeArrayStartOffsetStack.set(stackTopIndex, this.byteOffset - this.segmentStartOffset);
                    }
                    if (currInterfaceField.getIncluded() == YesnoType.Y && !ByteArrayToJSONVisitor.isTrue(field.isDependedOn()).booleanValue()) {
                        TypeConverterWrapper converterWrapper = this.getTypeConverter(field);
                        BaseTypeConverter converter = converterWrapper.getTypeConverter();
                        Class<?> clazz = converterWrapper.getDataClass();
                        boolean omitField = false;
                        int omitByteValue = this.options.getOmitOutputFieldsByValueByte();
                        Object readValue = null;
                        int bufferLen = this.byteBuffer.length;
                        if (this.byteOffset + fieldBytes <= bufferLen) {
                            if (this.options.isOmitOutputFieldsByValue() && converterWrapper.isStringType() && ByteArrayToJSONVisitor.allBytesEqual(this.byteBuffer, this.byteOffset, fieldBytes, omitByteValue)) {
                                omitField = true;
                            } else {
                                Integer startPos = field.getStartPos();
                                if (startPos != null && this.byteOffset != startPos - 1) {
                                    int offset = this.byteOffset + 1;
                                    logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                                } else if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                    int offset = this.byteOffset + 1;
                                    logger.finer("Reading field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                                }
                                readValue = converter.readObject(this.byteBuffer, this.byteOffset, fieldBytes.intValue(), clazz, null);
                            }
                        } else {
                            int availBufferLength = bufferLen - this.byteOffset;
                            if (availBufferLength > 0) {
                                if (this.options.isOmitOutputFieldsByValue() && converterWrapper.isStringType() && ByteArrayToJSONVisitor.allBytesEqual(this.byteBuffer, this.byteOffset, availBufferLength, omitByteValue)) {
                                    omitField = true;
                                } else {
                                    Integer startPos = field.getStartPos();
                                    if (startPos != null && this.byteOffset != startPos - 1) {
                                        offset = this.byteOffset + 1;
                                        logger.finer("Visitor/Metadata offset mismatch for field \"" + field.getName() + "\". Visitor byteOffset: " + offset + " Metadata startPos: " + String.valueOf(field.getStartPos()), new Object[0]);
                                    } else if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                        offset = this.byteOffset + 1;
                                        logger.finer("Reading field \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                                    }
                                    readValue = converter.readObject(this.byteBuffer, this.byteOffset, availBufferLength, clazz, null);
                                }
                            }
                            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                String subMsg = MessageBundles.getMessage(MessageBundles.MW.MW0006E, fieldPath.getValue(), this.message.getName());
                                String fullMsg = MessageBundles.getMessage(MessageBundles.MW.MW0005E, subMsg);
                                logger.finer(fullMsg, new Object[0]);
                            }
                        }
                        if (!omitField) {
                            if (readValue instanceof String) {
                                if (!this.options.isEscapeOutputControlCharacters()) {
                                    readValue = ByteArrayToJSONVisitor.stripMachineControlChars(readValue);
                                }
                                if (this.options.isTrimOutputLeadingWhitespace()) {
                                    readValue = ByteArrayToJSONVisitor.trimLeadingWhitespaceChars(readValue);
                                }
                                if (this.options.isTrimOutputTrailingWhitespace()) {
                                    readValue = ByteArrayToJSONVisitor.trimTrailingWhitespaceChars(readValue);
                                }
                            } else {
                                readValue = JSONConversionUtil.subWithStringIfNotInRangeOfLong(readValue);
                            }
                            if (this.options.isOmitOutputEmptyTags() && (readValue == null || readValue instanceof String && ((String)readValue).isEmpty())) {
                                omitField = true;
                            }
                        }
                        if (!omitField) {
                            JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
                            parentJsonObject.ref.put((Object)field.getName(), readValue);
                            ++parentJsonObject.refCnt;
                        }
                    }
                }
                catch (Exception e) {
                    if (!ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.WARNING)) break block62;
                    MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0005E).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(fieldPath.getValue(), this.message.getName(), e.getMessage()).build();
                    logger.warn(walkerException.getMessage());
                }
            }
            this.byteOffset += fieldBytes.intValue();
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leafField \"" + field.getName() + "\" bumping byteOffset forward by: " + String.valueOf(fieldBytes) + " to: " + offset + " to account for the size of this field.", new Object[0]);
            }
            this.segmentEndOffset += fieldBytes.intValue();
        }
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        return state;
    }

    @Override
    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        int stackTopIndex;
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        JSONArray leafArrayList = new JSONArray();
        FieldType parentField = fieldParents.peek();
        int maxOccurs = 0;
        maxOccurs = MessageWalker.isVariableLengthArray(parentField) ? this.getVariableArrayOccurrenceCount(parentField) : parentField.getMaxOccurs().intValue();
        int currFieldCellSize = field.getBytes();
        int currFieldRowSize = currFieldCellSize * maxOccurs;
        int currFieldRowRemain = 0;
        if (redefines) {
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = this.prevFieldStack.peek().getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                offset = this.byteOffset + 1;
                logger.finer("At leafArrayField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
            }
            this.segmentEndOffset -= redefinesGroupFieldMaxSize;
            if (currFieldRowSize > redefinesGroupFieldMaxSize) {
                redefinesGroupFieldMaxSize = currFieldRowSize;
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            currFieldRowRemain = redefinesGroupFieldMaxSize;
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, 0);
            currFieldRowRemain = currFieldRowSize;
            int slackBytes = ByteArrayToJSONVisitor.getSlackByteCount(field, this.byteOffset - this.segmentStartOffset);
            this.byteOffset += slackBytes;
            if (slackBytes > 0 && ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                offset = this.byteOffset + 1;
                logger.finer("For field \"" + field.getName() + "\" byteOffset is being bumped forward by slackBytes: " + slackBytes + " to: " + offset + " because the field is numeric and aligned.", new Object[0]);
            }
            this.segmentEndOffset += slackBytes;
        }
        if (!this.compositeArrayStartOffsetStack.isEmpty() && (Integer)this.compositeArrayStartOffsetStack.get(stackTopIndex = this.compositeArrayStartOffsetStack.size() - 1) == 0) {
            this.compositeArrayStartOffsetStack.set(stackTopIndex, this.byteOffset - this.segmentStartOffset);
        }
        TypeConverterWrapper converterWrapper = this.getTypeConverter(field);
        Class<?> clazz = converterWrapper.getDataClass();
        BaseTypeConverter converter = converterWrapper.getTypeConverter();
        boolean omitField = false;
        int omitByteValue = this.options.getOmitOutputFieldsByValueByte();
        int omittedFieldCount = 0;
        int index = 0;
        while (index < maxOccurs) {
            block33: {
                try {
                    Object readValue = null;
                    if (currInterfaceField.getIncluded() == YesnoType.Y) {
                        int bufferLen = this.byteBuffer.length;
                        if (this.byteOffset + currFieldCellSize <= bufferLen) {
                            if (this.options.isOmitOutputFieldsByValue() && converterWrapper.isStringType() && ByteArrayToJSONVisitor.allBytesEqual(this.byteBuffer, this.byteOffset, currFieldCellSize, omitByteValue)) {
                                omitField = true;
                            } else {
                                if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                    int offset = this.byteOffset + 1;
                                    logger.finer("Reading leafArrayfield \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                                }
                                readValue = converter.readObject(this.byteBuffer, this.byteOffset, currFieldCellSize, clazz, null);
                            }
                        } else {
                            int availBufferLength = bufferLen - this.byteOffset;
                            if (availBufferLength > 0) {
                                if (this.options.isOmitOutputFieldsByValue() && converterWrapper.isStringType() && ByteArrayToJSONVisitor.allBytesEqual(this.byteBuffer, this.byteOffset, availBufferLength, omitByteValue)) {
                                    omitField = true;
                                } else {
                                    if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                        int offset = this.byteOffset + 1;
                                        logger.finer("Reading leafArrayfield \"" + field.getName() + "\" at offset: " + offset, new Object[0]);
                                    }
                                    readValue = converter.readObject(this.byteBuffer, this.byteOffset, availBufferLength, clazz, null);
                                }
                            }
                            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                                String subMsg = MessageBundles.getMessage(MessageBundles.MW.MW0006E, fieldPath.getValue(), this.message.getName());
                                String fullMsg = MessageBundles.getMessage(MessageBundles.MW.MW0005E, subMsg);
                                logger.finer(fullMsg, new Object[0]);
                            }
                        }
                        if (!omitField) {
                            if (readValue instanceof String) {
                                if (!this.options.isEscapeOutputControlCharacters()) {
                                    readValue = ByteArrayToJSONVisitor.stripMachineControlChars(readValue);
                                }
                                if (this.options.isTrimOutputLeadingWhitespace()) {
                                    readValue = ByteArrayToJSONVisitor.trimLeadingWhitespaceChars(readValue);
                                }
                                if (this.options.isTrimOutputTrailingWhitespace()) {
                                    readValue = ByteArrayToJSONVisitor.trimTrailingWhitespaceChars(readValue);
                                }
                            } else {
                                readValue = JSONConversionUtil.subWithStringIfNotInRangeOfLong(readValue);
                            }
                            if (this.options.isOmitOutputEmptyTags() && (readValue == null || readValue instanceof String && ((String)readValue).isEmpty())) {
                                omitField = true;
                            }
                        }
                        if (!omitField) {
                            leafArrayList.add(readValue);
                        } else {
                            ++omittedFieldCount;
                        }
                    }
                }
                catch (Exception e) {
                    if (!ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.WARNING)) break block33;
                    MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0005E).message(MessageBundles.getMessage(MessageBundles.MW.MW0005E)).args(fieldPath.getValue(), this.message.getName(), e.getMessage()).build();
                    logger.warn(walkerException.getMessage());
                }
            }
            this.byteOffset += currFieldCellSize;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At leafArrayfield for field \"" + field.getName() + "\" bumping offset forward by: " + currFieldCellSize + " to: " + offset + " to move forward for the next array cell.", new Object[0]);
            }
            currFieldRowRemain -= currFieldCellSize;
            ++index;
        }
        if (currInterfaceField.getIncluded() == YesnoType.Y && omittedFieldCount < maxOccurs) {
            JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
            parentJsonObject.ref.put((Object)fieldPath.peek(), (Object)leafArrayList);
            ++parentJsonObject.refCnt;
        }
        this.byteOffset += currFieldRowRemain;
        if (currFieldRowRemain > 0 && ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
            int offset = this.byteOffset + 1;
            logger.finer("At leafArrayfield for field \"" + field.getName() + "\" bumping offset forward by: " + currFieldRowRemain + " to: " + offset + " because last cell processed and some room remained for this array.", new Object[0]);
        }
        this.segmentEndOffset += currFieldRowRemain;
        currFieldRowRemain = 0;
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        return state;
    }

    @Override
    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currField = null;
        currField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        JSONObject composite = new JSONObject();
        JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
        parentJsonObject.ref.put((Object)field.getName(), (Object)composite);
        ++parentJsonObject.refCnt;
        this.jsonObjectStack.push(new JsonObjectRef(composite));
        int compositeFieldStackPos = this.redefinesGroupFieldMaxSizeStack.size() - 1;
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = (Integer)this.redefinesGroupFieldMaxSizeStack.elementAt(compositeFieldStackPos);
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = ((FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos)).getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At startOfCompositeField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
            }
            this.segmentEndOffset -= redefinesGroupFieldMaxSize;
            if (currFieldSize > redefinesGroupFieldMaxSize) {
                redefinesGroupFieldMaxSize = currFieldSize;
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, 0);
        }
        this.prevFieldStack.set(compositeFieldStackPos, field);
        return state;
    }

    @Override
    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        JSONArray compositeArray = null;
        JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
        compositeArray = (JSONArray)this.jsonObjectStack.peek().ref.get((Object)field.getName());
        if (compositeArray == null) {
            compositeArray = new JSONArray();
            parentJsonObject.ref.put((Object)field.getName(), (Object)compositeArray);
            ++parentJsonObject.refCnt;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINEST)) {
                ByteArrayToJSONVisitor.logger.logger.finest("startOfCompositeArrayField: field=" + field.getName() + " compositeArray is NULL. index: " + index);
            }
        } else if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINEST)) {
            ByteArrayToJSONVisitor.logger.logger.finest("startOfCompositeArrayField: field=" + field.getName() + " compositeArray is not NULL. index: " + index);
        }
        int arrayIndex = Math.min(compositeArray.size(), index);
        compositeArray.add(arrayIndex, (Object)new JSONObject());
        this.jsonObjectStack.push(new JsonObjectRef((JSONObject)compositeArray.get(arrayIndex)));
        int compositeFieldStackPos = this.redefinesGroupFieldMaxSizeStack.size() - 1;
        FieldType prevField = (FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        if (prevField != field) {
            fieldIx = fieldIx + 1;
            this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        }
        InterfaceFieldType currField = null;
        currField = this.parentInterfaceFieldStack.size() == 0 ? this.currInterfaceSegment.getInterfaceField().get(fieldIx) : this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currField);
        this.currParentInterfaceField = currField;
        this.interfaceFieldIxStack.push(-1);
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        if (redefines) {
            if (index == 0) {
                int currFieldSize = field.getBytes();
                int redefinesGroupFieldMaxSize = (Integer)this.redefinesGroupFieldMaxSizeStack.elementAt(compositeFieldStackPos);
                if (redefinesGroupFieldMaxSize == 0) {
                    redefinesGroupFieldMaxSize = ((FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos)).getBytes();
                    this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
                }
                this.byteOffset -= redefinesGroupFieldMaxSize;
                if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                    int offset = this.byteOffset + 1;
                    logger.finer("At startOfCompositeArrayField for field \"" + field.getName() + "\" byteOffset is set back by: " + redefinesGroupFieldMaxSize + " to: " + offset + " because it's in a redefines group, and we need to reposition to the offset of the group.", new Object[0]);
                }
                this.segmentEndOffset -= redefinesGroupFieldMaxSize;
                if (currFieldSize > redefinesGroupFieldMaxSize) {
                    redefinesGroupFieldMaxSize = currFieldSize;
                    this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
                }
            }
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, 0);
        }
        this.prevFieldStack.set(compositeFieldStackPos, field);
        this.compositeArrayStartOffsetStack.push(0);
        return state;
    }

    @Override
    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        JsonObjectRef compositeJsonObject = this.jsonObjectStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            int difference = 0;
            if (currFieldSize < redefinesGroupFieldMaxSize) {
                difference = redefinesGroupFieldMaxSize - currFieldSize;
            }
            this.byteOffset += difference;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("At endOfCompositeField for field \"" + field.getName() + "\" byteOffset is being bumped forward by: " + difference + " to: " + offset + " because it's in a redefines group.", new Object[0]);
            }
            this.segmentEndOffset += difference;
        }
        if (compositeJsonObject.refCnt == 0) {
            JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
            parentJsonObject.ref.remove((Object)field.getName());
            --parentJsonObject.refCnt;
        }
        return state;
    }

    @Override
    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        JsonObjectRef compositeJsonObject = this.jsonObjectStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            int difference = 0;
            if (currFieldSize < redefinesGroupFieldMaxSize) {
                difference = redefinesGroupFieldMaxSize - currFieldSize;
            }
            this.byteOffset += difference;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.info("At endOfCompositeArrayField for field \"" + field.getName() + "\" byteOffset is being bumped forward by: " + difference + " to: " + offset + " because it's in a redefines group.");
            }
            this.segmentEndOffset += difference;
        } else {
            Integer startOffset = this.compositeArrayStartOffsetStack.peek();
            int endOffset = this.byteOffset - this.segmentStartOffset;
            int groupSize = endOffset - startOffset;
            int slackBytes = ByteArrayToJSONVisitor.getSlackByteCount(field, groupSize);
            this.byteOffset += slackBytes;
            if (slackBytes > 0 && ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
                int offset = this.byteOffset + 1;
                logger.finer("For field \"" + field.getName() + "\" byteOffset is being bumped forward by slackBytes: " + slackBytes + " to: " + offset + " because the field is numeric and aligned.", new Object[0]);
            }
            this.segmentEndOffset += slackBytes;
        }
        this.compositeArrayStartOffsetStack.pop();
        if (compositeJsonObject.refCnt == 0) {
            JsonObjectRef parentJsonObject = this.jsonObjectStack.peek();
            parentJsonObject.ref.remove((Object)field.getName());
            --parentJsonObject.refCnt;
            if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINEST)) {
                ByteArrayToJSONVisitor.logger.logger.finest("endOfCompositeArrayField: array field=" + field.getName() + " : index=" + index + " : No subfields were placed in child composite, so removing list of composites from parent composite.");
            }
        } else if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINEST)) {
            ByteArrayToJSONVisitor.logger.logger.finest("endOfCompositeArrayField: array field=" + field.getName() + " : index=" + index + " : has " + compositeJsonObject.refCnt + " subfields present in child composite");
        }
        return state;
    }

    @Override
    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.interfaceFieldIxStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        return state;
    }

    @Override
    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.currParentInterfaceField = null;
        this.byteOffset = 0;
        if (ByteArrayToJSONVisitor.logger.logger.isLoggable(Level.FINER)) {
            logger.finer("At endOfMessageType for message \"" + message.getName() + "\" byteOffset is being set back to 0.", new Object[0]);
        }
        this.jsonObjectStack.pop();
        return state;
    }

    public HashMap<String, Object> getRootNode() {
        return this.rootJsonObject.ref;
    }

    @Override
    public int getVariableArrayOccurrenceCount(FieldType field) throws MessageWalkerException {
        String dependsOnPath = field.getDependsOnPath();
        if (dependsOnPath == null || dependsOnPath.isEmpty()) {
            return 0;
        }
        FieldType dependsOnField = this.fieldPathToFieldType.get(dependsOnPath);
        if (dependsOnField == null) {
            return 0;
        }
        Integer occurrenceCount = 0;
        TypeConverterWrapper converterWrapper = this.getTypeConverter(dependsOnField);
        BaseTypeConverter converter = converterWrapper.getTypeConverter();
        try {
            int dependsOnFieldOffset = dependsOnField.getStartPos() - 1;
            occurrenceCount = (Integer)converter.readObject(this.byteBuffer, dependsOnFieldOffset += this.segmentStartOffset, dependsOnField.getBytes().intValue(), Integer.class, null);
            occurrenceCount = Math.min(occurrenceCount, field.getMaxOccurs());
        }
        catch (Exception e) {
            MessageWalkerException walkerException = MessageWalkerException.builder().cause(e).messageCode(MessageBundles.MW.MW0014E).message(MessageBundles.getMessage(MessageBundles.MW.MW0014E)).args(dependsOnField.getName(), field.getName(), this.message.getName(), e.getMessage()).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        return occurrenceCount;
    }

    public ByteArrayToJSONOptions getOptions() {
        return this.options;
    }

    public void setOptions(ByteArrayToJSONOptions conversionOptions) {
        this.options = conversionOptions;
    }

    private class JsonObjectRef {
        private JSONObject ref;
        private int refCnt;

        public JsonObjectRef() {
            this.ref = new JSONObject();
            this.refCnt = 0;
        }

        public JsonObjectRef(JSONObject ref) {
            this.ref = ref;
            this.refCnt = 0;
        }
    }
}

