/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages.walkers;

import com.ibm.ims.transaction.messages.walkers.JSONConversionOptions;
import com.ibm.ims.transaction.tools.TransactionToolsLogger;
import java.util.logging.Level;

public class ByteArrayToJSONOptions
extends JSONConversionOptions {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final TransactionToolsLogger logger = new TransactionToolsLogger();
    public static boolean DEFAULT_trimOutputLeadingWhitespace = false;
    public static boolean DEFAULT_trimOutputTrailingWhitespace = true;
    public static boolean DEFAULT_escapeOutputControlCharacters = false;
    public static boolean DEFAULT_omitOutputFieldsByValue = false;
    public static boolean DEFAULT_omitOutputEmptyTags = false;
    public static int DEFAULT_omitOutputFieldsByValueByte = 0;
    private boolean trimOutputLeadingWhitespace = DEFAULT_trimOutputLeadingWhitespace;
    private boolean trimOutputTrailingWhitespace = DEFAULT_trimOutputTrailingWhitespace;
    private boolean escapeOutputControlCharacters = DEFAULT_escapeOutputControlCharacters;
    private boolean omitOutputFieldsByValue = DEFAULT_omitOutputFieldsByValue;
    private boolean omitOutputEmptyTags = DEFAULT_omitOutputEmptyTags;
    private int omitOutputFieldsByValueByte = DEFAULT_omitOutputFieldsByValueByte;

    public boolean isTrimOutputLeadingWhitespace() {
        return this.trimOutputLeadingWhitespace;
    }

    public void setTrimOutputLeadingWhitespace(boolean trimOutputLeadingWhitespace) {
        this.trimOutputLeadingWhitespace = trimOutputLeadingWhitespace;
    }

    public boolean isTrimOutputTrailingWhitespace() {
        return this.trimOutputTrailingWhitespace;
    }

    public void setTrimOutputTrailingWhitespace(boolean trimOutputTrailingWhitespace) {
        this.trimOutputTrailingWhitespace = trimOutputTrailingWhitespace;
    }

    public boolean isEscapeOutputControlCharacters() {
        return this.escapeOutputControlCharacters;
    }

    public void setEscapeOutputControlCharacters(boolean escapeControlCharacters) {
        this.escapeOutputControlCharacters = escapeControlCharacters;
    }

    public boolean isOmitOutputFieldsByValue() {
        return this.omitOutputFieldsByValue;
    }

    public void setOmitOutputFieldsByValue(boolean omitFieldsByValue) {
        this.omitOutputFieldsByValue = omitFieldsByValue;
    }

    public int getOmitOutputFieldsByValueByte() {
        return this.omitOutputFieldsByValueByte;
    }

    public String getOmitOutputFieldsByValueByteHex() {
        return String.format("%02X", this.omitOutputFieldsByValueByte);
    }

    public void setOmitOutputFieldsByValueByte(int omitOutputFieldsByValueByte) {
        this.omitOutputFieldsByValueByte = omitOutputFieldsByValueByte;
    }

    public void setOmitOutputFieldsByValueByteHex(String omitOutputFieldsByValueByteHex) {
        block5: {
            try {
                if (omitOutputFieldsByValueByteHex == null) {
                    return;
                }
                if ((omitOutputFieldsByValueByteHex = omitOutputFieldsByValueByteHex.trim()).isEmpty()) {
                    return;
                }
                if ((omitOutputFieldsByValueByteHex = omitOutputFieldsByValueByteHex.toUpperCase()).startsWith("0X")) {
                    omitOutputFieldsByValueByteHex = omitOutputFieldsByValueByteHex.substring(2);
                }
                this.omitOutputFieldsByValueByte = Integer.parseInt(omitOutputFieldsByValueByteHex, 16);
            }
            catch (NumberFormatException e) {
                if (!ByteArrayToJSONOptions.logger.logger.isLoggable(Level.FINER)) break block5;
                logger.finer(e.getMessage(), new Object[0]);
            }
        }
    }

    public boolean isOmitOutputEmptyTags() {
        return this.omitOutputEmptyTags;
    }

    public void setOmitOutputEmptyTags(boolean omitEmptyTags) {
        this.omitOutputEmptyTags = omitEmptyTags;
    }
}

