/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.transaction.messages;

import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.metadata.transaction.YesnoType;
import com.ibm.ims.dli.types.ByteConverter;
import com.ibm.ims.dli.types.BytesConverter;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.DoubleConverter;
import com.ibm.ims.dli.types.FloatConverter;
import com.ibm.ims.dli.types.IntegerConverter;
import com.ibm.ims.dli.types.LongConverter;
import com.ibm.ims.dli.types.PackedDecimalConverter;
import com.ibm.ims.dli.types.ShortConverter;
import com.ibm.ims.dli.types.StringConverter;
import com.ibm.ims.dli.types.UByteConverter;
import com.ibm.ims.dli.types.UIntegerConverter;
import com.ibm.ims.dli.types.ULongConverter;
import com.ibm.ims.dli.types.UShortConverter;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.transaction.messages.walkers.ZonedDecimalConverter2;
import com.ibm.ims.transaction.model.Field;
import com.ibm.ims.transaction.model.FieldValue;
import com.ibm.ims.transaction.model.RedefinesGroup;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

public class MessagePayloadManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Logger logger;
    private static final String CLASSNAME = MessagePayloadManager.class.getName();
    private Transaction tran;
    private String messageName;
    private int msgType;
    private String encoding;
    private ArrayList<ArrayList<FieldValue>> twoDimFieldValuesList;
    private ArrayList<ArrayList<Field>> twoDimDependsonFields;
    private ArrayList<ArrayList<String>> twoDimDependsonFieldNames;
    private ArrayList<ArrayList<Field>> twoDimDataStructures;
    private ArrayList<ArrayList<RedefinesGroup>> twoDimRedefinesGroups;
    private Integer[] segmentLengths;
    private Hashtable<String, FieldValue> fieldValuesTable;
    private Hashtable<String, FieldValue> prevFieldValuesTable;
    private ArrayList<byte[]> ioareas;
    private static ByteConverter byteConverter;
    private static ShortConverter shortConverter;
    private static IntegerConverter intConverter;
    private static LongConverter longConverter;
    private static UByteConverter ubyteConverter;
    private static UShortConverter ushortConverter;
    private static UIntegerConverter uintConverter;
    private static ULongConverter ulongConverter;
    private static FloatConverter floatConverter;
    private static DoubleConverter doubleConverter;
    private static BytesConverter bytesConverter;
    private StringConverter stringConverter;

    public MessagePayloadManager(Transaction tran, String messageName, int msgType, String encoding) {
        this.tran = tran;
        this.messageName = messageName;
        this.msgType = msgType;
        this.encoding = encoding;
        this.fieldValuesTable = new Hashtable();
        this.prevFieldValuesTable = new Hashtable();
        this.initDataStructures();
    }

    private void initDataStructures() {
        MessageType msg = this.getMessage();
        List<SegmentType> segments = msg.getSegment();
        int numSegments = segments.size();
        this.twoDimFieldValuesList = new ArrayList(numSegments);
        this.twoDimDataStructures = new ArrayList(numSegments);
        this.twoDimRedefinesGroups = new ArrayList(numSegments);
        this.twoDimDependsonFields = new ArrayList(numSegments);
        this.twoDimDependsonFieldNames = new ArrayList(numSegments);
        this.segmentLengths = new Integer[numSegments];
        this.ioareas = new ArrayList(numSegments);
        int i = 0;
        while (i < numSegments) {
            this.twoDimFieldValuesList.add(i, new ArrayList());
            this.twoDimDataStructures.add(i, new ArrayList());
            this.twoDimRedefinesGroups.add(i, new ArrayList());
            this.twoDimDependsonFields.add(i, new ArrayList());
            this.twoDimDependsonFieldNames.add(i, new ArrayList());
            ++i;
        }
        i = 0;
        while (i < numSegments) {
            SegmentType currSeg = segments.get(i);
            this.initDataStructure(i, currSeg.getField());
            ++i;
        }
    }

    public int getNumSegments() {
        return this.getMessage().getSegment().size();
    }

    private void initDataStructure(int segmentIx, List<FieldType> jaxbFields) {
        ArrayList<Field> rootFieldNodes = this.populateFieldNodes(jaxbFields, null, segmentIx);
        this.twoDimDataStructures.set(segmentIx, rootFieldNodes);
        ArrayList<String> dependsonFieldNames = this.twoDimDependsonFieldNames.get(segmentIx);
        int i = 0;
        while (i < dependsonFieldNames.size()) {
            this.addDependsonField(dependsonFieldNames.get(i), segmentIx);
            ++i;
        }
    }

    private ArrayList<Field> populateFieldNodes(List<FieldType> jaxbFields, Field parent, int segmentIx) {
        ArrayList<Field> retVal = null;
        if (parent == null) {
            retVal = new ArrayList<Field>(jaxbFields.size());
        }
        int i = 0;
        while (i < jaxbFields.size()) {
            List<FieldType> childFieldTypes;
            String redefinedFieldName;
            FieldType currFieldType = jaxbFields.get(i);
            Field newField = new Field(currFieldType, parent);
            if (parent == null) {
                retVal.add(newField);
            } else {
                parent.addChildField(newField);
            }
            String dependsonFieldName = currFieldType.getDependsOn();
            if (dependsonFieldName != null && !dependsonFieldName.isEmpty()) {
                this.addDependsonFieldName(dependsonFieldName, segmentIx);
            }
            if ((redefinedFieldName = currFieldType.getRedefines()) != null && !redefinedFieldName.isEmpty()) {
                if (parent == null) {
                    this.handleRedefines(newField, retVal, segmentIx);
                } else {
                    this.handleRedefines(newField, parent.getChildFields(), segmentIx);
                }
            }
            if ((childFieldTypes = currFieldType.getField()).size() > 0) {
                this.populateFieldNodes(childFieldTypes, newField, segmentIx);
            }
            ++i;
        }
        return retVal;
    }

    private void addDependsonField(String dependsonFieldName, int segmentIx) {
        Field dependsonField = this.getField(dependsonFieldName, segmentIx);
        dependsonField.setDependsonField(true);
        ArrayList<Field> segmentDependsonFields = this.twoDimDependsonFields.get(segmentIx);
        segmentDependsonFields.add(dependsonField);
    }

    private void addDependsonFieldName(String dependsonFieldName, int segmentIx) {
        this.twoDimDependsonFieldNames.get(segmentIx).add(dependsonFieldName);
    }

    private Field getField(String fieldName, int segmentIx) {
        ArrayList<Field> dataStructure = this.twoDimDataStructures.get(segmentIx);
        return MessagePayloadManager.getFieldFromDataStructure(dataStructure, fieldName);
    }

    private static Field getFieldFromDataStructure(ArrayList<Field> peerFields, String fieldName) {
        Field retVal = null;
        int i = 0;
        while (i < peerFields.size()) {
            Field currPeerField = peerFields.get(i);
            if (currPeerField.getJaxbField().getName().equals(fieldName)) {
                retVal = currPeerField;
                break;
            }
            ArrayList<Field> childFields = currPeerField.getChildFields();
            if (childFields.size() > 0 && (retVal = MessagePayloadManager.getFieldFromDataStructure(childFields, fieldName)) != null) break;
            ++i;
        }
        return retVal;
    }

    public int getSegmentLength(int segmentIx) {
        return this.segmentLengths[segmentIx];
    }

    public byte[] getBytes(int segmentIx) throws Exception {
        String METHOD = "getBytes(int segmentIx)";
        byte[] retVal = null;
        Integer segmentLength = this.segmentLengths[segmentIx];
        if (segmentLength == null) {
            this.getFieldValueList(segmentIx, false);
            segmentLength = this.segmentLengths[segmentIx];
        }
        retVal = new byte[segmentLength.intValue()];
        List fieldValueList = this.twoDimFieldValuesList.get(segmentIx);
        for (FieldValue currFieldValue : fieldValueList) {
            String fieldValueStr = currFieldValue.getFieldValue();
            if (fieldValueStr == null || fieldValueStr.isEmpty()) continue;
            FieldType fieldType = currFieldValue.getAssociatedField().getJaxbField();
            DatatypeType dataType = fieldType.getApplicationDatatype().getDatatype();
            try {
                if (dataType == DatatypeType.CHAR) {
                    int uninitializedChars;
                    Integer fieldLength = fieldType.getBytes();
                    String valueStr = currFieldValue.getFieldValue();
                    if (valueStr == null) {
                        valueStr = "";
                    }
                    if ((uninitializedChars = fieldLength - valueStr.length()) > 0) {
                        valueStr = MessagePayloadManager.stringPad(valueStr, ' ', fieldLength);
                    }
                    StringConverter stringConv = this.getStringConverter();
                    stringConv.writeObject(retVal, currFieldValue.getStartPos() - 1, fieldLength.intValue(), (Object)valueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.BYTE) {
                    ByteConverter byteConv = this.getByteConverter();
                    byteConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.SHORT) {
                    ShortConverter shortConv = this.getShortConverter();
                    shortConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.INT) {
                    IntegerConverter intConv = this.getIntegerConverter();
                    intConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.LONG) {
                    LongConverter longConv = this.getLongConverter();
                    longConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.UBYTE) {
                    UByteConverter ubyteConv = this.getUByteConverter();
                    ubyteConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.USHORT) {
                    UShortConverter ushortConv = this.getUShortConverter();
                    ushortConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.UINT) {
                    UIntegerConverter uintConv = this.getUIntegerConverter();
                    uintConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.ULONG) {
                    ULongConverter ulongConv = this.getULongConverter();
                    ulongConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.FLOAT) {
                    FloatConverter floatConv = this.getFloatConverter();
                    floatConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType == DatatypeType.DOUBLE) {
                    DoubleConverter doubleConv = this.getDoubleConverter();
                    doubleConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (dataType != DatatypeType.DECIMAL) continue;
                MarshallerType marshaller = fieldType.getMarshaller();
                YesnoType ynType = marshaller.getIsSigned();
                boolean isSigned = ynType == YesnoType.Y;
                ynType = marshaller.getIsSignLeading();
                boolean isSignLeading = ynType == YesnoType.Y;
                ynType = marshaller.getIsSignSeparate();
                boolean isSignSeparate = ynType == YesnoType.Y;
                ynType = marshaller.getIsWCHAROnly();
                boolean isWCHAROnly = ynType == YesnoType.Y;
                ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
                Integer precision = adt.getPrecision();
                Integer scale = adt.getScale();
                PhysicalDatatypeType pdt = marshaller.getTypeConverter();
                if (pdt == PhysicalDatatypeType.PACKEDDECIMAL) {
                    PackedDecimalConverter pdc = new PackedDecimalConverter(scale, precision, isSigned);
                    pdc.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
                    continue;
                }
                if (pdt == PhysicalDatatypeType.ZONEDDECIMAL) {
                    BigDecimal bigDecimal = new BigDecimal(fieldValueStr);
                    ZonedDecimalConverter2 zdc = new ZonedDecimalConverter2(scale, precision, isSigned, isSignLeading, isSignSeparate, isWCHAROnly);
                    zdc.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize(), bigDecimal, new ArrayList<String>());
                    continue;
                }
                if (pdt != PhysicalDatatypeType.BINARY) continue;
                BytesConverter bytesConv = this.getBytesConverter(scale, precision, isSigned);
                bytesConv.writeObject(retVal, currFieldValue.getStartPos() - 1, currFieldValue.getSize().intValue(), (Object)fieldValueStr, null);
            }
            catch (Exception e) {
                RuntimeException newExc = new RuntimeException("Failure occurred while converting value for field: " + fieldType.getName(), e);
                this.logger.throwing(CLASSNAME, METHOD, newExc);
                throw newExc;
            }
        }
        return retVal;
    }

    public static String stringPad(String str, char ch, int l) {
        StringBuffer sb = null;
        int len = 0;
        if (str == null) {
            sb = new StringBuffer();
        } else {
            sb = new StringBuffer(str);
            len = str.length();
        }
        int i = 1;
        while (i <= l - len) {
            sb.append(ch);
            ++i;
        }
        return new String(sb);
    }

    public List<FieldValue> setBytes(int segmentIx, byte[] ioarea) throws UnsupportedTypeConversion, IOException, ConversionException {
        this.ioareas.add(segmentIx, ioarea);
        List retVal = null;
        if (this.twoDimFieldValuesList.size() > segmentIx) {
            Integer segmentLength;
            retVal = this.twoDimFieldValuesList.get(segmentIx);
            List dataStructureNodes = this.twoDimDataStructures.get(segmentIx);
            this.segmentLengths[segmentIx] = segmentLength = this.populateFieldValueList(retVal, dataStructureNodes, 1, "", segmentIx);
        }
        return retVal;
    }

    public int getNumIoAreas() {
        return this.ioareas.size();
    }

    public byte[] getIoArea(int ioAreaIx) {
        return this.ioareas.get(ioAreaIx);
    }

    private ByteConverter getByteConverter() {
        if (byteConverter == null) {
            byteConverter = new ByteConverter();
        }
        return byteConverter;
    }

    private ShortConverter getShortConverter() {
        if (shortConverter == null) {
            shortConverter = new ShortConverter();
        }
        return shortConverter;
    }

    private IntegerConverter getIntegerConverter() {
        if (intConverter == null) {
            intConverter = new IntegerConverter();
        }
        return intConverter;
    }

    private LongConverter getLongConverter() {
        if (longConverter == null) {
            longConverter = new LongConverter();
        }
        return longConverter;
    }

    private UByteConverter getUByteConverter() {
        if (ubyteConverter == null) {
            ubyteConverter = new UByteConverter();
        }
        return ubyteConverter;
    }

    private UShortConverter getUShortConverter() {
        if (ushortConverter == null) {
            ushortConverter = new UShortConverter();
        }
        return ushortConverter;
    }

    private UIntegerConverter getUIntegerConverter() {
        if (uintConverter == null) {
            uintConverter = new UIntegerConverter();
        }
        return uintConverter;
    }

    private ULongConverter getULongConverter() {
        if (ulongConverter == null) {
            ulongConverter = new ULongConverter();
        }
        return ulongConverter;
    }

    private FloatConverter getFloatConverter() {
        if (floatConverter == null) {
            floatConverter = new FloatConverter();
        }
        return floatConverter;
    }

    private DoubleConverter getDoubleConverter() {
        if (doubleConverter == null) {
            doubleConverter = new DoubleConverter();
        }
        return doubleConverter;
    }

    private BytesConverter getBytesConverter(int scale, int precision, boolean isSigned) {
        if (bytesConverter == null) {
            bytesConverter = new BytesConverter(Integer.valueOf(scale), Integer.valueOf(precision), isSigned);
        }
        return bytesConverter;
    }

    private StringConverter getStringConverter() {
        if (this.stringConverter == null) {
            this.stringConverter = new StringConverter(this.encoding);
        }
        return this.stringConverter;
    }

    private void handleRedefines(Field redefiningField, ArrayList<Field> peerFields, int segmentIx) {
        String redefinedFieldName = redefiningField.getJaxbField().getRedefines();
        int i = 0;
        while (i < peerFields.size()) {
            Field currPeerField = peerFields.get(i);
            if (redefinedFieldName.equals(currPeerField.getJaxbField().getName())) {
                RedefinesGroup redefinesGroup = currPeerField.getRedefinesGroup();
                if (redefinesGroup == null) {
                    redefinesGroup = new RedefinesGroup();
                    redefinesGroup.addFieldToGroup(currPeerField);
                    redefinesGroup.addFieldToGroup(redefiningField);
                    ArrayList<RedefinesGroup> segRedefinesGroups = this.twoDimRedefinesGroups.get(segmentIx);
                    segRedefinesGroups.add(redefinesGroup);
                } else {
                    redefinesGroup.addFieldToGroup(redefiningField);
                }
            }
            ++i;
        }
    }

    private MessageType getMessage() {
        MessageType retVal = null;
        List<MessageType> msgList = null;
        msgList = this.msgType == 0 ? this.tran.getInputMessage() : this.tran.getOutputMessage();
        int i = 0;
        while (i < msgList.size()) {
            MessageType currMsg = msgList.get(i);
            if (currMsg.getName().equals(this.messageName)) {
                retVal = currMsg;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public void setFieldValue(String fieldName, String fieldValueStr) {
        FieldValue fieldVal = new FieldValue(fieldName);
        fieldVal.setFieldValue(fieldValueStr);
        this.prevFieldValuesTable.put(fieldName, fieldVal);
    }

    public void updateFieldValue(String fieldName, String fieldValueStr) {
        FieldValue fieldVal = new FieldValue(fieldName);
        fieldVal.setFieldValue(fieldValueStr);
        FieldValue nameValuePair = this.fieldValuesTable.get(fieldName);
        nameValuePair.setFieldValue(fieldValueStr);
    }

    public String getFieldValue(String fieldName) {
        String retVal = null;
        FieldValue fv = this.fieldValuesTable.get(fieldName);
        if (fv != null) {
            retVal = fv.getFieldValue();
        }
        return retVal;
    }

    public List<FieldValue> getFieldValueList(int segmentIx) throws UnsupportedTypeConversion, IOException, ConversionException {
        return this.getFieldValueList(segmentIx, false);
    }

    public List<FieldValue> getFieldValueList(int segmentIx, boolean rebuildFieldList) throws UnsupportedTypeConversion, IOException, ConversionException {
        List retVal = null;
        retVal = this.twoDimFieldValuesList.get(segmentIx);
        if (rebuildFieldList || retVal.size() == 0) {
            Integer segmentLength;
            if (retVal.size() > 0) {
                retVal.clear();
                this.prevFieldValuesTable = this.fieldValuesTable;
                this.fieldValuesTable = new Hashtable();
            }
            List dataStructureNodes = this.twoDimDataStructures.get(segmentIx);
            this.segmentLengths[segmentIx] = segmentLength = this.populateFieldValueList(retVal, dataStructureNodes, 1, "", segmentIx);
            if (retVal.size() >= 3) {
                FieldValue potentialLLField = (FieldValue)retVal.get(1);
                FieldValue potentialZZField = (FieldValue)retVal.get(2);
                FieldValue potentialTrancodeField = (FieldValue)retVal.get(3);
                DatatypeType llFieldDatatype = potentialLLField.getAssociatedField().getJaxbField().getApplicationDatatype().getDatatype();
                DatatypeType zzFieldDatatype = potentialZZField.getAssociatedField().getJaxbField().getApplicationDatatype().getDatatype();
                DatatypeType trancodeFieldDatatype = potentialTrancodeField.getAssociatedField().getJaxbField().getApplicationDatatype().getDatatype();
                if (!(llFieldDatatype != DatatypeType.SHORT && llFieldDatatype != DatatypeType.USHORT || zzFieldDatatype != DatatypeType.SHORT && zzFieldDatatype != DatatypeType.USHORT || trancodeFieldDatatype != DatatypeType.CHAR)) {
                    String currentValue;
                    Integer fieldLength;
                    String potentialZZFieldName;
                    String potentialLLFieldName = potentialLLField.getFieldName();
                    if (potentialLLFieldName.contains("LL") || potentialLLFieldName.contains("ll") || potentialLLFieldName.contains("lL") || potentialLLFieldName.contains("Ll")) {
                        potentialLLField.setFieldValue(segmentLength.toString());
                    }
                    if ((potentialZZFieldName = potentialZZField.getFieldName()).contains("ZZ") || potentialZZFieldName.contains("zz") || potentialZZFieldName.contains("zZ") || potentialZZFieldName.contains("Zz")) {
                        potentialZZField.setFieldValue("0");
                    }
                    if ((fieldLength = potentialTrancodeField.getAssociatedField().getJaxbField().getBytes()) != null && fieldLength == 8 && ((currentValue = potentialTrancodeField.getFieldValue()) == null || currentValue.isEmpty())) {
                        potentialTrancodeField.setFieldValue(this.tran.getTranCode());
                    }
                }
            }
        }
        return retVal;
    }

    public String getPayloadAsSingleString(int segmentIx) throws UnsupportedTypeConversion, IOException {
        byte[] ioarea = null;
        if (this.ioareas.size() > 0) {
            ioarea = this.ioareas.get(segmentIx);
        }
        return this.getPayloadAsSingleString(ioarea);
    }

    public String getPayloadAsSingleString(byte[] ioarea) throws UnsupportedTypeConversion, IOException {
        byte[] scrubbedBuff = null;
        String retVal = null;
        String blank = " ";
        byte[] blankByte = blank.getBytes(this.encoding);
        scrubbedBuff = new byte[ioarea.length];
        int i = 0;
        while (i < ioarea.length) {
            byte currByte = ioarea[i];
            scrubbedBuff[i] = currByte == 0 ? blankByte[0] : ioarea[i];
            ++i;
        }
        StringConverter stringConv = this.getStringConverter();
        retVal = (String)stringConv.readObject(scrubbedBuff, 0, scrubbedBuff.length, String.class, null);
        return retVal;
    }

    private Integer populateFieldValueList(List<FieldValue> retVal, List<Field> fields, Integer startPos, String prependFieldName, int segmentIx) throws UnsupportedTypeConversion, IOException, ConversionException {
        Integer currStartPos = startPos;
        Integer totalSize = 0;
        Field prevField = null;
        int numFields = fields.size();
        int i = 0;
        while (i < numFields) {
            Field currField = fields.get(i);
            FieldValue currFieldValue = new FieldValue(prependFieldName + currField.getJaxbField().getName());
            currFieldValue.setStartPos(currStartPos);
            retVal.add(currFieldValue);
            currFieldValue.setAssociatedField(currField);
            this.fieldValuesTable.put(currFieldValue.getFieldName(), currFieldValue);
            ArrayList<Field> childFields = currField.getChildFields();
            Integer currFieldSize = null;
            if (childFields.size() > 0) {
                ApplicationDatatypeType adt = currField.getJaxbField().getApplicationDatatype();
                if (adt.getDatatype() == DatatypeType.ARRAY) {
                    currFieldSize = this.populateArrayFieldValueList(retVal, currField, currStartPos, prependFieldName, segmentIx);
                    currFieldValue.setSize(currFieldSize);
                } else {
                    currFieldSize = this.populateFieldValueList(retVal, childFields, currStartPos, prependFieldName, segmentIx);
                    currFieldValue.setSize(currFieldSize);
                }
            } else {
                currFieldSize = currField.getJaxbField().getBytes();
                currFieldValue.setSize(currFieldSize);
            }
            RedefinesGroup redefGrp = currField.getRedefinesGroup();
            if (redefGrp != null) {
                if (i + 1 == numFields) {
                    Integer redefinesGroupSize = this.getRedefinesGroupSize(redefGrp, prependFieldName);
                    totalSize = totalSize + redefinesGroupSize;
                } else if (prevField != null && (prevFieldRedefGrp = prevField.getRedefinesGroup()) != null && prevFieldRedefGrp != redefGrp) {
                    Integer prevRedefinesGroupSize = this.getRedefinesGroupSize(prevFieldRedefGrp, prependFieldName);
                    totalSize = totalSize + prevRedefinesGroupSize;
                    currStartPos = currStartPos + prevRedefinesGroupSize;
                    currFieldValue.setStartPos(currStartPos);
                }
            } else {
                if (prevField != null && (prevFieldRedefGrp = prevField.getRedefinesGroup()) != null) {
                    Integer redefinesGroupSize = this.getRedefinesGroupSize(prevFieldRedefGrp, prependFieldName);
                    totalSize = totalSize + redefinesGroupSize;
                    currStartPos = currStartPos + redefinesGroupSize;
                    currFieldValue.setStartPos(currStartPos);
                }
                totalSize = totalSize + currFieldSize;
                currStartPos = currStartPos + currFieldSize;
            }
            this.setStringValue(currFieldValue, segmentIx);
            prevField = currField;
            ++i;
        }
        return totalSize;
    }

    private Integer getRedefinesGroupSize(RedefinesGroup redefGrp, String prependFieldName) {
        Integer retVal = 0;
        ArrayList<Field> redefFields = redefGrp.getRedefinesGroupFields();
        for (Field currField : redefFields) {
            FieldValue currFieldValue = this.fieldValuesTable.get(prependFieldName + currField.getJaxbField().getName());
            Integer currFieldSize = currFieldValue.getSize();
            if (currFieldSize <= retVal) continue;
            retVal = currFieldSize;
        }
        return retVal;
    }

    private void setStringValue(FieldValue fieldValue, int segmentIx) throws UnsupportedTypeConversion, IOException, ConversionException {
        FieldValue prevFieldValue = this.prevFieldValuesTable.get(fieldValue.getFieldName());
        if (prevFieldValue != null) {
            fieldValue.setFieldValue(prevFieldValue.getFieldValue());
        } else {
            byte[] ioarea = null;
            if (segmentIx < this.ioareas.size() && (ioarea = this.ioareas.get(segmentIx)) != null && ioarea.length > 0) {
                this.setStringValueFromBytes(fieldValue, ioarea);
            }
        }
        if (fieldValue.getFieldValue() == null && fieldValue.getAssociatedField().isDependsonField()) {
            fieldValue.setFieldValue("3");
        }
    }

    private void setStringValueFromBytes(FieldValue fieldValue, byte[] ioarea) {
        FieldType fieldType = fieldValue.getAssociatedField().getJaxbField();
        DatatypeType dataType = fieldType.getApplicationDatatype().getDatatype();
        Integer startPos = fieldValue.getStartPos();
        Integer size = fieldValue.getSize();
        if (startPos > ioarea.length) {
            this.logger.finest("Output message data structure contains a field outside the bounds of the message payload. FieldName: " + fieldValue.getFieldName() + " startPos: " + String.valueOf(startPos) + " message payload length: " + ioarea.length);
            fieldValue.setFieldValue(null);
            return;
        }
        if (dataType != DatatypeType.STRUCT && dataType != DatatypeType.ARRAY && startPos + size - 1 > ioarea.length) {
            Integer initialSize = size;
            size = ioarea.length - startPos + 1;
            this.logger.finest("Size for field: " + fieldValue.getFieldName() + " shortened from " + String.valueOf(initialSize) + " to " + String.valueOf(size));
        }
        try {
            if (dataType == DatatypeType.CHAR) {
                StringConverter stringConv = this.getStringConverter();
                String convValueStr = (String)stringConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.BYTE) {
                ByteConverter byteConv = this.getByteConverter();
                String convValueStr = (String)byteConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.SHORT) {
                ShortConverter shortConv = this.getShortConverter();
                String convValueStr = (String)shortConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.INT) {
                IntegerConverter intConv = this.getIntegerConverter();
                String convValueStr = (String)intConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.LONG) {
                LongConverter longConv = this.getLongConverter();
                String convValueStr = (String)longConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.UBYTE) {
                UByteConverter ubyteConv = this.getUByteConverter();
                String convValueStr = (String)ubyteConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.USHORT) {
                UShortConverter ushortConv = this.getUShortConverter();
                String convValueStr = (String)ushortConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.UINT) {
                UIntegerConverter uintConv = this.getUIntegerConverter();
                String convValueStr = (String)uintConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.ULONG) {
                ULongConverter ulongConv = this.getULongConverter();
                String convValueStr = (String)ulongConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.FLOAT) {
                FloatConverter floatConv = this.getFloatConverter();
                String convValueStr = (String)floatConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.DOUBLE) {
                DoubleConverter doubleConv = this.getDoubleConverter();
                String convValueStr = (String)doubleConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                fieldValue.setFieldValue(convValueStr);
            } else if (dataType == DatatypeType.DECIMAL) {
                MarshallerType marshaller = fieldType.getMarshaller();
                YesnoType ynType = marshaller.getIsSigned();
                boolean isSigned = ynType == YesnoType.Y;
                ynType = marshaller.getIsSignLeading();
                boolean isSignLeading = ynType == YesnoType.Y;
                ynType = marshaller.getIsSignSeparate();
                boolean isSignSeparate = ynType == YesnoType.Y;
                ynType = marshaller.getIsWCHAROnly();
                boolean isWCHAROnly = ynType == YesnoType.Y;
                ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
                Integer precision = adt.getPrecision();
                Integer scale = adt.getScale();
                PhysicalDatatypeType pdt = marshaller.getTypeConverter();
                if (pdt == PhysicalDatatypeType.PACKEDDECIMAL) {
                    PackedDecimalConverter pdc = new PackedDecimalConverter(scale, precision, isSigned);
                    String convValueStr = (String)pdc.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                    fieldValue.setFieldValue(convValueStr);
                } else if (pdt == PhysicalDatatypeType.ZONEDDECIMAL) {
                    ZonedDecimalConverter2 zdc = new ZonedDecimalConverter2(scale, precision, isSigned, isSignLeading, isSignSeparate, isWCHAROnly);
                    BigDecimal convValueStr = (BigDecimal)zdc.readObject(ioarea, fieldValue.getStartPos() - 1, size, BigDecimal.class, null);
                    fieldValue.setFieldValue(convValueStr.toString());
                } else if (pdt == PhysicalDatatypeType.BINARY) {
                    BytesConverter bytesConv = this.getBytesConverter(scale, precision, isSigned);
                    String convValueStr = (String)bytesConv.readObject(ioarea, fieldValue.getStartPos() - 1, size.intValue(), String.class, null);
                    fieldValue.setFieldValue(convValueStr);
                }
            }
        }
        catch (Throwable e) {
            this.logger.fine("Conversion exception on output: " + e.getMessage());
        }
    }

    private Integer populateArrayFieldValueList(List<FieldValue> retVal, Field arrayField, Integer startPos, String prependFieldName, int segmentIx) throws UnsupportedTypeConversion, IOException, ConversionException {
        Integer currStartPos = startPos;
        Integer totalSize = 0;
        Integer numArrayElements = this.getNumArrayElements(arrayField);
        String arrayFieldName = arrayField.getJaxbField().getName();
        int i = 1;
        while (i <= numArrayElements) {
            String concatPrependName = prependFieldName + arrayFieldName + "_" + i + "_";
            Integer sizeOfSubStructure = this.populateFieldValueList(retVal, arrayField.getChildFields(), currStartPos, concatPrependName, segmentIx);
            totalSize = totalSize + sizeOfSubStructure;
            currStartPos = currStartPos + sizeOfSubStructure;
            ++i;
        }
        return totalSize;
    }

    private Integer getNumArrayElements(Field arrayField) {
        Integer retVal = null;
        String dependsonFieldName = arrayField.getJaxbField().getDependsOn();
        if (dependsonFieldName != null && !dependsonFieldName.isEmpty()) {
            FieldValue dependsonFieldValue = this.fieldValuesTable.get(dependsonFieldName);
            String numElemsStr = dependsonFieldValue.getFieldValue();
            retVal = Integer.valueOf(numElemsStr);
        } else {
            retVal = arrayField.getJaxbField().getMaxOccurs();
        }
        return retVal;
    }
}

