/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.metadata.transaction;

import com.ibm.im.ims.metadata.transaction.MessageType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"inputMessage", "outputMessage"})
@XmlRootElement(name="transaction")
public class Transaction {
    protected List<MessageType> inputMessage = null;
    protected List<MessageType> outputMessage = null;
    @XmlAttribute(name="id")
    protected BigInteger id;
    @XmlAttribute(name="tranCode", required=true)
    protected String tranCode;
    @XmlAttribute(name="xmlSchemaVersion")
    protected String xmlSchemaVersion;

    public Transaction(Transaction another) {
        this.id = another.getId();
        this.tranCode = another.getTranCode();
        this.xmlSchemaVersion = another.getXmlSchemaVersion();
        if (another.getInputMessage().size() > 0) {
            this.buildInputMessageList(another);
        } else {
            this.inputMessage = new ArrayList<MessageType>();
        }
        if (another.getOutputMessage().size() > 0) {
            this.buildOutputMessageList(another);
        } else {
            this.outputMessage = new ArrayList<MessageType>();
        }
    }

    public Transaction() {
    }

    private void buildOutputMessageList(Transaction another) {
        Iterator<MessageType> messageIter = another.outputMessage.iterator();
        this.outputMessage = new ArrayList<MessageType>();
        while (messageIter.hasNext()) {
            MessageType messageObj = messageIter.next();
            if (!(messageObj instanceof MessageType)) continue;
            MessageType outMessage = messageObj;
            MessageType message = new MessageType(outMessage);
            this.outputMessage.add(message);
        }
    }

    private void buildInputMessageList(Transaction another) {
        Iterator<MessageType> messageIter = another.inputMessage.iterator();
        this.inputMessage = new ArrayList<MessageType>();
        while (messageIter.hasNext()) {
            MessageType messageObj = messageIter.next();
            if (!(messageObj instanceof MessageType)) continue;
            MessageType inMessage = messageObj;
            MessageType message = new MessageType(inMessage);
            this.inputMessage.add(message);
        }
    }

    public List<MessageType> getInputMessage() {
        if (this.inputMessage == null) {
            this.inputMessage = new ArrayList<MessageType>();
        }
        return this.inputMessage;
    }

    public List<MessageType> getOutputMessage() {
        if (this.outputMessage == null) {
            this.outputMessage = new ArrayList<MessageType>();
        }
        return this.outputMessage;
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger value) {
        this.id = value;
    }

    public String getTranCode() {
        return this.tranCode;
    }

    public void setTranCode(String value) {
        this.tranCode = value;
    }

    public String getXmlSchemaVersion() {
        return this.xmlSchemaVersion;
    }

    public void setXmlSchemaVersion(String value) {
        this.xmlSchemaVersion = value;
    }

    public void removeFields(String[] selectedFields) {
        for (MessageType iMessage : this.inputMessage) {
            iMessage.removeFields(selectedFields);
        }
        for (MessageType oMessage : this.outputMessage) {
            oMessage.removeFields(selectedFields);
        }
    }
}

