/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.metadata.transaction;

import com.ibm.im.ims.metadata.transaction.SegmentType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="messageType", propOrder={"remarks", "segment"})
public class MessageType {
    protected String remarks;
    protected List<SegmentType> segment;
    @XmlAttribute(name="id")
    protected BigInteger id;
    @XmlAttribute(name="name")
    protected String name;
    @XmlAttribute(name="messageVersion")
    protected BigInteger messageVersion;

    public MessageType() {
    }

    public MessageType(MessageType another) {
        this.remarks = another.getRemarks();
        this.id = another.getId();
        this.name = another.getName();
        this.messageVersion = another.getMessageVersion();
        if (another.getSegment().size() > 0) {
            this.buildSegmentList(another);
        } else {
            this.segment = new ArrayList<SegmentType>();
        }
    }

    private void buildSegmentList(MessageType another) {
        Iterator<SegmentType> segmentIter = another.segment.iterator();
        this.segment = new ArrayList<SegmentType>();
        while (segmentIter.hasNext()) {
            SegmentType segmentObj = segmentIter.next();
            if (!(segmentObj instanceof SegmentType)) continue;
            SegmentType s = segmentObj;
            SegmentType seg = new SegmentType(s);
            this.segment.add(seg);
        }
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String value) {
        this.remarks = value;
    }

    public List<SegmentType> getSegment() {
        if (this.segment == null) {
            this.segment = new ArrayList<SegmentType>();
        }
        return this.segment;
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BigInteger getMessageVersion() {
        return this.messageVersion;
    }

    public void setMessageVersion(BigInteger value) {
        this.messageVersion = value;
    }

    public void removeFields(String[] selectedFields) {
        for (SegmentType childSeg : this.segment) {
            childSeg.removeFields(selectedFields);
        }
    }
}

