/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.metadata.transaction;

import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="fieldType", propOrder={"startPos", "relativeStart", "startAfter", "bytes", "maxBytes", "remarks", "marshaller", "applicationDatatype", "field"})
public class FieldType {
    protected Integer startPos;
    protected Integer relativeStart;
    protected String startAfter;
    protected Integer bytes;
    protected Integer maxBytes;
    protected String remarks;
    protected MarshallerType marshaller;
    @XmlElement(required=true)
    protected ApplicationDatatypeType applicationDatatype;
    protected List<FieldType> field;
    @XmlAttribute(name="name")
    protected String name;
    @XmlAttribute(name="originalName")
    protected String originalName;
    @XmlAttribute(name="path")
    protected String path;
    @XmlAttribute(name="dependsOn")
    protected String dependsOn;
    @XmlAttribute(name="dependsOnPath")
    protected String dependsOnPath;
    @XmlAttribute(name="dependedOn")
    protected Boolean dependedOn;
    @XmlAttribute(name="redefines")
    protected String redefines;
    @XmlAttribute(name="minOccurs")
    protected Integer minOccurs;
    @XmlAttribute(name="maxOccurs")
    protected Integer maxOccurs;

    public FieldType() {
    }

    public FieldType(FieldType another) {
        this.startPos = another.getStartPos();
        this.relativeStart = another.getRelativeStart();
        this.startAfter = another.getStartAfter();
        this.bytes = another.getBytes();
        this.maxBytes = another.getMaxBytes();
        this.remarks = another.getRemarks();
        if (another.marshaller != null) {
            this.marshaller = new MarshallerType(another.marshaller);
        }
        if (another.applicationDatatype != null) {
            this.applicationDatatype = new ApplicationDatatypeType(another.applicationDatatype);
        }
        this.name = another.getName();
        this.originalName = another.getOriginalName();
        this.path = another.getPath();
        this.dependsOn = another.getDependsOn();
        this.dependsOnPath = another.getDependsOnPath();
        this.dependedOn = another.isDependedOn();
        this.redefines = another.getRedefines();
        this.minOccurs = another.getMinOccurs();
        this.maxOccurs = another.getMaxOccurs();
        if (another.field != null && another.field.size() > 0) {
            this.buildFieldList(another);
        } else {
            this.field = new ArrayList<FieldType>();
        }
    }

    private void buildFieldList(FieldType another) {
        Iterator<FieldType> fieldIter = another.field.iterator();
        this.field = new ArrayList<FieldType>();
        while (fieldIter.hasNext()) {
            FieldType fieldObj = fieldIter.next();
            if (!(fieldObj instanceof FieldType)) continue;
            FieldType f = fieldObj;
            FieldType fld = new FieldType(f);
            this.field.add(fld);
        }
    }

    public Integer getStartPos() {
        return this.startPos;
    }

    public void setStartPos(Integer value) {
        this.startPos = value;
    }

    public Integer getRelativeStart() {
        return this.relativeStart;
    }

    public void setRelativeStart(Integer value) {
        this.relativeStart = value;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public void setStartAfter(String value) {
        this.startAfter = value;
    }

    public Integer getBytes() {
        return this.bytes;
    }

    public void setBytes(Integer value) {
        this.bytes = value;
    }

    public Integer getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(Integer value) {
        this.maxBytes = value;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String value) {
        this.remarks = value;
    }

    public MarshallerType getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(MarshallerType value) {
        this.marshaller = value;
    }

    public ApplicationDatatypeType getApplicationDatatype() {
        return this.applicationDatatype;
    }

    public void setApplicationDatatype(ApplicationDatatypeType value) {
        this.applicationDatatype = value;
    }

    public List<FieldType> getField() {
        if (this.field == null) {
            this.field = new ArrayList<FieldType>();
        }
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String value) {
        this.originalName = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String value) {
        this.dependsOn = value;
    }

    public String getDependsOnPath() {
        return this.dependsOnPath;
    }

    public void setDependsOnPath(String value) {
        this.dependsOnPath = value;
    }

    public Boolean isDependedOn() {
        return this.dependedOn;
    }

    public void setDependedOn(Boolean value) {
        this.dependedOn = value;
    }

    public String getRedefines() {
        return this.redefines;
    }

    public void setRedefines(String value) {
        this.redefines = value;
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(Integer value) {
        this.minOccurs = value;
    }

    public Integer getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(Integer value) {
        this.maxOccurs = value;
    }

    public String toString() {
        return this.getName();
    }

    public void removeField(String selectedField) {
        int i = 0;
        while (i < this.field.size()) {
            FieldType childField = this.field.get(i);
            if (childField.getName().equals(selectedField)) {
                this.field.remove(childField);
                --i;
            } else {
                childField.removeField(selectedField);
            }
            ++i;
        }
    }
}

