/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnicodeTransformationFormat implements Enumerator
{
    UTF8_LITERAL(0, "UTF8", "UTF8"),
    UTF16_LITERAL(1, "UTF16", "UTF16"),
    UTF32_LITERAL(2, "UTF32", "UTF32");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int UTF8 = 0;
    public static final int UTF16 = 1;
    public static final int UTF32 = 2;
    private static final UnicodeTransformationFormat[] VALUES_ARRAY;
    public static final List<UnicodeTransformationFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnicodeTransformationFormat[]{UTF8_LITERAL, UTF16_LITERAL, UTF32_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnicodeTransformationFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnicodeTransformationFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnicodeTransformationFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnicodeTransformationFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnicodeTransformationFormat get(int value) {
        switch (value) {
            case 0: {
                return UTF8_LITERAL;
            }
            case 1: {
                return UTF16_LITERAL;
            }
            case 2: {
                return UTF32_LITERAL;
            }
        }
        return null;
    }

    private UnicodeTransformationFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

