/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StringJustificationKind implements Enumerator
{
    LEFT_JUSTIFY_LITERAL(0, "leftJustify", "leftJustify"),
    RIGHT_JUSTIFY_LITERAL(1, "rightJustify", "rightJustify"),
    CENTER_JUSTIFY_LITERAL(2, "centerJustify", "centerJustify");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int LEFT_JUSTIFY = 0;
    public static final int RIGHT_JUSTIFY = 1;
    public static final int CENTER_JUSTIFY = 2;
    private static final StringJustificationKind[] VALUES_ARRAY;
    public static final List<StringJustificationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StringJustificationKind[]{LEFT_JUSTIFY_LITERAL, RIGHT_JUSTIFY_LITERAL, CENTER_JUSTIFY_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StringJustificationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StringJustificationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StringJustificationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StringJustificationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StringJustificationKind get(int value) {
        switch (value) {
            case 0: {
                return LEFT_JUSTIFY_LITERAL;
            }
            case 1: {
                return RIGHT_JUSTIFY_LITERAL;
            }
            case 2: {
                return CENTER_JUSTIFY_LITERAL;
            }
        }
        return null;
    }

    private StringJustificationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

