/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SignFormatValue implements Enumerator
{
    LEADING_LITERAL(0, "leading", "leading"),
    LEADING_SEPARATE_LITERAL(1, "leadingSeparate", "leadingSeparate"),
    TRAILING_LITERAL(2, "trailing", "trailing"),
    TRAILING_SEPARATE_LITERAL(3, "trailingSeparate", "trailingSeparate");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int LEADING = 0;
    public static final int LEADING_SEPARATE = 1;
    public static final int TRAILING = 2;
    public static final int TRAILING_SEPARATE = 3;
    private static final SignFormatValue[] VALUES_ARRAY;
    public static final List<SignFormatValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SignFormatValue[]{LEADING_LITERAL, LEADING_SEPARATE_LITERAL, TRAILING_LITERAL, TRAILING_SEPARATE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SignFormatValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SignFormatValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SignFormatValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SignFormatValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SignFormatValue get(int value) {
        switch (value) {
            case 0: {
                return LEADING_LITERAL;
            }
            case 1: {
                return LEADING_SEPARATE_LITERAL;
            }
            case 2: {
                return TRAILING_LITERAL;
            }
            case 3: {
                return TRAILING_SEPARATE_LITERAL;
            }
        }
        return null;
    }

    private SignFormatValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

