/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NumeralShapes implements Enumerator
{
    NOMINAL_LITERAL(0, "nominal", "nominal"),
    NATIONAL_LITERAL(1, "national", "national"),
    CONTEXTUAL_LITERAL(2, "contextual", "contextual");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int NOMINAL = 0;
    public static final int NATIONAL = 1;
    public static final int CONTEXTUAL = 2;
    private static final NumeralShapes[] VALUES_ARRAY;
    public static final List<NumeralShapes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NumeralShapes[]{NOMINAL_LITERAL, NATIONAL_LITERAL, CONTEXTUAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NumeralShapes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NumeralShapes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NumeralShapes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NumeralShapes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NumeralShapes get(int value) {
        switch (value) {
            case 0: {
                return NOMINAL_LITERAL;
            }
            case 1: {
                return NATIONAL_LITERAL;
            }
            case 2: {
                return CONTEXTUAL_LITERAL;
            }
        }
        return null;
    }

    private NumeralShapes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

