/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LengthEncodingValue implements Enumerator
{
    FIXED_LENGTH_LITERAL(0, "fixedLength", "fixedLength"),
    LENGTH_PREFIXED_LITERAL(1, "lengthPrefixed", "lengthPrefixed"),
    NULL_TERMINATED_LITERAL(2, "nullTerminated", "nullTerminated");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int FIXED_LENGTH = 0;
    public static final int LENGTH_PREFIXED = 1;
    public static final int NULL_TERMINATED = 2;
    private static final LengthEncodingValue[] VALUES_ARRAY;
    public static final List<LengthEncodingValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LengthEncodingValue[]{FIXED_LENGTH_LITERAL, LENGTH_PREFIXED_LITERAL, NULL_TERMINATED_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LengthEncodingValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LengthEncodingValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LengthEncodingValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LengthEncodingValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LengthEncodingValue get(int value) {
        switch (value) {
            case 0: {
                return FIXED_LENGTH_LITERAL;
            }
            case 1: {
                return LENGTH_PREFIXED_LITERAL;
            }
            case 2: {
                return NULL_TERMINATED_LITERAL;
            }
        }
        return null;
    }

    private LengthEncodingValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

