/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExternalDecimalSignValue implements Enumerator
{
    EBCDIC_LITERAL(0, "ebcdic", "ebcdic"),
    EBCDIC_CUSTOM_LITERAL(1, "ebcdicCustom", "ebcdicCustom"),
    ASCII_LITERAL(2, "ascii", "ascii");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int EBCDIC = 0;
    public static final int EBCDIC_CUSTOM = 1;
    public static final int ASCII = 2;
    private static final ExternalDecimalSignValue[] VALUES_ARRAY;
    public static final List<ExternalDecimalSignValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExternalDecimalSignValue[]{EBCDIC_LITERAL, EBCDIC_CUSTOM_LITERAL, ASCII_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExternalDecimalSignValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExternalDecimalSignValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExternalDecimalSignValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExternalDecimalSignValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExternalDecimalSignValue get(int value) {
        switch (value) {
            case 0: {
                return EBCDIC_LITERAL;
            }
            case 1: {
                return EBCDIC_CUSTOM_LITERAL;
            }
            case 2: {
                return ASCII_LITERAL;
            }
        }
        return null;
    }

    private ExternalDecimalSignValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

